/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchSuspendUserResponse extends ChimeResponse implements
        ToCopyableBuilder<BatchSuspendUserResponse.Builder, BatchSuspendUserResponse> {
    private static final SdkField<List<UserError>> USER_ERRORS_FIELD = SdkField
            .<List<UserError>> builder(MarshallingType.LIST)
            .memberName("UserErrors")
            .getter(getter(BatchSuspendUserResponse::userErrors))
            .setter(setter(Builder::userErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserError> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ERRORS_FIELD));

    private final List<UserError> userErrors;

    private BatchSuspendUserResponse(BuilderImpl builder) {
        super(builder);
        this.userErrors = builder.userErrors;
    }

    /**
     * Returns true if the UserErrors property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserErrors() {
        return userErrors != null && !(userErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the <a>BatchSuspendUser</a> action fails for one or more of the user IDs in the request, a list of the user
     * IDs is returned, along with error codes and error messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If the <a>BatchSuspendUser</a> action fails for one or more of the user IDs in the request, a list of the
     *         user IDs is returned, along with error codes and error messages.
     */
    public final List<UserError> userErrors() {
        return userErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserErrors() ? userErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchSuspendUserResponse)) {
            return false;
        }
        BatchSuspendUserResponse other = (BatchSuspendUserResponse) obj;
        return hasUserErrors() == other.hasUserErrors() && Objects.equals(userErrors(), other.userErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchSuspendUserResponse").add("UserErrors", hasUserErrors() ? userErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserErrors":
            return Optional.ofNullable(clazz.cast(userErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchSuspendUserResponse, T> g) {
        return obj -> g.apply((BatchSuspendUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchSuspendUserResponse> {
        /**
         * <p>
         * If the <a>BatchSuspendUser</a> action fails for one or more of the user IDs in the request, a list of the
         * user IDs is returned, along with error codes and error messages.
         * </p>
         * 
         * @param userErrors
         *        If the <a>BatchSuspendUser</a> action fails for one or more of the user IDs in the request, a list of
         *        the user IDs is returned, along with error codes and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userErrors(Collection<UserError> userErrors);

        /**
         * <p>
         * If the <a>BatchSuspendUser</a> action fails for one or more of the user IDs in the request, a list of the
         * user IDs is returned, along with error codes and error messages.
         * </p>
         * 
         * @param userErrors
         *        If the <a>BatchSuspendUser</a> action fails for one or more of the user IDs in the request, a list of
         *        the user IDs is returned, along with error codes and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userErrors(UserError... userErrors);

        /**
         * <p>
         * If the <a>BatchSuspendUser</a> action fails for one or more of the user IDs in the request, a list of the
         * user IDs is returned, along with error codes and error messages.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserError>.Builder} avoiding the need to
         * create one manually via {@link List<UserError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserError>.Builder#build()} is called immediately and its
         * result is passed to {@link #userErrors(List<UserError>)}.
         * 
         * @param userErrors
         *        a consumer that will call methods on {@link List<UserError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userErrors(List<UserError>)
         */
        Builder userErrors(Consumer<UserError.Builder>... userErrors);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<UserError> userErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchSuspendUserResponse model) {
            super(model);
            userErrors(model.userErrors);
        }

        public final Collection<UserError.Builder> getUserErrors() {
            if (userErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return userErrors != null ? userErrors.stream().map(UserError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userErrors(Collection<UserError> userErrors) {
            this.userErrors = UserErrorListCopier.copy(userErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userErrors(UserError... userErrors) {
            userErrors(Arrays.asList(userErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userErrors(Consumer<UserError.Builder>... userErrors) {
            userErrors(Stream.of(userErrors).map(c -> UserError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserErrors(Collection<UserError.BuilderImpl> userErrors) {
            this.userErrors = UserErrorListCopier.copyFromBuilder(userErrors);
        }

        @Override
        public BatchSuspendUserResponse build() {
            return new BatchSuspendUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
