/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeletePhoneNumberResponse extends ChimeResponse implements
        ToCopyableBuilder<BatchDeletePhoneNumberResponse.Builder, BatchDeletePhoneNumberResponse> {
    private static final SdkField<List<PhoneNumberError>> PHONE_NUMBER_ERRORS_FIELD = SdkField
            .<List<PhoneNumberError>> builder(MarshallingType.LIST)
            .memberName("PhoneNumberErrors")
            .getter(getter(BatchDeletePhoneNumberResponse::phoneNumberErrors))
            .setter(setter(Builder::phoneNumberErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumberError> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumberError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ERRORS_FIELD));

    private final List<PhoneNumberError> phoneNumberErrors;

    private BatchDeletePhoneNumberResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberErrors = builder.phoneNumberErrors;
    }

    /**
     * Returns true if the PhoneNumberErrors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPhoneNumberErrors() {
        return phoneNumberErrors != null && !(phoneNumberErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned,
     * along with error codes and error messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhoneNumberErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is
     *         returned, along with error codes and error messages.
     */
    public final List<PhoneNumberError> phoneNumberErrors() {
        return phoneNumberErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumberErrors() ? phoneNumberErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeletePhoneNumberResponse)) {
            return false;
        }
        BatchDeletePhoneNumberResponse other = (BatchDeletePhoneNumberResponse) obj;
        return hasPhoneNumberErrors() == other.hasPhoneNumberErrors()
                && Objects.equals(phoneNumberErrors(), other.phoneNumberErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeletePhoneNumberResponse")
                .add("PhoneNumberErrors", hasPhoneNumberErrors() ? phoneNumberErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberErrors":
            return Optional.ofNullable(clazz.cast(phoneNumberErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeletePhoneNumberResponse, T> g) {
        return obj -> g.apply((BatchDeletePhoneNumberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeletePhoneNumberResponse> {
        /**
         * <p>
         * If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is
         * returned, along with error codes and error messages.
         * </p>
         * 
         * @param phoneNumberErrors
         *        If the action fails for one or more of the phone numbers in the request, a list of the phone numbers
         *        is returned, along with error codes and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberErrors(Collection<PhoneNumberError> phoneNumberErrors);

        /**
         * <p>
         * If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is
         * returned, along with error codes and error messages.
         * </p>
         * 
         * @param phoneNumberErrors
         *        If the action fails for one or more of the phone numbers in the request, a list of the phone numbers
         *        is returned, along with error codes and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberErrors(PhoneNumberError... phoneNumberErrors);

        /**
         * <p>
         * If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is
         * returned, along with error codes and error messages.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PhoneNumberError>.Builder} avoiding the
         * need to create one manually via {@link List<PhoneNumberError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhoneNumberError>.Builder#build()} is called immediately and
         * its result is passed to {@link #phoneNumberErrors(List<PhoneNumberError>)}.
         * 
         * @param phoneNumberErrors
         *        a consumer that will call methods on {@link List<PhoneNumberError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumberErrors(List<PhoneNumberError>)
         */
        Builder phoneNumberErrors(Consumer<PhoneNumberError.Builder>... phoneNumberErrors);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<PhoneNumberError> phoneNumberErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeletePhoneNumberResponse model) {
            super(model);
            phoneNumberErrors(model.phoneNumberErrors);
        }

        public final Collection<PhoneNumberError.Builder> getPhoneNumberErrors() {
            if (phoneNumberErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return phoneNumberErrors != null ? phoneNumberErrors.stream().map(PhoneNumberError::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phoneNumberErrors(Collection<PhoneNumberError> phoneNumberErrors) {
            this.phoneNumberErrors = PhoneNumberErrorListCopier.copy(phoneNumberErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberErrors(PhoneNumberError... phoneNumberErrors) {
            phoneNumberErrors(Arrays.asList(phoneNumberErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberErrors(Consumer<PhoneNumberError.Builder>... phoneNumberErrors) {
            phoneNumberErrors(Stream.of(phoneNumberErrors).map(c -> PhoneNumberError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumberErrors(Collection<PhoneNumberError.BuilderImpl> phoneNumberErrors) {
            this.phoneNumberErrors = PhoneNumberErrorListCopier.copyFromBuilder(phoneNumberErrors);
        }

        @Override
        public BatchDeletePhoneNumberResponse build() {
            return new BatchDeletePhoneNumberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
