/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.SipMediaApplicationEndpoint;
import software.amazon.awssdk.services.chime.model.SipMediaApplicationEndpointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSipMediaApplicationRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, UpdateSipMediaApplicationRequest> {
    private static final SdkField<String> SIP_MEDIA_APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SipMediaApplicationId").getter(UpdateSipMediaApplicationRequest.getter(UpdateSipMediaApplicationRequest::sipMediaApplicationId)).setter(UpdateSipMediaApplicationRequest.setter(Builder::sipMediaApplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sipMediaApplicationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateSipMediaApplicationRequest.getter(UpdateSipMediaApplicationRequest::name)).setter(UpdateSipMediaApplicationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<SipMediaApplicationEndpoint>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(UpdateSipMediaApplicationRequest.getter(UpdateSipMediaApplicationRequest::endpoints)).setter(UpdateSipMediaApplicationRequest.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SipMediaApplicationEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_MEDIA_APPLICATION_ID_FIELD, NAME_FIELD, ENDPOINTS_FIELD));
    private final String sipMediaApplicationId;
    private final String name;
    private final List<SipMediaApplicationEndpoint> endpoints;

    private UpdateSipMediaApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.sipMediaApplicationId = builder.sipMediaApplicationId;
        this.name = builder.name;
        this.endpoints = builder.endpoints;
    }

    public String sipMediaApplicationId() {
        return this.sipMediaApplicationId;
    }

    public String name() {
        return this.name;
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public List<SipMediaApplicationEndpoint> endpoints() {
        return this.endpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sipMediaApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSipMediaApplicationRequest)) {
            return false;
        }
        UpdateSipMediaApplicationRequest other = (UpdateSipMediaApplicationRequest)((Object)obj);
        return Objects.equals(this.sipMediaApplicationId(), other.sipMediaApplicationId()) && Objects.equals(this.name(), other.name()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSipMediaApplicationRequest").add("SipMediaApplicationId", (Object)this.sipMediaApplicationId()).add("Name", (Object)this.name()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SipMediaApplicationId": {
                return Optional.ofNullable(clazz.cast(this.sipMediaApplicationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSipMediaApplicationRequest, T> g) {
        return obj -> g.apply((UpdateSipMediaApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String sipMediaApplicationId;
        private String name;
        private List<SipMediaApplicationEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSipMediaApplicationRequest model) {
            super(model);
            this.sipMediaApplicationId(model.sipMediaApplicationId);
            this.name(model.name);
            this.endpoints(model.endpoints);
        }

        public final String getSipMediaApplicationId() {
            return this.sipMediaApplicationId;
        }

        @Override
        public final Builder sipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
            return this;
        }

        public final void setSipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SipMediaApplicationEndpoint.Builder> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpoints != null ? (Collection)this.endpoints.stream().map(SipMediaApplicationEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpoints(Collection<SipMediaApplicationEndpoint> endpoints) {
            this.endpoints = SipMediaApplicationEndpointListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(SipMediaApplicationEndpoint ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<SipMediaApplicationEndpoint.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (SipMediaApplicationEndpoint)((SipMediaApplicationEndpoint.Builder)SipMediaApplicationEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpoints(Collection<SipMediaApplicationEndpoint.BuilderImpl> endpoints) {
            this.endpoints = SipMediaApplicationEndpointListCopier.copyFromBuilder(endpoints);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSipMediaApplicationRequest build() {
            return new UpdateSipMediaApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSipMediaApplicationRequest> {
        public Builder sipMediaApplicationId(String var1);

        public Builder name(String var1);

        public Builder endpoints(Collection<SipMediaApplicationEndpoint> var1);

        public Builder endpoints(SipMediaApplicationEndpoint ... var1);

        public Builder endpoints(Consumer<SipMediaApplicationEndpoint.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

