/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.AppInstanceStreamingConfiguration;
import software.amazon.awssdk.services.chime.model.AppInstanceStreamingConfigurationListCopier;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAppInstanceStreamingConfigurationsRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, PutAppInstanceStreamingConfigurationsRequest> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceArn").getter(PutAppInstanceStreamingConfigurationsRequest.getter(PutAppInstanceStreamingConfigurationsRequest::appInstanceArn)).setter(PutAppInstanceStreamingConfigurationsRequest.setter(Builder::appInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceArn").build()}).build();
    private static final SdkField<List<AppInstanceStreamingConfiguration>> APP_INSTANCE_STREAMING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppInstanceStreamingConfigurations").getter(PutAppInstanceStreamingConfigurationsRequest.getter(PutAppInstanceStreamingConfigurationsRequest::appInstanceStreamingConfigurations)).setter(PutAppInstanceStreamingConfigurationsRequest.setter(Builder::appInstanceStreamingConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceStreamingConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppInstanceStreamingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD, APP_INSTANCE_STREAMING_CONFIGURATIONS_FIELD));
    private final String appInstanceArn;
    private final List<AppInstanceStreamingConfiguration> appInstanceStreamingConfigurations;

    private PutAppInstanceStreamingConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.appInstanceStreamingConfigurations = builder.appInstanceStreamingConfigurations;
    }

    public String appInstanceArn() {
        return this.appInstanceArn;
    }

    public boolean hasAppInstanceStreamingConfigurations() {
        return this.appInstanceStreamingConfigurations != null && !(this.appInstanceStreamingConfigurations instanceof SdkAutoConstructList);
    }

    public List<AppInstanceStreamingConfiguration> appInstanceStreamingConfigurations() {
        return this.appInstanceStreamingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppInstanceStreamingConfigurations() ? this.appInstanceStreamingConfigurations() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAppInstanceStreamingConfigurationsRequest)) {
            return false;
        }
        PutAppInstanceStreamingConfigurationsRequest other = (PutAppInstanceStreamingConfigurationsRequest)((Object)obj);
        return Objects.equals(this.appInstanceArn(), other.appInstanceArn()) && this.hasAppInstanceStreamingConfigurations() == other.hasAppInstanceStreamingConfigurations() && Objects.equals(this.appInstanceStreamingConfigurations(), other.appInstanceStreamingConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"PutAppInstanceStreamingConfigurationsRequest").add("AppInstanceArn", (Object)this.appInstanceArn()).add("AppInstanceStreamingConfigurations", this.hasAppInstanceStreamingConfigurations() ? this.appInstanceStreamingConfigurations() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceArn()));
            }
            case "AppInstanceStreamingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.appInstanceStreamingConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAppInstanceStreamingConfigurationsRequest, T> g) {
        return obj -> g.apply((PutAppInstanceStreamingConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String appInstanceArn;
        private List<AppInstanceStreamingConfiguration> appInstanceStreamingConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAppInstanceStreamingConfigurationsRequest model) {
            super(model);
            this.appInstanceArn(model.appInstanceArn);
            this.appInstanceStreamingConfigurations(model.appInstanceStreamingConfigurations);
        }

        public final String getAppInstanceArn() {
            return this.appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        public final Collection<AppInstanceStreamingConfiguration.Builder> getAppInstanceStreamingConfigurations() {
            if (this.appInstanceStreamingConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.appInstanceStreamingConfigurations != null ? (Collection)this.appInstanceStreamingConfigurations.stream().map(AppInstanceStreamingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder appInstanceStreamingConfigurations(Collection<AppInstanceStreamingConfiguration> appInstanceStreamingConfigurations) {
            this.appInstanceStreamingConfigurations = AppInstanceStreamingConfigurationListCopier.copy(appInstanceStreamingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceStreamingConfigurations(AppInstanceStreamingConfiguration ... appInstanceStreamingConfigurations) {
            this.appInstanceStreamingConfigurations(Arrays.asList(appInstanceStreamingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceStreamingConfigurations(Consumer<AppInstanceStreamingConfiguration.Builder> ... appInstanceStreamingConfigurations) {
            this.appInstanceStreamingConfigurations(Stream.of(appInstanceStreamingConfigurations).map(c -> (AppInstanceStreamingConfiguration)((AppInstanceStreamingConfiguration.Builder)AppInstanceStreamingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAppInstanceStreamingConfigurations(Collection<AppInstanceStreamingConfiguration.BuilderImpl> appInstanceStreamingConfigurations) {
            this.appInstanceStreamingConfigurations = AppInstanceStreamingConfigurationListCopier.copyFromBuilder(appInstanceStreamingConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAppInstanceStreamingConfigurationsRequest build() {
            return new PutAppInstanceStreamingConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAppInstanceStreamingConfigurationsRequest> {
        public Builder appInstanceArn(String var1);

        public Builder appInstanceStreamingConfigurations(Collection<AppInstanceStreamingConfiguration> var1);

        public Builder appInstanceStreamingConfigurations(AppInstanceStreamingConfiguration ... var1);

        public Builder appInstanceStreamingConfigurations(Consumer<AppInstanceStreamingConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

