/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPhoneNumberSettingsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, GetPhoneNumberSettingsResponse> {
    private static final SdkField<String> CALLING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallingName").getter(GetPhoneNumberSettingsResponse.getter(GetPhoneNumberSettingsResponse::callingName)).setter(GetPhoneNumberSettingsResponse.setter(Builder::callingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingName").build()}).build();
    private static final SdkField<Instant> CALLING_NAME_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CallingNameUpdatedTimestamp").getter(GetPhoneNumberSettingsResponse.getter(GetPhoneNumberSettingsResponse::callingNameUpdatedTimestamp)).setter(GetPhoneNumberSettingsResponse.setter(Builder::callingNameUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingNameUpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLING_NAME_FIELD, CALLING_NAME_UPDATED_TIMESTAMP_FIELD));
    private final String callingName;
    private final Instant callingNameUpdatedTimestamp;

    private GetPhoneNumberSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.callingName = builder.callingName;
        this.callingNameUpdatedTimestamp = builder.callingNameUpdatedTimestamp;
    }

    public String callingName() {
        return this.callingName;
    }

    public Instant callingNameUpdatedTimestamp() {
        return this.callingNameUpdatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.callingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.callingNameUpdatedTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPhoneNumberSettingsResponse)) {
            return false;
        }
        GetPhoneNumberSettingsResponse other = (GetPhoneNumberSettingsResponse)((Object)obj);
        return Objects.equals(this.callingName(), other.callingName()) && Objects.equals(this.callingNameUpdatedTimestamp(), other.callingNameUpdatedTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"GetPhoneNumberSettingsResponse").add("CallingName", (Object)(this.callingName() == null ? null : "*** Sensitive Data Redacted ***")).add("CallingNameUpdatedTimestamp", (Object)this.callingNameUpdatedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallingName": {
                return Optional.ofNullable(clazz.cast(this.callingName()));
            }
            case "CallingNameUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.callingNameUpdatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPhoneNumberSettingsResponse, T> g) {
        return obj -> g.apply((GetPhoneNumberSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private String callingName;
        private Instant callingNameUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPhoneNumberSettingsResponse model) {
            super(model);
            this.callingName(model.callingName);
            this.callingNameUpdatedTimestamp(model.callingNameUpdatedTimestamp);
        }

        public final String getCallingName() {
            return this.callingName;
        }

        @Override
        public final Builder callingName(String callingName) {
            this.callingName = callingName;
            return this;
        }

        public final void setCallingName(String callingName) {
            this.callingName = callingName;
        }

        public final Instant getCallingNameUpdatedTimestamp() {
            return this.callingNameUpdatedTimestamp;
        }

        @Override
        public final Builder callingNameUpdatedTimestamp(Instant callingNameUpdatedTimestamp) {
            this.callingNameUpdatedTimestamp = callingNameUpdatedTimestamp;
            return this;
        }

        public final void setCallingNameUpdatedTimestamp(Instant callingNameUpdatedTimestamp) {
            this.callingNameUpdatedTimestamp = callingNameUpdatedTimestamp;
        }

        @Override
        public GetPhoneNumberSettingsResponse build() {
            return new GetPhoneNumberSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPhoneNumberSettingsResponse> {
        public Builder callingName(String var1);

        public Builder callingNameUpdatedTimestamp(Instant var1);
    }
}

