/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeletePhoneNumberRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, BatchDeletePhoneNumberRequest> {
    private static final SdkField<List<String>> PHONE_NUMBER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberIds").getter(BatchDeletePhoneNumberRequest.getter(BatchDeletePhoneNumberRequest::phoneNumberIds)).setter(BatchDeletePhoneNumberRequest.setter(Builder::phoneNumberIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_IDS_FIELD));
    private final List<String> phoneNumberIds;

    private BatchDeletePhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumberIds = builder.phoneNumberIds;
    }

    public boolean hasPhoneNumberIds() {
        return this.phoneNumberIds != null && !(this.phoneNumberIds instanceof SdkAutoConstructList);
    }

    public List<String> phoneNumberIds() {
        return this.phoneNumberIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeletePhoneNumberRequest)) {
            return false;
        }
        BatchDeletePhoneNumberRequest other = (BatchDeletePhoneNumberRequest)((Object)obj);
        return Objects.equals(this.phoneNumberIds(), other.phoneNumberIds());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeletePhoneNumberRequest").add("PhoneNumberIds", this.phoneNumberIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberIds": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeletePhoneNumberRequest, T> g) {
        return obj -> g.apply((BatchDeletePhoneNumberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private List<String> phoneNumberIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeletePhoneNumberRequest model) {
            super(model);
            this.phoneNumberIds(model.phoneNumberIds);
        }

        public final Collection<String> getPhoneNumberIds() {
            return this.phoneNumberIds;
        }

        @Override
        public final Builder phoneNumberIds(Collection<String> phoneNumberIds) {
            this.phoneNumberIds = NonEmptyStringListCopier.copy(phoneNumberIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberIds(String ... phoneNumberIds) {
            this.phoneNumberIds(Arrays.asList(phoneNumberIds));
            return this;
        }

        public final void setPhoneNumberIds(Collection<String> phoneNumberIds) {
            this.phoneNumberIds = NonEmptyStringListCopier.copy(phoneNumberIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeletePhoneNumberRequest build() {
            return new BatchDeletePhoneNumberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeletePhoneNumberRequest> {
        public Builder phoneNumberIds(Collection<String> var1);

        public Builder phoneNumberIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

