/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.Member;
import software.amazon.awssdk.services.chime.model.RoomMembershipRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoomMembership
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoomMembership> {
    private static final SdkField<String> ROOM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoomMembership.getter(RoomMembership::roomId)).setter(RoomMembership.setter(Builder::roomId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomId").build()}).build();
    private static final SdkField<Member> MEMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RoomMembership.getter(RoomMembership::member)).setter(RoomMembership.setter(Builder::member)).constructor(Member::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Member").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoomMembership.getter(RoomMembership::roleAsString)).setter(RoomMembership.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> INVITED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoomMembership.getter(RoomMembership::invitedBy)).setter(RoomMembership.setter(Builder::invitedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedBy").build()}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RoomMembership.getter(RoomMembership::updatedTimestamp)).setter(RoomMembership.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ID_FIELD, MEMBER_FIELD, ROLE_FIELD, INVITED_BY_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roomId;
    private final Member member;
    private final String role;
    private final String invitedBy;
    private final Instant updatedTimestamp;

    private RoomMembership(BuilderImpl builder) {
        this.roomId = builder.roomId;
        this.member = builder.member;
        this.role = builder.role;
        this.invitedBy = builder.invitedBy;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public String roomId() {
        return this.roomId;
    }

    public Member member() {
        return this.member;
    }

    public RoomMembershipRole role() {
        return RoomMembershipRole.fromValue(this.role);
    }

    public String roleAsString() {
        return this.role;
    }

    public String invitedBy() {
        return this.invitedBy;
    }

    public Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roomId());
        hashCode = 31 * hashCode + Objects.hashCode(this.member());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoomMembership)) {
            return false;
        }
        RoomMembership other = (RoomMembership)obj;
        return Objects.equals(this.roomId(), other.roomId()) && Objects.equals(this.member(), other.member()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.invitedBy(), other.invitedBy()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"RoomMembership").add("RoomId", (Object)this.roomId()).add("Member", (Object)this.member()).add("Role", (Object)this.roleAsString()).add("InvitedBy", (Object)this.invitedBy()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomId": {
                return Optional.ofNullable(clazz.cast(this.roomId()));
            }
            case "Member": {
                return Optional.ofNullable(clazz.cast(this.member()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "InvitedBy": {
                return Optional.ofNullable(clazz.cast(this.invitedBy()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoomMembership, T> g) {
        return obj -> g.apply((RoomMembership)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roomId;
        private Member member;
        private String role;
        private String invitedBy;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RoomMembership model) {
            this.roomId(model.roomId);
            this.member(model.member);
            this.role(model.role);
            this.invitedBy(model.invitedBy);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getRoomId() {
            return this.roomId;
        }

        @Override
        public final Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public final void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        public final Member.Builder getMember() {
            return this.member != null ? this.member.toBuilder() : null;
        }

        @Override
        public final Builder member(Member member) {
            this.member = member;
            return this;
        }

        public final void setMember(Member.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoomMembershipRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getInvitedBy() {
            return this.invitedBy;
        }

        @Override
        public final Builder invitedBy(String invitedBy) {
            this.invitedBy = invitedBy;
            return this;
        }

        public final void setInvitedBy(String invitedBy) {
            this.invitedBy = invitedBy;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        public RoomMembership build() {
            return new RoomMembership(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoomMembership> {
        public Builder roomId(String var1);

        public Builder member(Member var1);

        default public Builder member(Consumer<Member.Builder> member) {
            return this.member((Member)((Member.Builder)Member.builder().applyMutation(member)).build());
        }

        public Builder role(String var1);

        public Builder role(RoomMembershipRole var1);

        public Builder invitedBy(String var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

