/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Chime Voice Connector settings. Includes any Amazon S3 buckets designated for storing call detail records.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceConnectorSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceConnectorSettings.Builder, VoiceConnectorSettings> {
    private static final SdkField<String> CDR_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceConnectorSettings::cdrBucket)).setter(setter(Builder::cdrBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdrBucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDR_BUCKET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cdrBucket;

    private VoiceConnectorSettings(BuilderImpl builder) {
        this.cdrBucket = builder.cdrBucket;
    }

    /**
     * <p>
     * The Amazon S3 bucket designated for call detail record storage.
     * </p>
     * 
     * @return The Amazon S3 bucket designated for call detail record storage.
     */
    public String cdrBucket() {
        return cdrBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cdrBucket());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceConnectorSettings)) {
            return false;
        }
        VoiceConnectorSettings other = (VoiceConnectorSettings) obj;
        return Objects.equals(cdrBucket(), other.cdrBucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VoiceConnectorSettings").add("CdrBucket", cdrBucket()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CdrBucket":
            return Optional.ofNullable(clazz.cast(cdrBucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceConnectorSettings, T> g) {
        return obj -> g.apply((VoiceConnectorSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceConnectorSettings> {
        /**
         * <p>
         * The Amazon S3 bucket designated for call detail record storage.
         * </p>
         * 
         * @param cdrBucket
         *        The Amazon S3 bucket designated for call detail record storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdrBucket(String cdrBucket);
    }

    static final class BuilderImpl implements Builder {
        private String cdrBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceConnectorSettings model) {
            cdrBucket(model.cdrBucket);
        }

        public final String getCdrBucket() {
            return cdrBucket;
        }

        @Override
        public final Builder cdrBucket(String cdrBucket) {
            this.cdrBucket = cdrBucket;
            return this;
        }

        public final void setCdrBucket(String cdrBucket) {
            this.cdrBucket = cdrBucket;
        }

        @Override
        public VoiceConnectorSettings build() {
            return new VoiceConnectorSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
