/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Chime Voice Connector group configuration, including associated Amazon Chime Voice Connectors. You can
 * include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant
 * mechanism for fallback in case of availability events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceConnectorGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceConnectorGroup.Builder, VoiceConnectorGroup> {
    private static final SdkField<String> VOICE_CONNECTOR_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceConnectorGroup::voiceConnectorGroupId)).setter(setter(Builder::voiceConnectorGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorGroupId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceConnectorGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<VoiceConnectorItem>> VOICE_CONNECTOR_ITEMS_FIELD = SdkField
            .<List<VoiceConnectorItem>> builder(MarshallingType.LIST)
            .getter(getter(VoiceConnectorGroup::voiceConnectorItems))
            .setter(setter(Builder::voiceConnectorItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VoiceConnectorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(VoiceConnectorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(VoiceConnectorGroup::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(VoiceConnectorGroup::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VOICE_CONNECTOR_GROUP_ID_FIELD, NAME_FIELD, VOICE_CONNECTOR_ITEMS_FIELD, CREATED_TIMESTAMP_FIELD,
            UPDATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String voiceConnectorGroupId;

    private final String name;

    private final List<VoiceConnectorItem> voiceConnectorItems;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private VoiceConnectorGroup(BuilderImpl builder) {
        this.voiceConnectorGroupId = builder.voiceConnectorGroupId;
        this.name = builder.name;
        this.voiceConnectorItems = builder.voiceConnectorItems;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The Amazon Chime Voice Connector group ID.
     * </p>
     * 
     * @return The Amazon Chime Voice Connector group ID.
     */
    public String voiceConnectorGroupId() {
        return voiceConnectorGroupId;
    }

    /**
     * <p>
     * The name of the Amazon Chime Voice Connector group.
     * </p>
     * 
     * @return The name of the Amazon Chime Voice Connector group.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the VoiceConnectorItems property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVoiceConnectorItems() {
        return voiceConnectorItems != null && !(voiceConnectorItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Chime Voice Connectors to which to route inbound calls.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVoiceConnectorItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Chime Voice Connectors to which to route inbound calls.
     */
    public List<VoiceConnectorItem> voiceConnectorItems() {
        return voiceConnectorItems;
    }

    /**
     * <p>
     * The Amazon Chime Voice Connector group creation timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The Amazon Chime Voice Connector group creation timestamp, in ISO 8601 format.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The updated Amazon Chime Voice Connector group timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The updated Amazon Chime Voice Connector group timestamp, in ISO 8601 format.
     */
    public Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorItems());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceConnectorGroup)) {
            return false;
        }
        VoiceConnectorGroup other = (VoiceConnectorGroup) obj;
        return Objects.equals(voiceConnectorGroupId(), other.voiceConnectorGroupId()) && Objects.equals(name(), other.name())
                && Objects.equals(voiceConnectorItems(), other.voiceConnectorItems())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VoiceConnectorGroup").add("VoiceConnectorGroupId", voiceConnectorGroupId()).add("Name", name())
                .add("VoiceConnectorItems", voiceConnectorItems()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorGroupId":
            return Optional.ofNullable(clazz.cast(voiceConnectorGroupId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VoiceConnectorItems":
            return Optional.ofNullable(clazz.cast(voiceConnectorItems()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceConnectorGroup, T> g) {
        return obj -> g.apply((VoiceConnectorGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceConnectorGroup> {
        /**
         * <p>
         * The Amazon Chime Voice Connector group ID.
         * </p>
         * 
         * @param voiceConnectorGroupId
         *        The Amazon Chime Voice Connector group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorGroupId(String voiceConnectorGroupId);

        /**
         * <p>
         * The name of the Amazon Chime Voice Connector group.
         * </p>
         * 
         * @param name
         *        The name of the Amazon Chime Voice Connector group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Chime Voice Connectors to which to route inbound calls.
         * </p>
         * 
         * @param voiceConnectorItems
         *        The Amazon Chime Voice Connectors to which to route inbound calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorItems(Collection<VoiceConnectorItem> voiceConnectorItems);

        /**
         * <p>
         * The Amazon Chime Voice Connectors to which to route inbound calls.
         * </p>
         * 
         * @param voiceConnectorItems
         *        The Amazon Chime Voice Connectors to which to route inbound calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorItems(VoiceConnectorItem... voiceConnectorItems);

        /**
         * <p>
         * The Amazon Chime Voice Connectors to which to route inbound calls.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VoiceConnectorItem>.Builder} avoiding the
         * need to create one manually via {@link List<VoiceConnectorItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VoiceConnectorItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #voiceConnectorItems(List<VoiceConnectorItem>)}.
         * 
         * @param voiceConnectorItems
         *        a consumer that will call methods on {@link List<VoiceConnectorItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceConnectorItems(List<VoiceConnectorItem>)
         */
        Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder>... voiceConnectorItems);

        /**
         * <p>
         * The Amazon Chime Voice Connector group creation timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param createdTimestamp
         *        The Amazon Chime Voice Connector group creation timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The updated Amazon Chime Voice Connector group timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The updated Amazon Chime Voice Connector group timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String voiceConnectorGroupId;

        private String name;

        private List<VoiceConnectorItem> voiceConnectorItems = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceConnectorGroup model) {
            voiceConnectorGroupId(model.voiceConnectorGroupId);
            name(model.name);
            voiceConnectorItems(model.voiceConnectorItems);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getVoiceConnectorGroupId() {
            return voiceConnectorGroupId;
        }

        @Override
        public final Builder voiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
            return this;
        }

        public final void setVoiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<VoiceConnectorItem.Builder> getVoiceConnectorItems() {
            return voiceConnectorItems != null ? voiceConnectorItems.stream().map(VoiceConnectorItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder voiceConnectorItems(Collection<VoiceConnectorItem> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copy(voiceConnectorItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorItems(VoiceConnectorItem... voiceConnectorItems) {
            voiceConnectorItems(Arrays.asList(voiceConnectorItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder>... voiceConnectorItems) {
            voiceConnectorItems(Stream.of(voiceConnectorItems).map(c -> VoiceConnectorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVoiceConnectorItems(Collection<VoiceConnectorItem.BuilderImpl> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copyFromBuilder(voiceConnectorItems);
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public VoiceConnectorGroup build() {
            return new VoiceConnectorGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
