/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVoiceConnectorResponse extends ChimeResponse implements
        ToCopyableBuilder<UpdateVoiceConnectorResponse.Builder, UpdateVoiceConnectorResponse> {
    private static final SdkField<VoiceConnector> VOICE_CONNECTOR_FIELD = SdkField
            .<VoiceConnector> builder(MarshallingType.SDK_POJO).getter(getter(UpdateVoiceConnectorResponse::voiceConnector))
            .setter(setter(Builder::voiceConnector)).constructor(VoiceConnector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_FIELD));

    private final VoiceConnector voiceConnector;

    private UpdateVoiceConnectorResponse(BuilderImpl builder) {
        super(builder);
        this.voiceConnector = builder.voiceConnector;
    }

    /**
     * <p>
     * The updated Amazon Chime Voice Connector details.
     * </p>
     * 
     * @return The updated Amazon Chime Voice Connector details.
     */
    public VoiceConnector voiceConnector() {
        return voiceConnector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnector());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVoiceConnectorResponse)) {
            return false;
        }
        UpdateVoiceConnectorResponse other = (UpdateVoiceConnectorResponse) obj;
        return Objects.equals(voiceConnector(), other.voiceConnector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateVoiceConnectorResponse").add("VoiceConnector", voiceConnector()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnector":
            return Optional.ofNullable(clazz.cast(voiceConnector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVoiceConnectorResponse, T> g) {
        return obj -> g.apply((UpdateVoiceConnectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVoiceConnectorResponse> {
        /**
         * <p>
         * The updated Amazon Chime Voice Connector details.
         * </p>
         * 
         * @param voiceConnector
         *        The updated Amazon Chime Voice Connector details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnector(VoiceConnector voiceConnector);

        /**
         * <p>
         * The updated Amazon Chime Voice Connector details.
         * </p>
         * This is a convenience that creates an instance of the {@link VoiceConnector.Builder} avoiding the need to
         * create one manually via {@link VoiceConnector#builder()}.
         *
         * When the {@link Consumer} completes, {@link VoiceConnector.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceConnector(VoiceConnector)}.
         * 
         * @param voiceConnector
         *        a consumer that will call methods on {@link VoiceConnector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceConnector(VoiceConnector)
         */
        default Builder voiceConnector(Consumer<VoiceConnector.Builder> voiceConnector) {
            return voiceConnector(VoiceConnector.builder().applyMutation(voiceConnector).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private VoiceConnector voiceConnector;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVoiceConnectorResponse model) {
            super(model);
            voiceConnector(model.voiceConnector);
        }

        public final VoiceConnector.Builder getVoiceConnector() {
            return voiceConnector != null ? voiceConnector.toBuilder() : null;
        }

        @Override
        public final Builder voiceConnector(VoiceConnector voiceConnector) {
            this.voiceConnector = voiceConnector;
            return this;
        }

        public final void setVoiceConnector(VoiceConnector.BuilderImpl voiceConnector) {
            this.voiceConnector = voiceConnector != null ? voiceConnector.build() : null;
        }

        @Override
        public UpdateVoiceConnectorResponse build() {
            return new UpdateVoiceConnectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
