/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountSettingsRequest extends ChimeRequest implements
        ToCopyableBuilder<UpdateAccountSettingsRequest.Builder, UpdateAccountSettingsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateAccountSettingsRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()).build();

    private static final SdkField<AccountSettings> ACCOUNT_SETTINGS_FIELD = SdkField
            .<AccountSettings> builder(MarshallingType.SDK_POJO).getter(getter(UpdateAccountSettingsRequest::accountSettings))
            .setter(setter(Builder::accountSettings)).constructor(AccountSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ACCOUNT_SETTINGS_FIELD));

    private final String accountId;

    private final AccountSettings accountSettings;

    private UpdateAccountSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.accountSettings = builder.accountSettings;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Chime account settings to update.
     * </p>
     * 
     * @return The Amazon Chime account settings to update.
     */
    public AccountSettings accountSettings() {
        return accountSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accountSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsRequest)) {
            return false;
        }
        UpdateAccountSettingsRequest other = (UpdateAccountSettingsRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(accountSettings(), other.accountSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateAccountSettingsRequest").add("AccountId", accountId())
                .add("AccountSettings", accountSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AccountSettings":
            return Optional.ofNullable(clazz.cast(accountSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsRequest, T> g) {
        return obj -> g.apply((UpdateAccountSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccountSettingsRequest> {
        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Chime account settings to update.
         * </p>
         * 
         * @param accountSettings
         *        The Amazon Chime account settings to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSettings(AccountSettings accountSettings);

        /**
         * <p>
         * The Amazon Chime account settings to update.
         * </p>
         * This is a convenience that creates an instance of the {@link AccountSettings.Builder} avoiding the need to
         * create one manually via {@link AccountSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #accountSettings(AccountSettings)}.
         * 
         * @param accountSettings
         *        a consumer that will call methods on {@link AccountSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountSettings(AccountSettings)
         */
        default Builder accountSettings(Consumer<AccountSettings.Builder> accountSettings) {
            return accountSettings(AccountSettings.builder().applyMutation(accountSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String accountId;

        private AccountSettings accountSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsRequest model) {
            super(model);
            accountId(model.accountId);
            accountSettings(model.accountSettings);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final AccountSettings.Builder getAccountSettings() {
            return accountSettings != null ? accountSettings.toBuilder() : null;
        }

        @Override
        public final Builder accountSettings(AccountSettings accountSettings) {
            this.accountSettings = accountSettings;
            return this;
        }

        public final void setAccountSettings(AccountSettings.BuilderImpl accountSettings) {
            this.accountSettings = accountSettings != null ? accountSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountSettingsRequest build() {
            return new UpdateAccountSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
