/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The targeted recipient for a streaming configuration notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingNotificationTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingNotificationTarget.Builder, StreamingNotificationTarget> {
    private static final SdkField<String> NOTIFICATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StreamingNotificationTarget::notificationTargetAsString)).setter(setter(Builder::notificationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTarget").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String notificationTarget;

    private StreamingNotificationTarget(BuilderImpl builder) {
        this.notificationTarget = builder.notificationTarget;
    }

    /**
     * <p>
     * The streaming notification target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notificationTarget} will return {@link NotificationTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #notificationTargetAsString}.
     * </p>
     * 
     * @return The streaming notification target.
     * @see NotificationTarget
     */
    public NotificationTarget notificationTarget() {
        return NotificationTarget.fromValue(notificationTarget);
    }

    /**
     * <p>
     * The streaming notification target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notificationTarget} will return {@link NotificationTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #notificationTargetAsString}.
     * </p>
     * 
     * @return The streaming notification target.
     * @see NotificationTarget
     */
    public String notificationTargetAsString() {
        return notificationTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notificationTargetAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingNotificationTarget)) {
            return false;
        }
        StreamingNotificationTarget other = (StreamingNotificationTarget) obj;
        return Objects.equals(notificationTargetAsString(), other.notificationTargetAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StreamingNotificationTarget").add("NotificationTarget", notificationTargetAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotificationTarget":
            return Optional.ofNullable(clazz.cast(notificationTargetAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingNotificationTarget, T> g) {
        return obj -> g.apply((StreamingNotificationTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingNotificationTarget> {
        /**
         * <p>
         * The streaming notification target.
         * </p>
         * 
         * @param notificationTarget
         *        The streaming notification target.
         * @see NotificationTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationTarget
         */
        Builder notificationTarget(String notificationTarget);

        /**
         * <p>
         * The streaming notification target.
         * </p>
         * 
         * @param notificationTarget
         *        The streaming notification target.
         * @see NotificationTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationTarget
         */
        Builder notificationTarget(NotificationTarget notificationTarget);
    }

    static final class BuilderImpl implements Builder {
        private String notificationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingNotificationTarget model) {
            notificationTarget(model.notificationTarget);
        }

        public final String getNotificationTarget() {
            return notificationTarget;
        }

        @Override
        public final Builder notificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
            return this;
        }

        @Override
        public final Builder notificationTarget(NotificationTarget notificationTarget) {
            this.notificationTarget(notificationTarget == null ? null : notificationTarget.toString());
            return this;
        }

        public final void setNotificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
        }

        @Override
        public StreamingNotificationTarget build() {
            return new StreamingNotificationTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
