/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVoiceConnectorTerminationCredentialsRequest extends ChimeRequest implements
        ToCopyableBuilder<PutVoiceConnectorTerminationCredentialsRequest.Builder, PutVoiceConnectorTerminationCredentialsRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutVoiceConnectorTerminationCredentialsRequest::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()).build();

    private static final SdkField<List<Credential>> CREDENTIALS_FIELD = SdkField
            .<List<Credential>> builder(MarshallingType.LIST)
            .getter(getter(PutVoiceConnectorTerminationCredentialsRequest::credentials))
            .setter(setter(Builder::credentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Credential> builder(MarshallingType.SDK_POJO)
                                            .constructor(Credential::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            CREDENTIALS_FIELD));

    private final String voiceConnectorId;

    private final List<Credential> credentials;

    private PutVoiceConnectorTerminationCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.credentials = builder.credentials;
    }

    /**
     * <p>
     * The Amazon Chime Voice Connector ID.
     * </p>
     * 
     * @return The Amazon Chime Voice Connector ID.
     */
    public String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * Returns true if the Credentials property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCredentials() {
        return credentials != null && !(credentials instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The termination SIP credentials.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCredentials()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The termination SIP credentials.
     */
    public List<Credential> credentials() {
        return credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorTerminationCredentialsRequest)) {
            return false;
        }
        PutVoiceConnectorTerminationCredentialsRequest other = (PutVoiceConnectorTerminationCredentialsRequest) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(credentials(), other.credentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutVoiceConnectorTerminationCredentialsRequest").add("VoiceConnectorId", voiceConnectorId())
                .add("Credentials", credentials()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorTerminationCredentialsRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorTerminationCredentialsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutVoiceConnectorTerminationCredentialsRequest> {
        /**
         * <p>
         * The Amazon Chime Voice Connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Amazon Chime Voice Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The termination SIP credentials.
         * </p>
         * 
         * @param credentials
         *        The termination SIP credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Collection<Credential> credentials);

        /**
         * <p>
         * The termination SIP credentials.
         * </p>
         * 
         * @param credentials
         *        The termination SIP credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credential... credentials);

        /**
         * <p>
         * The termination SIP credentials.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Credential>.Builder} avoiding the need to
         * create one manually via {@link List<Credential>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Credential>.Builder#build()} is called immediately and its
         * result is passed to {@link #credentials(List<Credential>)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link List<Credential>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(List<Credential>)
         */
        Builder credentials(Consumer<Credential.Builder>... credentials);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String voiceConnectorId;

        private List<Credential> credentials = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorTerminationCredentialsRequest model) {
            super(model);
            voiceConnectorId(model.voiceConnectorId);
            credentials(model.credentials);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        public final Collection<Credential.Builder> getCredentials() {
            return credentials != null ? credentials.stream().map(Credential::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder credentials(Collection<Credential> credentials) {
            this.credentials = CredentialListCopier.copy(credentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Credential... credentials) {
            credentials(Arrays.asList(credentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Consumer<Credential.Builder>... credentials) {
            credentials(Stream.of(credentials).map(c -> Credential.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCredentials(Collection<Credential.BuilderImpl> credentials) {
            this.credentials = CredentialListCopier.copyFromBuilder(credentials);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorTerminationCredentialsRequest build() {
            return new PutVoiceConnectorTerminationCredentialsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
