/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVoiceConnectorOriginationResponse extends ChimeResponse implements
        ToCopyableBuilder<PutVoiceConnectorOriginationResponse.Builder, PutVoiceConnectorOriginationResponse> {
    private static final SdkField<Origination> ORIGINATION_FIELD = SdkField.<Origination> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutVoiceConnectorOriginationResponse::origination)).setter(setter(Builder::origination))
            .constructor(Origination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINATION_FIELD));

    private final Origination origination;

    private PutVoiceConnectorOriginationResponse(BuilderImpl builder) {
        super(builder);
        this.origination = builder.origination;
    }

    /**
     * <p>
     * The updated origination setting details.
     * </p>
     * 
     * @return The updated origination setting details.
     */
    public Origination origination() {
        return origination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(origination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorOriginationResponse)) {
            return false;
        }
        PutVoiceConnectorOriginationResponse other = (PutVoiceConnectorOriginationResponse) obj;
        return Objects.equals(origination(), other.origination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutVoiceConnectorOriginationResponse").add("Origination", origination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Origination":
            return Optional.ofNullable(clazz.cast(origination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorOriginationResponse, T> g) {
        return obj -> g.apply((PutVoiceConnectorOriginationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutVoiceConnectorOriginationResponse> {
        /**
         * <p>
         * The updated origination setting details.
         * </p>
         * 
         * @param origination
         *        The updated origination setting details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origination(Origination origination);

        /**
         * <p>
         * The updated origination setting details.
         * </p>
         * This is a convenience that creates an instance of the {@link Origination.Builder} avoiding the need to create
         * one manually via {@link Origination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Origination.Builder#build()} is called immediately and its result
         * is passed to {@link #origination(Origination)}.
         * 
         * @param origination
         *        a consumer that will call methods on {@link Origination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #origination(Origination)
         */
        default Builder origination(Consumer<Origination.Builder> origination) {
            return origination(Origination.builder().applyMutation(origination).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private Origination origination;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorOriginationResponse model) {
            super(model);
            origination(model.origination);
        }

        public final Origination.Builder getOrigination() {
            return origination != null ? origination.toBuilder() : null;
        }

        @Override
        public final Builder origination(Origination origination) {
            this.origination = origination;
            return this;
        }

        public final void setOrigination(Origination.BuilderImpl origination) {
            this.origination = origination != null ? origination.build() : null;
        }

        @Override
        public PutVoiceConnectorOriginationResponse build() {
            return new PutVoiceConnectorOriginationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
