/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A meeting created using the Amazon Chime SDK.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Meeting implements SdkPojo, Serializable, ToCopyableBuilder<Meeting.Builder, Meeting> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Meeting::meetingId)).setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingId").build()).build();

    private static final SdkField<String> EXTERNAL_MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Meeting::externalMeetingId)).setter(setter(Builder::externalMeetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalMeetingId").build()).build();

    private static final SdkField<MediaPlacement> MEDIA_PLACEMENT_FIELD = SdkField
            .<MediaPlacement> builder(MarshallingType.SDK_POJO).getter(getter(Meeting::mediaPlacement))
            .setter(setter(Builder::mediaPlacement)).constructor(MediaPlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPlacement").build()).build();

    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Meeting::mediaRegion)).setter(setter(Builder::mediaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD,
            EXTERNAL_MEETING_ID_FIELD, MEDIA_PLACEMENT_FIELD, MEDIA_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String meetingId;

    private final String externalMeetingId;

    private final MediaPlacement mediaPlacement;

    private final String mediaRegion;

    private Meeting(BuilderImpl builder) {
        this.meetingId = builder.meetingId;
        this.externalMeetingId = builder.externalMeetingId;
        this.mediaPlacement = builder.mediaPlacement;
        this.mediaRegion = builder.mediaRegion;
    }

    /**
     * <p>
     * The Amazon Chime SDK meeting ID.
     * </p>
     * 
     * @return The Amazon Chime SDK meeting ID.
     */
    public String meetingId() {
        return meetingId;
    }

    /**
     * <p>
     * The external meeting ID.
     * </p>
     * 
     * @return The external meeting ID.
     */
    public String externalMeetingId() {
        return externalMeetingId;
    }

    /**
     * <p>
     * The media placement for the meeting.
     * </p>
     * 
     * @return The media placement for the meeting.
     */
    public MediaPlacement mediaPlacement() {
        return mediaPlacement;
    }

    /**
     * <p>
     * The Region in which to create the meeting. Available values: <code>ap-northeast-1</code>,
     * <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>,
     * <code>eu-north-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>,
     * <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>,
     * <code>us-west-2</code>.
     * </p>
     * 
     * @return The Region in which to create the meeting. Available values: <code>ap-northeast-1</code>,
     *         <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
     *         <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>,
     *         <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>,
     *         <code>us-west-1</code>, <code>us-west-2</code>.
     */
    public String mediaRegion() {
        return mediaRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(externalMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaPlacement());
        hashCode = 31 * hashCode + Objects.hashCode(mediaRegion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Meeting)) {
            return false;
        }
        Meeting other = (Meeting) obj;
        return Objects.equals(meetingId(), other.meetingId()) && Objects.equals(externalMeetingId(), other.externalMeetingId())
                && Objects.equals(mediaPlacement(), other.mediaPlacement()) && Objects.equals(mediaRegion(), other.mediaRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Meeting").add("MeetingId", meetingId())
                .add("ExternalMeetingId", externalMeetingId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MediaPlacement", mediaPlacement()).add("MediaRegion", mediaRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        case "ExternalMeetingId":
            return Optional.ofNullable(clazz.cast(externalMeetingId()));
        case "MediaPlacement":
            return Optional.ofNullable(clazz.cast(mediaPlacement()));
        case "MediaRegion":
            return Optional.ofNullable(clazz.cast(mediaRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Meeting, T> g) {
        return obj -> g.apply((Meeting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Meeting> {
        /**
         * <p>
         * The Amazon Chime SDK meeting ID.
         * </p>
         * 
         * @param meetingId
         *        The Amazon Chime SDK meeting ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);

        /**
         * <p>
         * The external meeting ID.
         * </p>
         * 
         * @param externalMeetingId
         *        The external meeting ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalMeetingId(String externalMeetingId);

        /**
         * <p>
         * The media placement for the meeting.
         * </p>
         * 
         * @param mediaPlacement
         *        The media placement for the meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPlacement(MediaPlacement mediaPlacement);

        /**
         * <p>
         * The media placement for the meeting.
         * </p>
         * This is a convenience that creates an instance of the {@link MediaPlacement.Builder} avoiding the need to
         * create one manually via {@link MediaPlacement#builder()}.
         *
         * When the {@link Consumer} completes, {@link MediaPlacement.Builder#build()} is called immediately and its
         * result is passed to {@link #mediaPlacement(MediaPlacement)}.
         * 
         * @param mediaPlacement
         *        a consumer that will call methods on {@link MediaPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaPlacement(MediaPlacement)
         */
        default Builder mediaPlacement(Consumer<MediaPlacement.Builder> mediaPlacement) {
            return mediaPlacement(MediaPlacement.builder().applyMutation(mediaPlacement).build());
        }

        /**
         * <p>
         * The Region in which to create the meeting. Available values: <code>ap-northeast-1</code>,
         * <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
         * <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>,
         * <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>,
         * <code>us-west-1</code>, <code>us-west-2</code>.
         * </p>
         * 
         * @param mediaRegion
         *        The Region in which to create the meeting. Available values: <code>ap-northeast-1</code>,
         *        <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
         *        <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>,
         *        <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>,
         *        <code>us-west-1</code>, <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaRegion(String mediaRegion);
    }

    static final class BuilderImpl implements Builder {
        private String meetingId;

        private String externalMeetingId;

        private MediaPlacement mediaPlacement;

        private String mediaRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Meeting model) {
            meetingId(model.meetingId);
            externalMeetingId(model.externalMeetingId);
            mediaPlacement(model.mediaPlacement);
            mediaRegion(model.mediaRegion);
        }

        public final String getMeetingId() {
            return meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        public final String getExternalMeetingId() {
            return externalMeetingId;
        }

        @Override
        public final Builder externalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
            return this;
        }

        public final void setExternalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
        }

        public final MediaPlacement.Builder getMediaPlacement() {
            return mediaPlacement != null ? mediaPlacement.toBuilder() : null;
        }

        @Override
        public final Builder mediaPlacement(MediaPlacement mediaPlacement) {
            this.mediaPlacement = mediaPlacement;
            return this;
        }

        public final void setMediaPlacement(MediaPlacement.BuilderImpl mediaPlacement) {
            this.mediaPlacement = mediaPlacement != null ? mediaPlacement.build() : null;
        }

        public final String getMediaRegion() {
            return mediaRegion;
        }

        @Override
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        @Override
        public Meeting build() {
            return new Meeting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
