/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logging configuration associated with an Amazon Chime Voice Connector. Specifies whether SIP message logs are
 * enabled for sending to Amazon CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LoggingConfiguration.Builder, LoggingConfiguration> {
    private static final SdkField<Boolean> ENABLE_SIP_LOGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(LoggingConfiguration::enableSIPLogs)).setter(setter(Builder::enableSIPLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSIPLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_SIP_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableSIPLogs;

    private LoggingConfiguration(BuilderImpl builder) {
        this.enableSIPLogs = builder.enableSIPLogs;
    }

    /**
     * <p>
     * When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
     */
    public Boolean enableSIPLogs() {
        return enableSIPLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableSIPLogs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration) obj;
        return Objects.equals(enableSIPLogs(), other.enableSIPLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoggingConfiguration").add("EnableSIPLogs", enableSIPLogs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableSIPLogs":
            return Optional.ofNullable(clazz.cast(enableSIPLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfiguration, T> g) {
        return obj -> g.apply((LoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfiguration> {
        /**
         * <p>
         * When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param enableSIPLogs
         *        When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSIPLogs(Boolean enableSIPLogs);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableSIPLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfiguration model) {
            enableSIPLogs(model.enableSIPLogs);
        }

        public final Boolean getEnableSIPLogs() {
            return enableSIPLogs;
        }

        @Override
        public final Builder enableSIPLogs(Boolean enableSIPLogs) {
            this.enableSIPLogs = enableSIPLogs;
            return this;
        }

        public final void setEnableSIPLogs(Boolean enableSIPLogs) {
            this.enableSIPLogs = enableSIPLogs;
        }

        @Override
        public LoggingConfiguration build() {
            return new LoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
