/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPhoneNumbersResponse extends ChimeResponse implements
        ToCopyableBuilder<ListPhoneNumbersResponse.Builder, ListPhoneNumbersResponse> {
    private static final SdkField<List<PhoneNumber>> PHONE_NUMBERS_FIELD = SdkField
            .<List<PhoneNumber>> builder(MarshallingType.LIST)
            .getter(getter(ListPhoneNumbersResponse::phoneNumbers))
            .setter(setter(Builder::phoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumber> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPhoneNumbersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PhoneNumber> phoneNumbers;

    private final String nextToken;

    private ListPhoneNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumbers = builder.phoneNumbers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PhoneNumbers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPhoneNumbers() {
        return phoneNumbers != null && !(phoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The phone number details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhoneNumbers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The phone number details.
     */
    public List<PhoneNumber> phoneNumbers() {
        return phoneNumbers;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersResponse)) {
            return false;
        }
        ListPhoneNumbersResponse other = (ListPhoneNumbersResponse) obj;
        return Objects.equals(phoneNumbers(), other.phoneNumbers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPhoneNumbersResponse").add("PhoneNumbers", phoneNumbers()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumbers":
            return Optional.ofNullable(clazz.cast(phoneNumbers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersResponse, T> g) {
        return obj -> g.apply((ListPhoneNumbersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPhoneNumbersResponse> {
        /**
         * <p>
         * The phone number details.
         * </p>
         * 
         * @param phoneNumbers
         *        The phone number details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers);

        /**
         * <p>
         * The phone number details.
         * </p>
         * 
         * @param phoneNumbers
         *        The phone number details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(PhoneNumber... phoneNumbers);

        /**
         * <p>
         * The phone number details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PhoneNumber>.Builder} avoiding the need to
         * create one manually via {@link List<PhoneNumber>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhoneNumber>.Builder#build()} is called immediately and its
         * result is passed to {@link #phoneNumbers(List<PhoneNumber>)}.
         * 
         * @param phoneNumbers
         *        a consumer that will call methods on {@link List<PhoneNumber>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumbers(List<PhoneNumber>)
         */
        Builder phoneNumbers(Consumer<PhoneNumber.Builder>... phoneNumbers);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<PhoneNumber> phoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersResponse model) {
            super(model);
            phoneNumbers(model.phoneNumbers);
            nextToken(model.nextToken);
        }

        public final Collection<PhoneNumber.Builder> getPhoneNumbers() {
            return phoneNumbers != null ? phoneNumbers.stream().map(PhoneNumber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumber... phoneNumbers) {
            phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumber.Builder>... phoneNumbers) {
            phoneNumbers(Stream.of(phoneNumbers).map(c -> PhoneNumber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumbers(Collection<PhoneNumber.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copyFromBuilder(phoneNumbers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPhoneNumbersResponse build() {
            return new ListPhoneNumbersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
