/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserRequest;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserResponse;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest;
import software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountResponse;
import software.amazon.awssdk.services.chime.model.BatchCreateAttendeeRequest;
import software.amazon.awssdk.services.chime.model.BatchCreateAttendeeResponse;
import software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.BatchSuspendUserRequest;
import software.amazon.awssdk.services.chime.model.BatchSuspendUserResponse;
import software.amazon.awssdk.services.chime.model.BatchUnsuspendUserRequest;
import software.amazon.awssdk.services.chime.model.BatchUnsuspendUserResponse;
import software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.BatchUpdateUserRequest;
import software.amazon.awssdk.services.chime.model.BatchUpdateUserResponse;
import software.amazon.awssdk.services.chime.model.CreateAccountRequest;
import software.amazon.awssdk.services.chime.model.CreateAccountResponse;
import software.amazon.awssdk.services.chime.model.CreateAttendeeRequest;
import software.amazon.awssdk.services.chime.model.CreateAttendeeResponse;
import software.amazon.awssdk.services.chime.model.CreateBotRequest;
import software.amazon.awssdk.services.chime.model.CreateBotResponse;
import software.amazon.awssdk.services.chime.model.CreateMeetingRequest;
import software.amazon.awssdk.services.chime.model.CreateMeetingResponse;
import software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderRequest;
import software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderResponse;
import software.amazon.awssdk.services.chime.model.CreateProxySessionRequest;
import software.amazon.awssdk.services.chime.model.CreateProxySessionResponse;
import software.amazon.awssdk.services.chime.model.CreateRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.CreateRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.CreateRoomRequest;
import software.amazon.awssdk.services.chime.model.CreateRoomResponse;
import software.amazon.awssdk.services.chime.model.CreateUserRequest;
import software.amazon.awssdk.services.chime.model.CreateUserResponse;
import software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.CreateVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.CreateVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.model.DeleteAccountRequest;
import software.amazon.awssdk.services.chime.model.DeleteAccountResponse;
import software.amazon.awssdk.services.chime.model.DeleteAttendeeRequest;
import software.amazon.awssdk.services.chime.model.DeleteAttendeeResponse;
import software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationRequest;
import software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationResponse;
import software.amazon.awssdk.services.chime.model.DeleteMeetingRequest;
import software.amazon.awssdk.services.chime.model.DeleteMeetingResponse;
import software.amazon.awssdk.services.chime.model.DeletePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.DeletePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.DeleteProxySessionRequest;
import software.amazon.awssdk.services.chime.model.DeleteProxySessionResponse;
import software.amazon.awssdk.services.chime.model.DeleteRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.DeleteRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.DeleteRoomRequest;
import software.amazon.awssdk.services.chime.model.DeleteRoomResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserRequest;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserResponse;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest;
import software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse;
import software.amazon.awssdk.services.chime.model.GetAccountRequest;
import software.amazon.awssdk.services.chime.model.GetAccountResponse;
import software.amazon.awssdk.services.chime.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetAttendeeRequest;
import software.amazon.awssdk.services.chime.model.GetAttendeeResponse;
import software.amazon.awssdk.services.chime.model.GetBotRequest;
import software.amazon.awssdk.services.chime.model.GetBotResponse;
import software.amazon.awssdk.services.chime.model.GetEventsConfigurationRequest;
import software.amazon.awssdk.services.chime.model.GetEventsConfigurationResponse;
import software.amazon.awssdk.services.chime.model.GetGlobalSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetGlobalSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetMeetingRequest;
import software.amazon.awssdk.services.chime.model.GetMeetingResponse;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderRequest;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderResponse;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetPhoneNumberSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetProxySessionRequest;
import software.amazon.awssdk.services.chime.model.GetProxySessionResponse;
import software.amazon.awssdk.services.chime.model.GetRetentionSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetRetentionSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetRoomRequest;
import software.amazon.awssdk.services.chime.model.GetRoomResponse;
import software.amazon.awssdk.services.chime.model.GetUserRequest;
import software.amazon.awssdk.services.chime.model.GetUserResponse;
import software.amazon.awssdk.services.chime.model.GetUserSettingsRequest;
import software.amazon.awssdk.services.chime.model.GetUserSettingsResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthResponse;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chime.model.InviteUsersRequest;
import software.amazon.awssdk.services.chime.model.InviteUsersResponse;
import software.amazon.awssdk.services.chime.model.ListAccountsRequest;
import software.amazon.awssdk.services.chime.model.ListAccountsResponse;
import software.amazon.awssdk.services.chime.model.ListAttendeeTagsRequest;
import software.amazon.awssdk.services.chime.model.ListAttendeeTagsResponse;
import software.amazon.awssdk.services.chime.model.ListAttendeesRequest;
import software.amazon.awssdk.services.chime.model.ListAttendeesResponse;
import software.amazon.awssdk.services.chime.model.ListBotsRequest;
import software.amazon.awssdk.services.chime.model.ListBotsResponse;
import software.amazon.awssdk.services.chime.model.ListMeetingTagsRequest;
import software.amazon.awssdk.services.chime.model.ListMeetingTagsResponse;
import software.amazon.awssdk.services.chime.model.ListMeetingsRequest;
import software.amazon.awssdk.services.chime.model.ListMeetingsResponse;
import software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest;
import software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse;
import software.amazon.awssdk.services.chime.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.chime.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.chime.model.ListProxySessionsRequest;
import software.amazon.awssdk.services.chime.model.ListProxySessionsResponse;
import software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest;
import software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse;
import software.amazon.awssdk.services.chime.model.ListRoomsRequest;
import software.amazon.awssdk.services.chime.model.ListRoomsResponse;
import software.amazon.awssdk.services.chime.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chime.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chime.model.ListUsersRequest;
import software.amazon.awssdk.services.chime.model.ListUsersResponse;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsRequest;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorsResponse;
import software.amazon.awssdk.services.chime.model.LogoutUserRequest;
import software.amazon.awssdk.services.chime.model.LogoutUserResponse;
import software.amazon.awssdk.services.chime.model.PutEventsConfigurationRequest;
import software.amazon.awssdk.services.chime.model.PutEventsConfigurationResponse;
import software.amazon.awssdk.services.chime.model.PutRetentionSettingsRequest;
import software.amazon.awssdk.services.chime.model.PutRetentionSettingsResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chime.model.RedactConversationMessageRequest;
import software.amazon.awssdk.services.chime.model.RedactConversationMessageResponse;
import software.amazon.awssdk.services.chime.model.RedactRoomMessageRequest;
import software.amazon.awssdk.services.chime.model.RedactRoomMessageResponse;
import software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenRequest;
import software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenResponse;
import software.amazon.awssdk.services.chime.model.ResetPersonalPinRequest;
import software.amazon.awssdk.services.chime.model.ResetPersonalPinResponse;
import software.amazon.awssdk.services.chime.model.RestorePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.RestorePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersResponse;
import software.amazon.awssdk.services.chime.model.TagAttendeeRequest;
import software.amazon.awssdk.services.chime.model.TagAttendeeResponse;
import software.amazon.awssdk.services.chime.model.TagMeetingRequest;
import software.amazon.awssdk.services.chime.model.TagMeetingResponse;
import software.amazon.awssdk.services.chime.model.TagResourceRequest;
import software.amazon.awssdk.services.chime.model.TagResourceResponse;
import software.amazon.awssdk.services.chime.model.UntagAttendeeRequest;
import software.amazon.awssdk.services.chime.model.UntagAttendeeResponse;
import software.amazon.awssdk.services.chime.model.UntagMeetingRequest;
import software.amazon.awssdk.services.chime.model.UntagMeetingResponse;
import software.amazon.awssdk.services.chime.model.UntagResourceRequest;
import software.amazon.awssdk.services.chime.model.UntagResourceResponse;
import software.amazon.awssdk.services.chime.model.UpdateAccountRequest;
import software.amazon.awssdk.services.chime.model.UpdateAccountResponse;
import software.amazon.awssdk.services.chime.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdateBotRequest;
import software.amazon.awssdk.services.chime.model.UpdateBotResponse;
import software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdateProxySessionRequest;
import software.amazon.awssdk.services.chime.model.UpdateProxySessionResponse;
import software.amazon.awssdk.services.chime.model.UpdateRoomMembershipRequest;
import software.amazon.awssdk.services.chime.model.UpdateRoomMembershipResponse;
import software.amazon.awssdk.services.chime.model.UpdateRoomRequest;
import software.amazon.awssdk.services.chime.model.UpdateRoomResponse;
import software.amazon.awssdk.services.chime.model.UpdateUserRequest;
import software.amazon.awssdk.services.chime.model.UpdateUserResponse;
import software.amazon.awssdk.services.chime.model.UpdateUserSettingsRequest;
import software.amazon.awssdk.services.chime.model.UpdateUserSettingsResponse;
import software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorRequest;
import software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorResponse;
import software.amazon.awssdk.services.chime.paginators.ListAccountsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListAttendeesPublisher;
import software.amazon.awssdk.services.chime.paginators.ListBotsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListMeetingsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListPhoneNumberOrdersPublisher;
import software.amazon.awssdk.services.chime.paginators.ListPhoneNumbersPublisher;
import software.amazon.awssdk.services.chime.paginators.ListProxySessionsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListRoomMembershipsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListRoomsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListUsersPublisher;
import software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorGroupsPublisher;
import software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorsPublisher;

/**
 * Service client for accessing Amazon Chime asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The Amazon Chime API (application programming interface) is designed for developers to perform key tasks, such as
 * creating and managing Amazon Chime accounts, users, and Voice Connectors. This guide provides detailed information
 * about the Amazon Chime API, including operations, types, inputs and outputs, and error codes. It also includes some
 * server-side API actions to use with the Amazon Chime SDK. For more information about the Amazon Chime SDK, see <a
 * href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon
 * Chime Developer Guide</i>.
 * </p>
 * <p>
 * You can use an AWS SDK, the AWS Command Line Interface (AWS CLI), or the REST API to make API calls. We recommend
 * using an AWS SDK or the AWS CLI. Each API operation includes links to information about using it with a
 * language-specific AWS SDK or the AWS CLI.
 * </p>
 * <dl>
 * <dt>Using an AWS SDK</dt>
 * <dd>
 * <p>
 * You don't need to write code to calculate a signature for request authentication. The SDK clients authenticate your
 * requests by using access keys that you provide. For more information about AWS SDKs, see the <a
 * href="http://aws.amazon.com/developer/">AWS Developer Center</a>.
 * </p>
 * </dd>
 * <dt>Using the AWS CLI</dt>
 * <dd>
 * <p>
 * Use your access keys with the AWS CLI to make API calls. For information about setting up the AWS CLI, see <a
 * href="https://docs.aws.amazon.com/cli/latest/userguide/installing.html">Installing the AWS Command Line Interface</a>
 * in the <i>AWS Command Line Interface User Guide</i>. For a list of available Amazon Chime commands, see the <a
 * href="https://docs.aws.amazon.com/cli/latest/reference/chime/index.html">Amazon Chime commands</a> in the <i>AWS CLI
 * Command Reference</i>.
 * </p>
 * </dd>
 * <dt>Using REST API</dt>
 * <dd>
 * <p>
 * If you use REST to make API calls, you must authenticate your request by providing a signature. Amazon Chime supports
 * signature version 4. For more information, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>
 * in the <i>Amazon Web Services General Reference</i>.
 * </p>
 * <p>
 * When making REST API calls, use the service name <code>chime</code> and REST endpoint
 * <code>https://service.chime.aws.amazon.com</code>.
 * </p>
 * </dd>
 * </dl>
 * <p>
 * Administrative permissions are controlled using AWS Identity and Access Management (IAM). For more information, see
 * <a href="https://docs.aws.amazon.com/chime/latest/ag/security-iam.html">Identity and Access Management for Amazon
 * Chime</a> in the <i>Amazon Chime Administration Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ChimeAsyncClient extends SdkClient {
    String SERVICE_NAME = "chime";

    /**
     * Create a {@link ChimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ChimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ChimeAsyncClient}.
     */
    static ChimeAsyncClientBuilder builder() {
        return new DefaultChimeAsyncClientBuilder();
    }

    /**
     * <p>
     * Associates a phone number with the specified Amazon Chime user.
     * </p>
     *
     * @param associatePhoneNumberWithUserRequest
     * @return A Java Future containing the result of the AssociatePhoneNumberWithUser operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.AssociatePhoneNumberWithUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumberWithUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumberWithUserResponse> associatePhoneNumberWithUser(
            AssociatePhoneNumberWithUserRequest associatePhoneNumberWithUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a phone number with the specified Amazon Chime user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePhoneNumberWithUserRequest.Builder}
     * avoiding the need to create one manually via {@link AssociatePhoneNumberWithUserRequest#builder()}
     * </p>
     *
     * @param associatePhoneNumberWithUserRequest
     *        A {@link Consumer} that will call methods on {@link AssociatePhoneNumberWithUserRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociatePhoneNumberWithUser operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.AssociatePhoneNumberWithUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumberWithUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumberWithUserResponse> associatePhoneNumberWithUser(
            Consumer<AssociatePhoneNumberWithUserRequest.Builder> associatePhoneNumberWithUserRequest) {
        return associatePhoneNumberWithUser(AssociatePhoneNumberWithUserRequest.builder()
                .applyMutation(associatePhoneNumberWithUserRequest).build());
    }

    /**
     * <p>
     * Associates phone numbers with the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param associatePhoneNumbersWithVoiceConnectorRequest
     * @return A Java Future containing the result of the AssociatePhoneNumbersWithVoiceConnector operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.AssociatePhoneNumbersWithVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorResponse> associatePhoneNumbersWithVoiceConnector(
            AssociatePhoneNumbersWithVoiceConnectorRequest associatePhoneNumbersWithVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates phone numbers with the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociatePhoneNumbersWithVoiceConnectorRequest.Builder} avoiding the need to create one manually via
     * {@link AssociatePhoneNumbersWithVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param associatePhoneNumbersWithVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociatePhoneNumbersWithVoiceConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociatePhoneNumbersWithVoiceConnector operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.AssociatePhoneNumbersWithVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorResponse> associatePhoneNumbersWithVoiceConnector(
            Consumer<AssociatePhoneNumbersWithVoiceConnectorRequest.Builder> associatePhoneNumbersWithVoiceConnectorRequest) {
        return associatePhoneNumbersWithVoiceConnector(AssociatePhoneNumbersWithVoiceConnectorRequest.builder()
                .applyMutation(associatePhoneNumbersWithVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Associates phone numbers with the specified Amazon Chime Voice Connector group.
     * </p>
     *
     * @param associatePhoneNumbersWithVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the AssociatePhoneNumbersWithVoiceConnectorGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.AssociatePhoneNumbersWithVoiceConnectorGroup
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorGroupResponse> associatePhoneNumbersWithVoiceConnectorGroup(
            AssociatePhoneNumbersWithVoiceConnectorGroupRequest associatePhoneNumbersWithVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates phone numbers with the specified Amazon Chime Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociatePhoneNumbersWithVoiceConnectorGroupRequest.Builder} avoiding the need to create one manually via
     * {@link AssociatePhoneNumbersWithVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param associatePhoneNumbersWithVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociatePhoneNumbersWithVoiceConnectorGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociatePhoneNumbersWithVoiceConnectorGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.AssociatePhoneNumbersWithVoiceConnectorGroup
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorGroupResponse> associatePhoneNumbersWithVoiceConnectorGroup(
            Consumer<AssociatePhoneNumbersWithVoiceConnectorGroupRequest.Builder> associatePhoneNumbersWithVoiceConnectorGroupRequest) {
        return associatePhoneNumbersWithVoiceConnectorGroup(AssociatePhoneNumbersWithVoiceConnectorGroupRequest.builder()
                .applyMutation(associatePhoneNumbersWithVoiceConnectorGroupRequest).build());
    }

    /**
     * <p>
     * Associates the specified sign-in delegate groups with the specified Amazon Chime account.
     * </p>
     *
     * @param associateSigninDelegateGroupsWithAccountRequest
     * @return A Java Future containing the result of the AssociateSigninDelegateGroupsWithAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.AssociateSigninDelegateGroupsWithAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociateSigninDelegateGroupsWithAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSigninDelegateGroupsWithAccountResponse> associateSigninDelegateGroupsWithAccount(
            AssociateSigninDelegateGroupsWithAccountRequest associateSigninDelegateGroupsWithAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified sign-in delegate groups with the specified Amazon Chime account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateSigninDelegateGroupsWithAccountRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateSigninDelegateGroupsWithAccountRequest#builder()}
     * </p>
     *
     * @param associateSigninDelegateGroupsWithAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateSigninDelegateGroupsWithAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateSigninDelegateGroupsWithAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.AssociateSigninDelegateGroupsWithAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociateSigninDelegateGroupsWithAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSigninDelegateGroupsWithAccountResponse> associateSigninDelegateGroupsWithAccount(
            Consumer<AssociateSigninDelegateGroupsWithAccountRequest.Builder> associateSigninDelegateGroupsWithAccountRequest) {
        return associateSigninDelegateGroupsWithAccount(AssociateSigninDelegateGroupsWithAccountRequest.builder()
                .applyMutation(associateSigninDelegateGroupsWithAccountRequest).build());
    }

    /**
     * <p>
     * Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon
     * Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime
     * SDK</a> in the <i>Amazon Chime Developer Guide</i>.
     * </p>
     *
     * @param batchCreateAttendeeRequest
     * @return A Java Future containing the result of the BatchCreateAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchCreateAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchCreateAttendeeResponse> batchCreateAttendee(
            BatchCreateAttendeeRequest batchCreateAttendeeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon
     * Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime
     * SDK</a> in the <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateAttendeeRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreateAttendeeRequest#builder()}
     * </p>
     *
     * @param batchCreateAttendeeRequest
     *        A {@link Consumer} that will call methods on {@link BatchCreateAttendeeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchCreateAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchCreateAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchCreateAttendeeResponse> batchCreateAttendee(
            Consumer<BatchCreateAttendeeRequest.Builder> batchCreateAttendeeRequest) {
        return batchCreateAttendee(BatchCreateAttendeeRequest.builder().applyMutation(batchCreateAttendeeRequest).build());
    }

    /**
     * <p>
     * Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be either users or bots.
     * The member role designates whether the member is a chat room administrator or a general chat room member.
     * </p>
     *
     * @param batchCreateRoomMembershipRequest
     * @return A Java Future containing the result of the BatchCreateRoomMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchCreateRoomMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateRoomMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateRoomMembershipResponse> batchCreateRoomMembership(
            BatchCreateRoomMembershipRequest batchCreateRoomMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be either users or bots.
     * The member role designates whether the member is a chat room administrator or a general chat room member.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateRoomMembershipRequest.Builder} avoiding
     * the need to create one manually via {@link BatchCreateRoomMembershipRequest#builder()}
     * </p>
     *
     * @param batchCreateRoomMembershipRequest
     *        A {@link Consumer} that will call methods on {@link BatchCreateRoomMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchCreateRoomMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchCreateRoomMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateRoomMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateRoomMembershipResponse> batchCreateRoomMembership(
            Consumer<BatchCreateRoomMembershipRequest.Builder> batchCreateRoomMembershipRequest) {
        return batchCreateRoomMembership(BatchCreateRoomMembershipRequest.builder()
                .applyMutation(batchCreateRoomMembershipRequest).build());
    }

    /**
     * <p>
     * Moves phone numbers into the <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon
     * Chime Voice Connectors before they can be deleted.
     * </p>
     * <p>
     * Phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently.
     * </p>
     *
     * @param batchDeletePhoneNumberRequest
     * @return A Java Future containing the result of the BatchDeletePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchDeletePhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchDeletePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeletePhoneNumberResponse> batchDeletePhoneNumber(
            BatchDeletePhoneNumberRequest batchDeletePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves phone numbers into the <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon
     * Chime Voice Connectors before they can be deleted.
     * </p>
     * <p>
     * Phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeletePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeletePhoneNumberRequest#builder()}
     * </p>
     *
     * @param batchDeletePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeletePhoneNumberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeletePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchDeletePhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchDeletePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeletePhoneNumberResponse> batchDeletePhoneNumber(
            Consumer<BatchDeletePhoneNumberRequest.Builder> batchDeletePhoneNumberRequest) {
        return batchDeletePhoneNumber(BatchDeletePhoneNumberRequest.builder().applyMutation(batchDeletePhoneNumberRequest)
                .build());
    }

    /**
     * <p>
     * Suspends up to 50 users from a <code>Team</code> or <code>EnterpriseLWA</code> Amazon Chime account. For more
     * information about different account types, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime
     * Accounts</a> in the <i>Amazon Chime Administration Guide</i>.
     * </p>
     * <p>
     * Users suspended from a <code>Team</code> account are disassociated from the account, but they can continue to use
     * Amazon Chime as free users. To remove the suspension from suspended <code>Team</code> account users, invite them
     * to the <code>Team</code> account again. You can use the <a>InviteUsers</a> action to do so.
     * </p>
     * <p>
     * Users suspended from an <code>EnterpriseLWA</code> account are immediately signed out of Amazon Chime and can no
     * longer sign in. To remove the suspension from suspended <code>EnterpriseLWA</code> account users, use the
     * <a>BatchUnsuspendUser</a> action.
     * </p>
     * <p>
     * To sign out users without suspending them, use the <a>LogoutUser</a> action.
     * </p>
     *
     * @param batchSuspendUserRequest
     * @return A Java Future containing the result of the BatchSuspendUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchSuspendUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchSuspendUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchSuspendUserResponse> batchSuspendUser(BatchSuspendUserRequest batchSuspendUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Suspends up to 50 users from a <code>Team</code> or <code>EnterpriseLWA</code> Amazon Chime account. For more
     * information about different account types, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime
     * Accounts</a> in the <i>Amazon Chime Administration Guide</i>.
     * </p>
     * <p>
     * Users suspended from a <code>Team</code> account are disassociated from the account, but they can continue to use
     * Amazon Chime as free users. To remove the suspension from suspended <code>Team</code> account users, invite them
     * to the <code>Team</code> account again. You can use the <a>InviteUsers</a> action to do so.
     * </p>
     * <p>
     * Users suspended from an <code>EnterpriseLWA</code> account are immediately signed out of Amazon Chime and can no
     * longer sign in. To remove the suspension from suspended <code>EnterpriseLWA</code> account users, use the
     * <a>BatchUnsuspendUser</a> action.
     * </p>
     * <p>
     * To sign out users without suspending them, use the <a>LogoutUser</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchSuspendUserRequest.Builder} avoiding the need
     * to create one manually via {@link BatchSuspendUserRequest#builder()}
     * </p>
     *
     * @param batchSuspendUserRequest
     *        A {@link Consumer} that will call methods on {@link BatchSuspendUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchSuspendUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchSuspendUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchSuspendUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchSuspendUserResponse> batchSuspendUser(
            Consumer<BatchSuspendUserRequest.Builder> batchSuspendUserRequest) {
        return batchSuspendUser(BatchSuspendUserRequest.builder().applyMutation(batchSuspendUserRequest).build());
    }

    /**
     * <p>
     * Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime
     * <code>EnterpriseLWA</code> account. Only users on <code>EnterpriseLWA</code> accounts can be unsuspended using
     * this action. For more information about different account types, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime
     * Accounts</a> in the <i>Amazon Chime Administration Guide</i>.
     * </p>
     * <p>
     * Previously suspended users who are unsuspended using this action are returned to <code>Registered</code> status.
     * Users who are not previously suspended are ignored.
     * </p>
     *
     * @param batchUnsuspendUserRequest
     * @return A Java Future containing the result of the BatchUnsuspendUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchUnsuspendUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUnsuspendUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchUnsuspendUserResponse> batchUnsuspendUser(BatchUnsuspendUserRequest batchUnsuspendUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime
     * <code>EnterpriseLWA</code> account. Only users on <code>EnterpriseLWA</code> accounts can be unsuspended using
     * this action. For more information about different account types, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime
     * Accounts</a> in the <i>Amazon Chime Administration Guide</i>.
     * </p>
     * <p>
     * Previously suspended users who are unsuspended using this action are returned to <code>Registered</code> status.
     * Users who are not previously suspended are ignored.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUnsuspendUserRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUnsuspendUserRequest#builder()}
     * </p>
     *
     * @param batchUnsuspendUserRequest
     *        A {@link Consumer} that will call methods on {@link BatchUnsuspendUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUnsuspendUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchUnsuspendUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUnsuspendUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchUnsuspendUserResponse> batchUnsuspendUser(
            Consumer<BatchUnsuspendUserRequest.Builder> batchUnsuspendUserRequest) {
        return batchUnsuspendUser(BatchUnsuspendUserRequest.builder().applyMutation(batchUnsuspendUserRequest).build());
    }

    /**
     * <p>
     * Updates phone number product types or calling names. You can update one attribute at a time for each
     * <code>UpdatePhoneNumberRequestItem</code>. For example, you can update either the product type or the calling
     * name.
     * </p>
     * <p>
     * For product types, choose from Amazon Chime Business Calling and Amazon Chime Voice Connector. For toll-free
     * numbers, you must use the Amazon Chime Voice Connector product type.
     * </p>
     * <p>
     * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names
     * must be complete before you can request another update.
     * </p>
     *
     * @param batchUpdatePhoneNumberRequest
     * @return A Java Future containing the result of the BatchUpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchUpdatePhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdatePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdatePhoneNumberResponse> batchUpdatePhoneNumber(
            BatchUpdatePhoneNumberRequest batchUpdatePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates phone number product types or calling names. You can update one attribute at a time for each
     * <code>UpdatePhoneNumberRequestItem</code>. For example, you can update either the product type or the calling
     * name.
     * </p>
     * <p>
     * For product types, choose from Amazon Chime Business Calling and Amazon Chime Voice Connector. For toll-free
     * numbers, you must use the Amazon Chime Voice Connector product type.
     * </p>
     * <p>
     * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names
     * must be complete before you can request another update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdatePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdatePhoneNumberRequest#builder()}
     * </p>
     *
     * @param batchUpdatePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdatePhoneNumberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchUpdatePhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdatePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdatePhoneNumberResponse> batchUpdatePhoneNumber(
            Consumer<BatchUpdatePhoneNumberRequest.Builder> batchUpdatePhoneNumberRequest) {
        return batchUpdatePhoneNumber(BatchUpdatePhoneNumberRequest.builder().applyMutation(batchUpdatePhoneNumberRequest)
                .build());
    }

    /**
     * <p>
     * Updates user details within the <a>UpdateUserRequestItem</a> object for up to 20 users for the specified Amazon
     * Chime account. Currently, only <code>LicenseType</code> updates are supported for this action.
     * </p>
     *
     * @param batchUpdateUserRequest
     * @return A Java Future containing the result of the BatchUpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchUpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchUpdateUserResponse> batchUpdateUser(BatchUpdateUserRequest batchUpdateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates user details within the <a>UpdateUserRequestItem</a> object for up to 20 users for the specified Amazon
     * Chime account. Currently, only <code>LicenseType</code> updates are supported for this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateUserRequest.Builder} avoiding the need
     * to create one manually via {@link BatchUpdateUserRequest#builder()}
     * </p>
     *
     * @param batchUpdateUserRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchUpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.BatchUpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchUpdateUserResponse> batchUpdateUser(
            Consumer<BatchUpdateUserRequest.Builder> batchUpdateUserRequest) {
        return batchUpdateUser(BatchUpdateUserRequest.builder().applyMutation(batchUpdateUserRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Chime account under the administrator's AWS account. Only <code>Team</code> account types are
     * currently supported for this action. For more information about different account types, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime
     * Accounts</a> in the <i>Amazon Chime Administration Guide</i>.
     * </p>
     *
     * @param createAccountRequest
     * @return A Java Future containing the result of the CreateAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAccountResponse> createAccount(CreateAccountRequest createAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Chime account under the administrator's AWS account. Only <code>Team</code> account types are
     * currently supported for this action. For more information about different account types, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime
     * Accounts</a> in the <i>Amazon Chime Administration Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAccountRequest#builder()}
     * </p>
     *
     * @param createAccountRequest
     *        A {@link Consumer} that will call methods on {@link CreateAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAccountResponse> createAccount(Consumer<CreateAccountRequest.Builder> createAccountRequest) {
        return createAccount(CreateAccountRequest.builder().applyMutation(createAccountRequest).build());
    }

    /**
     * <p>
     * Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK,
     * see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     *
     * @param createAttendeeRequest
     * @return A Java Future containing the result of the CreateAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAttendeeResponse> createAttendee(CreateAttendeeRequest createAttendeeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK,
     * see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAttendeeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAttendeeRequest#builder()}
     * </p>
     *
     * @param createAttendeeRequest
     *        A {@link Consumer} that will call methods on {@link CreateAttendeeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAttendeeResponse> createAttendee(Consumer<CreateAttendeeRequest.Builder> createAttendeeRequest) {
        return createAttendee(CreateAttendeeRequest.builder().applyMutation(createAttendeeRequest).build());
    }

    /**
     * <p>
     * Creates a bot for an Amazon Chime Enterprise account.
     * </p>
     *
     * @param createBotRequest
     * @return A Java Future containing the result of the CreateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBotResponse> createBot(CreateBotRequest createBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a bot for an Amazon Chime Enterprise account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBotRequest#builder()}
     * </p>
     *
     * @param createBotRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBotResponse> createBot(Consumer<CreateBotRequest.Builder> createBotRequest) {
        return createBot(CreateBotRequest.builder().applyMutation(createBotRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more
     * information about the Amazon Chime SDK, see <a
     * href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     *
     * @param createMeetingRequest
     * @return A Java Future containing the result of the CreateMeeting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateMeeting
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeeting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMeetingResponse> createMeeting(CreateMeetingRequest createMeetingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more
     * information about the Amazon Chime SDK, see <a
     * href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMeetingRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMeetingRequest#builder()}
     * </p>
     *
     * @param createMeetingRequest
     *        A {@link Consumer} that will call methods on {@link CreateMeetingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMeeting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateMeeting
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeeting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMeetingResponse> createMeeting(Consumer<CreateMeetingRequest.Builder> createMeetingRequest) {
        return createMeeting(CreateMeetingRequest.builder().applyMutation(createMeetingRequest).build());
    }

    /**
     * <p>
     * Creates an order for phone numbers to be provisioned. Choose from Amazon Chime Business Calling and Amazon Chime
     * Voice Connector product types. For toll-free numbers, you must use the Amazon Chime Voice Connector product type.
     * </p>
     *
     * @param createPhoneNumberOrderRequest
     * @return A Java Future containing the result of the CreatePhoneNumberOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreatePhoneNumberOrder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreatePhoneNumberOrder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePhoneNumberOrderResponse> createPhoneNumberOrder(
            CreatePhoneNumberOrderRequest createPhoneNumberOrderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an order for phone numbers to be provisioned. Choose from Amazon Chime Business Calling and Amazon Chime
     * Voice Connector product types. For toll-free numbers, you must use the Amazon Chime Voice Connector product type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePhoneNumberOrderRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePhoneNumberOrderRequest#builder()}
     * </p>
     *
     * @param createPhoneNumberOrderRequest
     *        A {@link Consumer} that will call methods on {@link CreatePhoneNumberOrderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePhoneNumberOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreatePhoneNumberOrder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreatePhoneNumberOrder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePhoneNumberOrderResponse> createPhoneNumberOrder(
            Consumer<CreatePhoneNumberOrderRequest.Builder> createPhoneNumberOrderRequest) {
        return createPhoneNumberOrder(CreatePhoneNumberOrderRequest.builder().applyMutation(createPhoneNumberOrderRequest)
                .build());
    }

    /**
     * <p>
     * Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone
     * numbers.
     * </p>
     *
     * @param createProxySessionRequest
     * @return A Java Future containing the result of the CreateProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateProxySession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateProxySession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProxySessionResponse> createProxySession(CreateProxySessionRequest createProxySessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone
     * numbers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProxySessionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProxySessionRequest#builder()}
     * </p>
     *
     * @param createProxySessionRequest
     *        A {@link Consumer} that will call methods on {@link CreateProxySessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateProxySession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateProxySession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProxySessionResponse> createProxySession(
            Consumer<CreateProxySessionRequest.Builder> createProxySessionRequest) {
        return createProxySession(CreateProxySessionRequest.builder().applyMutation(createProxySessionRequest).build());
    }

    /**
     * <p>
     * Creates a chat room for the specified Amazon Chime Enterprise account.
     * </p>
     *
     * @param createRoomRequest
     * @return A Java Future containing the result of the CreateRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRoomResponse> createRoom(CreateRoomRequest createRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a chat room for the specified Amazon Chime Enterprise account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoomRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRoomRequest#builder()}
     * </p>
     *
     * @param createRoomRequest
     *        A {@link Consumer} that will call methods on {@link CreateRoomRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRoomResponse> createRoom(Consumer<CreateRoomRequest.Builder> createRoomRequest) {
        return createRoom(CreateRoomRequest.builder().applyMutation(createRoomRequest).build());
    }

    /**
     * <p>
     * Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The
     * member role designates whether the member is a chat room administrator or a general chat room member.
     * </p>
     *
     * @param createRoomMembershipRequest
     * @return A Java Future containing the result of the CreateRoomMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateRoomMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoomMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRoomMembershipResponse> createRoomMembership(
            CreateRoomMembershipRequest createRoomMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The
     * member role designates whether the member is a chat room administrator or a general chat room member.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoomMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRoomMembershipRequest#builder()}
     * </p>
     *
     * @param createRoomMembershipRequest
     *        A {@link Consumer} that will call methods on {@link CreateRoomMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRoomMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateRoomMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoomMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRoomMembershipResponse> createRoomMembership(
            Consumer<CreateRoomMembershipRequest.Builder> createRoomMembershipRequest) {
        return createRoomMembership(CreateRoomMembershipRequest.builder().applyMutation(createRoomMembershipRequest).build());
    }

    /**
     * <p>
     * Creates a user under the specified Amazon Chime account.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user under the specified Amazon Chime account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can choose to create an Amazon
     * Chime Voice Connector in a specific AWS Region.
     * </p>
     * <p>
     * Enabling <a>CreateVoiceConnectorRequest&#36RequireEncryption</a> configures your Amazon Chime Voice Connector to
     * use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and
     * unencrypted outbound calls are blocked.
     * </p>
     *
     * @param createVoiceConnectorRequest
     * @return A Java Future containing the result of the CreateVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVoiceConnectorResponse> createVoiceConnector(
            CreateVoiceConnectorRequest createVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can choose to create an Amazon
     * Chime Voice Connector in a specific AWS Region.
     * </p>
     * <p>
     * Enabling <a>CreateVoiceConnectorRequest&#36RequireEncryption</a> configures your Amazon Chime Voice Connector to
     * use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and
     * unencrypted outbound calls are blocked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVoiceConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param createVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on {@link CreateVoiceConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVoiceConnectorResponse> createVoiceConnector(
            Consumer<CreateVoiceConnectorRequest.Builder> createVoiceConnectorRequest) {
        return createVoiceConnector(CreateVoiceConnectorRequest.builder().applyMutation(createVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can associate Amazon
     * Chime Voice Connectors with the Amazon Chime Voice Connector group by including <code>VoiceConnectorItems</code>
     * in the request.
     * </p>
     * <p>
     * You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault
     * tolerant mechanism for fallback in case of availability events.
     * </p>
     *
     * @param createVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the CreateVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateVoiceConnectorGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVoiceConnectorGroupResponse> createVoiceConnectorGroup(
            CreateVoiceConnectorGroupRequest createVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can associate Amazon
     * Chime Voice Connectors with the Amazon Chime Voice Connector group by including <code>VoiceConnectorItems</code>
     * in the request.
     * </p>
     * <p>
     * You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault
     * tolerant mechanism for fallback in case of availability events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVoiceConnectorGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param createVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateVoiceConnectorGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.CreateVoiceConnectorGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVoiceConnectorGroupResponse> createVoiceConnectorGroup(
            Consumer<CreateVoiceConnectorGroupRequest.Builder> createVoiceConnectorGroupRequest) {
        return createVoiceConnectorGroup(CreateVoiceConnectorGroupRequest.builder()
                .applyMutation(createVoiceConnectorGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon Chime account. You must suspend all users before deleting a <code>Team</code>
     * account. You can use the <a>BatchSuspendUser</a> action to do so.
     * </p>
     * <p>
     * For <code>EnterpriseLWA</code> and <code>EnterpriseAD</code> accounts, you must release the claimed domains for
     * your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are
     * suspended.
     * </p>
     * <p>
     * Deleted accounts appear in your <code>Disabled</code> accounts list for 90 days. To restore a deleted account
     * from your <code>Disabled</code> accounts list, you must contact AWS Support.
     * </p>
     * <p>
     * After 90 days, deleted accounts are permanently removed from your <code>Disabled</code> accounts list.
     * </p>
     *
     * @param deleteAccountRequest
     * @return A Java Future containing the result of the DeleteAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnprocessableEntityException The request was well-formed but was unable to be followed due to
     *         semantic errors.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccountResponse> deleteAccount(DeleteAccountRequest deleteAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon Chime account. You must suspend all users before deleting a <code>Team</code>
     * account. You can use the <a>BatchSuspendUser</a> action to do so.
     * </p>
     * <p>
     * For <code>EnterpriseLWA</code> and <code>EnterpriseAD</code> accounts, you must release the claimed domains for
     * your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are
     * suspended.
     * </p>
     * <p>
     * Deleted accounts appear in your <code>Disabled</code> accounts list for 90 days. To restore a deleted account
     * from your <code>Disabled</code> accounts list, you must contact AWS Support.
     * </p>
     * <p>
     * After 90 days, deleted accounts are permanently removed from your <code>Disabled</code> accounts list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAccountRequest#builder()}
     * </p>
     *
     * @param deleteAccountRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnprocessableEntityException The request was well-formed but was unable to be followed due to
     *         semantic errors.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccountResponse> deleteAccount(Consumer<DeleteAccountRequest.Builder> deleteAccountRequest) {
        return deleteAccount(DeleteAccountRequest.builder().applyMutation(deleteAccountRequest).build());
    }

    /**
     * <p>
     * Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their <code>JoinToken</code>.
     * Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the
     * Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon
     * Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.
     * </p>
     *
     * @param deleteAttendeeRequest
     * @return A Java Future containing the result of the DeleteAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAttendeeResponse> deleteAttendee(DeleteAttendeeRequest deleteAttendeeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their <code>JoinToken</code>.
     * Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the
     * Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon
     * Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAttendeeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAttendeeRequest#builder()}
     * </p>
     *
     * @param deleteAttendeeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAttendeeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAttendeeResponse> deleteAttendee(Consumer<DeleteAttendeeRequest.Builder> deleteAttendeeRequest) {
        return deleteAttendee(DeleteAttendeeRequest.builder().applyMutation(deleteAttendeeRequest).build());
    }

    /**
     * <p>
     * Deletes the events configuration that allows a bot to receive outgoing events.
     * </p>
     *
     * @param deleteEventsConfigurationRequest
     * @return A Java Future containing the result of the DeleteEventsConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteEventsConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteEventsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventsConfigurationResponse> deleteEventsConfiguration(
            DeleteEventsConfigurationRequest deleteEventsConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the events configuration that allows a bot to receive outgoing events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventsConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventsConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEventsConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventsConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventsConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteEventsConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteEventsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventsConfigurationResponse> deleteEventsConfiguration(
            Consumer<DeleteEventsConfigurationRequest.Builder> deleteEventsConfigurationRequest) {
        return deleteEventsConfiguration(DeleteEventsConfigurationRequest.builder()
                .applyMutation(deleteEventsConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon Chime SDK meeting. When a meeting is deleted, its attendees are also deleted and
     * clients can no longer join it. For more information about the Amazon Chime SDK, see <a
     * href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     *
     * @param deleteMeetingRequest
     * @return A Java Future containing the result of the DeleteMeeting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteMeeting
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteMeeting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMeetingResponse> deleteMeeting(DeleteMeetingRequest deleteMeetingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon Chime SDK meeting. When a meeting is deleted, its attendees are also deleted and
     * clients can no longer join it. For more information about the Amazon Chime SDK, see <a
     * href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMeetingRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMeetingRequest#builder()}
     * </p>
     *
     * @param deleteMeetingRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMeetingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMeeting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteMeeting
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteMeeting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMeetingResponse> deleteMeeting(Consumer<DeleteMeetingRequest.Builder> deleteMeetingRequest) {
        return deleteMeeting(DeleteMeetingRequest.builder().applyMutation(deleteMeetingRequest).build());
    }

    /**
     * <p>
     * Moves the specified phone number into the <b>Deletion queue</b>. A phone number must be disassociated from any
     * users or Amazon Chime Voice Connectors before it can be deleted.
     * </p>
     * <p>
     * Deleted phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently.
     * </p>
     *
     * @param deletePhoneNumberRequest
     * @return A Java Future containing the result of the DeletePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeletePhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeletePhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePhoneNumberResponse> deletePhoneNumber(DeletePhoneNumberRequest deletePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves the specified phone number into the <b>Deletion queue</b>. A phone number must be disassociated from any
     * users or Amazon Chime Voice Connectors before it can be deleted.
     * </p>
     * <p>
     * Deleted phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePhoneNumberRequest#builder()}
     * </p>
     *
     * @param deletePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link DeletePhoneNumberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeletePhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeletePhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePhoneNumberResponse> deletePhoneNumber(
            Consumer<DeletePhoneNumberRequest.Builder> deletePhoneNumberRequest) {
        return deletePhoneNumber(DeletePhoneNumberRequest.builder().applyMutation(deletePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Deletes the specified proxy session from the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param deleteProxySessionRequest
     * @return A Java Future containing the result of the DeleteProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteProxySession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteProxySession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProxySessionResponse> deleteProxySession(DeleteProxySessionRequest deleteProxySessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified proxy session from the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProxySessionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProxySessionRequest#builder()}
     * </p>
     *
     * @param deleteProxySessionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProxySessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteProxySession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteProxySession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProxySessionResponse> deleteProxySession(
            Consumer<DeleteProxySessionRequest.Builder> deleteProxySessionRequest) {
        return deleteProxySession(DeleteProxySessionRequest.builder().applyMutation(deleteProxySessionRequest).build());
    }

    /**
     * <p>
     * Deletes a chat room in an Amazon Chime Enterprise account.
     * </p>
     *
     * @param deleteRoomRequest
     * @return A Java Future containing the result of the DeleteRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRoomResponse> deleteRoom(DeleteRoomRequest deleteRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a chat room in an Amazon Chime Enterprise account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoomRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRoomRequest#builder()}
     * </p>
     *
     * @param deleteRoomRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRoomRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRoomResponse> deleteRoom(Consumer<DeleteRoomRequest.Builder> deleteRoomRequest) {
        return deleteRoom(DeleteRoomRequest.builder().applyMutation(deleteRoomRequest).build());
    }

    /**
     * <p>
     * Removes a member from a chat room in an Amazon Chime Enterprise account.
     * </p>
     *
     * @param deleteRoomMembershipRequest
     * @return A Java Future containing the result of the DeleteRoomMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteRoomMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoomMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRoomMembershipResponse> deleteRoomMembership(
            DeleteRoomMembershipRequest deleteRoomMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a member from a chat room in an Amazon Chime Enterprise account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoomMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRoomMembershipRequest#builder()}
     * </p>
     *
     * @param deleteRoomMembershipRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRoomMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRoomMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteRoomMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoomMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRoomMembershipResponse> deleteRoomMembership(
            Consumer<DeleteRoomMembershipRequest.Builder> deleteRoomMembershipRequest) {
        return deleteRoomMembership(DeleteRoomMembershipRequest.builder().applyMutation(deleteRoomMembershipRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the Amazon Chime Voice
     * Connector must be disassociated from it before it can be deleted.
     * </p>
     *
     * @param deleteVoiceConnectorRequest
     * @return A Java Future containing the result of the DeleteVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorResponse> deleteVoiceConnector(
            DeleteVoiceConnectorRequest deleteVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the Amazon Chime Voice
     * Connector must be disassociated from it before it can be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorResponse> deleteVoiceConnector(
            Consumer<DeleteVoiceConnectorRequest.Builder> deleteVoiceConnectorRequest) {
        return deleteVoiceConnector(DeleteVoiceConnectorRequest.builder().applyMutation(deleteVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon Chime Voice Connector group. Any <code>VoiceConnectorItems</code> and phone numbers
     * associated with the group must be removed before it can be deleted.
     * </p>
     *
     * @param deleteVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorGroupResponse> deleteVoiceConnectorGroup(
            DeleteVoiceConnectorGroupRequest deleteVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon Chime Voice Connector group. Any <code>VoiceConnectorItems</code> and phone numbers
     * associated with the group must be removed before it can be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceConnectorGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceConnectorGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorGroupResponse> deleteVoiceConnectorGroup(
            Consumer<DeleteVoiceConnectorGroupRequest.Builder> deleteVoiceConnectorGroupRequest) {
        return deleteVoiceConnectorGroup(DeleteVoiceConnectorGroupRequest.builder()
                .applyMutation(deleteVoiceConnectorGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the origination settings for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param deleteVoiceConnectorOriginationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorOrigination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorOriginationResponse> deleteVoiceConnectorOrigination(
            DeleteVoiceConnectorOriginationRequest deleteVoiceConnectorOriginationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the origination settings for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceConnectorOriginationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVoiceConnectorOriginationRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorOriginationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceConnectorOriginationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorOrigination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorOriginationResponse> deleteVoiceConnectorOrigination(
            Consumer<DeleteVoiceConnectorOriginationRequest.Builder> deleteVoiceConnectorOriginationRequest) {
        return deleteVoiceConnectorOrigination(DeleteVoiceConnectorOriginationRequest.builder()
                .applyMutation(deleteVoiceConnectorOriginationRequest).build());
    }

    /**
     * <p>
     * Deletes the proxy configuration from the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param deleteVoiceConnectorProxyRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorProxy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorProxyResponse> deleteVoiceConnectorProxy(
            DeleteVoiceConnectorProxyRequest deleteVoiceConnectorProxyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the proxy configuration from the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceConnectorProxyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVoiceConnectorProxyRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorProxyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceConnectorProxyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorProxy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorProxyResponse> deleteVoiceConnectorProxy(
            Consumer<DeleteVoiceConnectorProxyRequest.Builder> deleteVoiceConnectorProxyRequest) {
        return deleteVoiceConnectorProxy(DeleteVoiceConnectorProxyRequest.builder()
                .applyMutation(deleteVoiceConnectorProxyRequest).build());
    }

    /**
     * <p>
     * Deletes the streaming configuration for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param deleteVoiceConnectorStreamingConfigurationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorStreamingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorStreamingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorStreamingConfigurationResponse> deleteVoiceConnectorStreamingConfiguration(
            DeleteVoiceConnectorStreamingConfigurationRequest deleteVoiceConnectorStreamingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the streaming configuration for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVoiceConnectorStreamingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteVoiceConnectorStreamingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorStreamingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteVoiceConnectorStreamingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorStreamingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorStreamingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorStreamingConfigurationResponse> deleteVoiceConnectorStreamingConfiguration(
            Consumer<DeleteVoiceConnectorStreamingConfigurationRequest.Builder> deleteVoiceConnectorStreamingConfigurationRequest) {
        return deleteVoiceConnectorStreamingConfiguration(DeleteVoiceConnectorStreamingConfigurationRequest.builder()
                .applyMutation(deleteVoiceConnectorStreamingConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the termination settings for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param deleteVoiceConnectorTerminationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorTermination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorTerminationResponse> deleteVoiceConnectorTermination(
            DeleteVoiceConnectorTerminationRequest deleteVoiceConnectorTerminationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the termination settings for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceConnectorTerminationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVoiceConnectorTerminationRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorTerminationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceConnectorTerminationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorTermination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorTerminationResponse> deleteVoiceConnectorTermination(
            Consumer<DeleteVoiceConnectorTerminationRequest.Builder> deleteVoiceConnectorTerminationRequest) {
        return deleteVoiceConnectorTermination(DeleteVoiceConnectorTerminationRequest.builder()
                .applyMutation(deleteVoiceConnectorTerminationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified SIP credentials used by your equipment to authenticate during call termination.
     * </p>
     *
     * @param deleteVoiceConnectorTerminationCredentialsRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorTerminationCredentials operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorTerminationCredentials
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorTerminationCredentialsResponse> deleteVoiceConnectorTerminationCredentials(
            DeleteVoiceConnectorTerminationCredentialsRequest deleteVoiceConnectorTerminationCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified SIP credentials used by your equipment to authenticate during call termination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVoiceConnectorTerminationCredentialsRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteVoiceConnectorTerminationCredentialsRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorTerminationCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteVoiceConnectorTerminationCredentialsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorTerminationCredentials operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DeleteVoiceConnectorTerminationCredentials
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorTerminationCredentialsResponse> deleteVoiceConnectorTerminationCredentials(
            Consumer<DeleteVoiceConnectorTerminationCredentialsRequest.Builder> deleteVoiceConnectorTerminationCredentialsRequest) {
        return deleteVoiceConnectorTerminationCredentials(DeleteVoiceConnectorTerminationCredentialsRequest.builder()
                .applyMutation(deleteVoiceConnectorTerminationCredentialsRequest).build());
    }

    /**
     * <p>
     * Disassociates the primary provisioned phone number from the specified Amazon Chime user.
     * </p>
     *
     * @param disassociatePhoneNumberFromUserRequest
     * @return A Java Future containing the result of the DisassociatePhoneNumberFromUser operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DisassociatePhoneNumberFromUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumberFromUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumberFromUserResponse> disassociatePhoneNumberFromUser(
            DisassociatePhoneNumberFromUserRequest disassociatePhoneNumberFromUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the primary provisioned phone number from the specified Amazon Chime user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePhoneNumberFromUserRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociatePhoneNumberFromUserRequest#builder()}
     * </p>
     *
     * @param disassociatePhoneNumberFromUserRequest
     *        A {@link Consumer} that will call methods on {@link DisassociatePhoneNumberFromUserRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociatePhoneNumberFromUser operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DisassociatePhoneNumberFromUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumberFromUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumberFromUserResponse> disassociatePhoneNumberFromUser(
            Consumer<DisassociatePhoneNumberFromUserRequest.Builder> disassociatePhoneNumberFromUserRequest) {
        return disassociatePhoneNumberFromUser(DisassociatePhoneNumberFromUserRequest.builder()
                .applyMutation(disassociatePhoneNumberFromUserRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param disassociatePhoneNumbersFromVoiceConnectorRequest
     * @return A Java Future containing the result of the DisassociatePhoneNumbersFromVoiceConnector operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DisassociatePhoneNumbersFromVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorResponse> disassociatePhoneNumbersFromVoiceConnector(
            DisassociatePhoneNumbersFromVoiceConnectorRequest disassociatePhoneNumbersFromVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociatePhoneNumbersFromVoiceConnectorRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociatePhoneNumbersFromVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param disassociatePhoneNumbersFromVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociatePhoneNumbersFromVoiceConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociatePhoneNumbersFromVoiceConnector operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DisassociatePhoneNumbersFromVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorResponse> disassociatePhoneNumbersFromVoiceConnector(
            Consumer<DisassociatePhoneNumbersFromVoiceConnectorRequest.Builder> disassociatePhoneNumbersFromVoiceConnectorRequest) {
        return disassociatePhoneNumbersFromVoiceConnector(DisassociatePhoneNumbersFromVoiceConnectorRequest.builder()
                .applyMutation(disassociatePhoneNumbersFromVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.
     * </p>
     *
     * @param disassociatePhoneNumbersFromVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the DisassociatePhoneNumbersFromVoiceConnectorGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DisassociatePhoneNumbersFromVoiceConnectorGroup
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorGroupResponse> disassociatePhoneNumbersFromVoiceConnectorGroup(
            DisassociatePhoneNumbersFromVoiceConnectorGroupRequest disassociatePhoneNumbersFromVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.Builder} avoiding the need to create one manually
     * via {@link DisassociatePhoneNumbersFromVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param disassociatePhoneNumbersFromVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociatePhoneNumbersFromVoiceConnectorGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DisassociatePhoneNumbersFromVoiceConnectorGroup
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorGroupResponse> disassociatePhoneNumbersFromVoiceConnectorGroup(
            Consumer<DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.Builder> disassociatePhoneNumbersFromVoiceConnectorGroupRequest) {
        return disassociatePhoneNumbersFromVoiceConnectorGroup(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.builder()
                .applyMutation(disassociatePhoneNumbersFromVoiceConnectorGroupRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.
     * </p>
     *
     * @param disassociateSigninDelegateGroupsFromAccountRequest
     * @return A Java Future containing the result of the DisassociateSigninDelegateGroupsFromAccount operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DisassociateSigninDelegateGroupsFromAccount
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociateSigninDelegateGroupsFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSigninDelegateGroupsFromAccountResponse> disassociateSigninDelegateGroupsFromAccount(
            DisassociateSigninDelegateGroupsFromAccountRequest disassociateSigninDelegateGroupsFromAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateSigninDelegateGroupsFromAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateSigninDelegateGroupsFromAccountRequest#builder()}
     * </p>
     *
     * @param disassociateSigninDelegateGroupsFromAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateSigninDelegateGroupsFromAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateSigninDelegateGroupsFromAccount operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.DisassociateSigninDelegateGroupsFromAccount
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociateSigninDelegateGroupsFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSigninDelegateGroupsFromAccountResponse> disassociateSigninDelegateGroupsFromAccount(
            Consumer<DisassociateSigninDelegateGroupsFromAccountRequest.Builder> disassociateSigninDelegateGroupsFromAccountRequest) {
        return disassociateSigninDelegateGroupsFromAccount(DisassociateSigninDelegateGroupsFromAccountRequest.builder()
                .applyMutation(disassociateSigninDelegateGroupsFromAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.
     * </p>
     *
     * @param getAccountRequest
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountResponse> getAccount(GetAccountRequest getAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccountRequest#builder()}
     * </p>
     *
     * @param getAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountResponse> getAccount(Consumer<GetAccountRequest.Builder> getAccountRequest) {
        return getAccount(GetAccountRequest.builder().applyMutation(getAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dial out
     * settings. For more information about these settings, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime
     * Administration Guide</i>.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dial out
     * settings. For more information about these settings, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime
     * Administration Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(
            Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest) {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about
     * the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the
     * Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.
     * </p>
     *
     * @param getAttendeeRequest
     * @return A Java Future containing the result of the GetAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAttendeeResponse> getAttendee(GetAttendeeRequest getAttendeeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about
     * the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the
     * Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAttendeeRequest.Builder} avoiding the need to
     * create one manually via {@link GetAttendeeRequest#builder()}
     * </p>
     *
     * @param getAttendeeRequest
     *        A {@link Consumer} that will call methods on {@link GetAttendeeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAttendeeResponse> getAttendee(Consumer<GetAttendeeRequest.Builder> getAttendeeRequest) {
        return getAttendee(GetAttendeeRequest.builder().applyMutation(getAttendeeRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.
     * </p>
     *
     * @param getBotRequest
     * @return A Java Future containing the result of the GetBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBotResponse> getBot(GetBotRequest getBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBotRequest.Builder} avoiding the need to create
     * one manually via {@link GetBotRequest#builder()}
     * </p>
     *
     * @param getBotRequest
     *        A {@link Consumer} that will call methods on {@link GetBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBotResponse> getBot(Consumer<GetBotRequest.Builder> getBotRequest) {
        return getBot(GetBotRequest.builder().applyMutation(getBotRequest).build());
    }

    /**
     * <p>
     * Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint
     * or Lambda function ARN.
     * </p>
     *
     * @param getEventsConfigurationRequest
     * @return A Java Future containing the result of the GetEventsConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetEventsConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetEventsConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventsConfigurationResponse> getEventsConfiguration(
            GetEventsConfigurationRequest getEventsConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint
     * or Lambda function ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventsConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetEventsConfigurationRequest#builder()}
     * </p>
     *
     * @param getEventsConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetEventsConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEventsConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetEventsConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetEventsConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventsConfigurationResponse> getEventsConfiguration(
            Consumer<GetEventsConfigurationRequest.Builder> getEventsConfigurationRequest) {
        return getEventsConfiguration(GetEventsConfigurationRequest.builder().applyMutation(getEventsConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon
     * Chime Voice Connector settings.
     * </p>
     *
     * @param getGlobalSettingsRequest
     * @return A Java Future containing the result of the GetGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetGlobalSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetGlobalSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlobalSettingsResponse> getGlobalSettings(GetGlobalSettingsRequest getGlobalSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon
     * Chime Voice Connector settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlobalSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link GetGlobalSettingsRequest#builder()}
     * </p>
     *
     * @param getGlobalSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetGlobalSettingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetGlobalSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetGlobalSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlobalSettingsResponse> getGlobalSettings(
            Consumer<GetGlobalSettingsRequest.Builder> getGlobalSettingsRequest) {
        return getGlobalSettings(GetGlobalSettingsRequest.builder().applyMutation(getGlobalSettingsRequest).build());
    }

    /**
     * <p>
     * Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon
     * Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime
     * SDK</a> in the <i>Amazon Chime Developer Guide</i>.
     * </p>
     *
     * @param getMeetingRequest
     * @return A Java Future containing the result of the GetMeeting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetMeeting
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetMeeting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMeetingResponse> getMeeting(GetMeetingRequest getMeetingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon
     * Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime
     * SDK</a> in the <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMeetingRequest.Builder} avoiding the need to
     * create one manually via {@link GetMeetingRequest#builder()}
     * </p>
     *
     * @param getMeetingRequest
     *        A {@link Consumer} that will call methods on {@link GetMeetingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMeeting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetMeeting
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetMeeting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMeetingResponse> getMeeting(Consumer<GetMeetingRequest.Builder> getMeetingRequest) {
        return getMeeting(GetMeetingRequest.builder().applyMutation(getMeetingRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
     * </p>
     *
     * @param getPhoneNumberRequest
     * @return A Java Future containing the result of the GetPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetPhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberResponse> getPhoneNumber(GetPhoneNumberRequest getPhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPhoneNumberRequest.Builder} avoiding the need to
     * create one manually via {@link GetPhoneNumberRequest#builder()}
     * </p>
     *
     * @param getPhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link GetPhoneNumberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetPhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberResponse> getPhoneNumber(Consumer<GetPhoneNumberRequest.Builder> getPhoneNumberRequest) {
        return getPhoneNumber(GetPhoneNumberRequest.builder().applyMutation(getPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified phone number order, such as order creation timestamp, phone numbers in E.164
     * format, product type, and order status.
     * </p>
     *
     * @param getPhoneNumberOrderRequest
     * @return A Java Future containing the result of the GetPhoneNumberOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetPhoneNumberOrder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberOrderResponse> getPhoneNumberOrder(
            GetPhoneNumberOrderRequest getPhoneNumberOrderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified phone number order, such as order creation timestamp, phone numbers in E.164
     * format, product type, and order status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPhoneNumberOrderRequest.Builder} avoiding the
     * need to create one manually via {@link GetPhoneNumberOrderRequest#builder()}
     * </p>
     *
     * @param getPhoneNumberOrderRequest
     *        A {@link Consumer} that will call methods on {@link GetPhoneNumberOrderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPhoneNumberOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetPhoneNumberOrder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberOrderResponse> getPhoneNumberOrder(
            Consumer<GetPhoneNumberOrderRequest.Builder> getPhoneNumberOrderRequest) {
        return getPhoneNumberOrder(GetPhoneNumberOrderRequest.builder().applyMutation(getPhoneNumberOrderRequest).build());
    }

    /**
     * <p>
     * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling
     * name.
     * </p>
     *
     * @param getPhoneNumberSettingsRequest
     * @return A Java Future containing the result of the GetPhoneNumberSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetPhoneNumberSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberSettingsResponse> getPhoneNumberSettings(
            GetPhoneNumberSettingsRequest getPhoneNumberSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling
     * name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPhoneNumberSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetPhoneNumberSettingsRequest#builder()}
     * </p>
     *
     * @param getPhoneNumberSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetPhoneNumberSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPhoneNumberSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetPhoneNumberSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberSettingsResponse> getPhoneNumberSettings(
            Consumer<GetPhoneNumberSettingsRequest.Builder> getPhoneNumberSettingsRequest) {
        return getPhoneNumberSettings(GetPhoneNumberSettingsRequest.builder().applyMutation(getPhoneNumberSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Gets the specified proxy session details for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param getProxySessionRequest
     * @return A Java Future containing the result of the GetProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetProxySession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetProxySession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProxySessionResponse> getProxySession(GetProxySessionRequest getProxySessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified proxy session details for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProxySessionRequest.Builder} avoiding the need
     * to create one manually via {@link GetProxySessionRequest#builder()}
     * </p>
     *
     * @param getProxySessionRequest
     *        A {@link Consumer} that will call methods on {@link GetProxySessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetProxySession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetProxySession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProxySessionResponse> getProxySession(
            Consumer<GetProxySessionRequest.Builder> getProxySessionRequest) {
        return getProxySession(GetProxySessionRequest.builder().applyMutation(getProxySessionRequest).build());
    }

    /**
     * <p>
     * Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about
     * retention settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat
     * Retention Policies</a> in the <i>Amazon Chime Administration Guide</i>.
     * </p>
     *
     * @param getRetentionSettingsRequest
     * @return A Java Future containing the result of the GetRetentionSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetRetentionSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRetentionSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRetentionSettingsResponse> getRetentionSettings(
            GetRetentionSettingsRequest getRetentionSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about
     * retention settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat
     * Retention Policies</a> in the <i>Amazon Chime Administration Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRetentionSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetRetentionSettingsRequest#builder()}
     * </p>
     *
     * @param getRetentionSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetRetentionSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRetentionSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetRetentionSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRetentionSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRetentionSettingsResponse> getRetentionSettings(
            Consumer<GetRetentionSettingsRequest.Builder> getRetentionSettingsRequest) {
        return getRetentionSettings(GetRetentionSettingsRequest.builder().applyMutation(getRetentionSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     * </p>
     *
     * @param getRoomRequest
     * @return A Java Future containing the result of the GetRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRoomResponse> getRoom(GetRoomRequest getRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRoomRequest.Builder} avoiding the need to create
     * one manually via {@link GetRoomRequest#builder()}
     * </p>
     *
     * @param getRoomRequest
     *        A {@link Consumer} that will call methods on {@link GetRoomRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRoomResponse> getRoom(Consumer<GetRoomRequest.Builder> getRoomRequest) {
        return getRoom(GetRoomRequest.builder().applyMutation(getRoomRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified user ID, such as primary email address, license type, and personal meeting
     * PIN.
     * </p>
     * <p>
     * To retrieve user details with an email address instead of a user ID, use the <a>ListUsers</a> action, and then
     * filter by email address.
     * </p>
     *
     * @param getUserRequest
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified user ID, such as primary email address, license type, and personal meeting
     * PIN.
     * </p>
     * <p>
     * To retrieve user details with an email address instead of a user ID, use the <a>ListUsers</a> action, and then
     * filter by email address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserRequest.Builder} avoiding the need to create
     * one manually via {@link GetUserRequest#builder()}
     * </p>
     *
     * @param getUserRequest
     *        A {@link Consumer} that will call methods on {@link GetUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser(Consumer<GetUserRequest.Builder> getUserRequest) {
        return getUser(GetUserRequest.builder().applyMutation(getUserRequest).build());
    }

    /**
     * <p>
     * Retrieves settings for the specified user ID, such as any associated phone number settings.
     * </p>
     *
     * @param getUserSettingsRequest
     * @return A Java Future containing the result of the GetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetUserSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUserSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserSettingsResponse> getUserSettings(GetUserSettingsRequest getUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves settings for the specified user ID, such as any associated phone number settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link GetUserSettingsRequest#builder()}
     * </p>
     *
     * @param getUserSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetUserSettingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetUserSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUserSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserSettingsResponse> getUserSettings(
            Consumer<GetUserSettingsRequest.Builder> getUserSettingsRequest) {
        return getUserSettings(GetUserSettingsRequest.builder().applyMutation(getUserSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps, name, outbound host, and
     * encryption requirements.
     * </p>
     *
     * @param getVoiceConnectorRequest
     * @return A Java Future containing the result of the GetVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorResponse> getVoiceConnector(GetVoiceConnectorRequest getVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps, name, outbound host, and
     * encryption requirements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link GetVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorResponse> getVoiceConnector(
            Consumer<GetVoiceConnectorRequest.Builder> getVoiceConnectorRequest) {
        return getVoiceConnector(GetVoiceConnectorRequest.builder().applyMutation(getVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps, name, and associated
     * <code>VoiceConnectorItems</code>.
     * </p>
     *
     * @param getVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the GetVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorGroupResponse> getVoiceConnectorGroup(
            GetVoiceConnectorGroupRequest getVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps, name, and associated
     * <code>VoiceConnectorItems</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorGroupResponse> getVoiceConnectorGroup(
            Consumer<GetVoiceConnectorGroupRequest.Builder> getVoiceConnectorGroupRequest) {
        return getVoiceConnectorGroup(GetVoiceConnectorGroupRequest.builder().applyMutation(getVoiceConnectorGroupRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP
     * message logs are enabled for sending to Amazon CloudWatch Logs.
     * </p>
     *
     * @param getVoiceConnectorLoggingConfigurationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorLoggingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorLoggingConfigurationResponse> getVoiceConnectorLoggingConfiguration(
            GetVoiceConnectorLoggingConfigurationRequest getVoiceConnectorLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP
     * message logs are enabled for sending to Amazon CloudWatch Logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetVoiceConnectorLoggingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetVoiceConnectorLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorLoggingConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetVoiceConnectorLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorLoggingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorLoggingConfigurationResponse> getVoiceConnectorLoggingConfiguration(
            Consumer<GetVoiceConnectorLoggingConfigurationRequest.Builder> getVoiceConnectorLoggingConfigurationRequest) {
        return getVoiceConnectorLoggingConfiguration(GetVoiceConnectorLoggingConfigurationRequest.builder()
                .applyMutation(getVoiceConnectorLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves origination setting details for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param getVoiceConnectorOriginationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorOrigination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorOriginationResponse> getVoiceConnectorOrigination(
            GetVoiceConnectorOriginationRequest getVoiceConnectorOriginationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves origination setting details for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorOriginationRequest.Builder}
     * avoiding the need to create one manually via {@link GetVoiceConnectorOriginationRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorOriginationRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorOriginationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorOrigination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorOriginationResponse> getVoiceConnectorOrigination(
            Consumer<GetVoiceConnectorOriginationRequest.Builder> getVoiceConnectorOriginationRequest) {
        return getVoiceConnectorOrigination(GetVoiceConnectorOriginationRequest.builder()
                .applyMutation(getVoiceConnectorOriginationRequest).build());
    }

    /**
     * <p>
     * Gets the proxy configuration details for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param getVoiceConnectorProxyRequest
     * @return A Java Future containing the result of the GetVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorProxy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorProxy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorProxyResponse> getVoiceConnectorProxy(
            GetVoiceConnectorProxyRequest getVoiceConnectorProxyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the proxy configuration details for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorProxyRequest.Builder} avoiding the
     * need to create one manually via {@link GetVoiceConnectorProxyRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorProxyRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorProxyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorProxy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorProxy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorProxyResponse> getVoiceConnectorProxy(
            Consumer<GetVoiceConnectorProxyRequest.Builder> getVoiceConnectorProxyRequest) {
        return getVoiceConnectorProxy(GetVoiceConnectorProxyRequest.builder().applyMutation(getVoiceConnectorProxyRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector. Shows whether media
     * streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the Amazon
     * Kinesis data.
     * </p>
     *
     * @param getVoiceConnectorStreamingConfigurationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorStreamingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorStreamingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorStreamingConfigurationResponse> getVoiceConnectorStreamingConfiguration(
            GetVoiceConnectorStreamingConfigurationRequest getVoiceConnectorStreamingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector. Shows whether media
     * streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the Amazon
     * Kinesis data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetVoiceConnectorStreamingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetVoiceConnectorStreamingConfigurationRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorStreamingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetVoiceConnectorStreamingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVoiceConnectorStreamingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorStreamingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorStreamingConfigurationResponse> getVoiceConnectorStreamingConfiguration(
            Consumer<GetVoiceConnectorStreamingConfigurationRequest.Builder> getVoiceConnectorStreamingConfigurationRequest) {
        return getVoiceConnectorStreamingConfiguration(GetVoiceConnectorStreamingConfigurationRequest.builder()
                .applyMutation(getVoiceConnectorStreamingConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves termination setting details for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param getVoiceConnectorTerminationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorTermination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorTerminationResponse> getVoiceConnectorTermination(
            GetVoiceConnectorTerminationRequest getVoiceConnectorTerminationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves termination setting details for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorTerminationRequest.Builder}
     * avoiding the need to create one manually via {@link GetVoiceConnectorTerminationRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorTerminationRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorTerminationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorTermination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorTerminationResponse> getVoiceConnectorTermination(
            Consumer<GetVoiceConnectorTerminationRequest.Builder> getVoiceConnectorTerminationRequest) {
        return getVoiceConnectorTermination(GetVoiceConnectorTerminationRequest.builder()
                .applyMutation(getVoiceConnectorTerminationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the last time a SIP <code>OPTIONS</code> ping was received from your SIP
     * infrastructure for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param getVoiceConnectorTerminationHealthRequest
     * @return A Java Future containing the result of the GetVoiceConnectorTerminationHealth operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorTerminationHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTerminationHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorTerminationHealthResponse> getVoiceConnectorTerminationHealth(
            GetVoiceConnectorTerminationHealthRequest getVoiceConnectorTerminationHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the last time a SIP <code>OPTIONS</code> ping was received from your SIP
     * infrastructure for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorTerminationHealthRequest.Builder}
     * avoiding the need to create one manually via {@link GetVoiceConnectorTerminationHealthRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorTerminationHealthRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorTerminationHealthRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetVoiceConnectorTerminationHealth operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.GetVoiceConnectorTerminationHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTerminationHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorTerminationHealthResponse> getVoiceConnectorTerminationHealth(
            Consumer<GetVoiceConnectorTerminationHealthRequest.Builder> getVoiceConnectorTerminationHealthRequest) {
        return getVoiceConnectorTerminationHealth(GetVoiceConnectorTerminationHealthRequest.builder()
                .applyMutation(getVoiceConnectorTerminationHealthRequest).build());
    }

    /**
     * <p>
     * Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime <code>Team</code> account. Only
     * <code>Team</code> account types are currently supported for this action.
     * </p>
     *
     * @param inviteUsersRequest
     * @return A Java Future containing the result of the InviteUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.InviteUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/InviteUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InviteUsersResponse> inviteUsers(InviteUsersRequest inviteUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime <code>Team</code> account. Only
     * <code>Team</code> account types are currently supported for this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InviteUsersRequest.Builder} avoiding the need to
     * create one manually via {@link InviteUsersRequest#builder()}
     * </p>
     *
     * @param inviteUsersRequest
     *        A {@link Consumer} that will call methods on {@link InviteUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the InviteUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.InviteUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/InviteUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InviteUsersResponse> inviteUsers(Consumer<InviteUsersRequest.Builder> inviteUsersRequest) {
        return inviteUsers(InviteUsersRequest.builder().applyMutation(inviteUsersRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name
     * prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address,
     * which returns one account result.
     * </p>
     *
     * @param listAccountsRequest
     * @return A Java Future containing the result of the ListAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountsResponse> listAccounts(ListAccountsRequest listAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name
     * prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address,
     * which returns one account result.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccountsRequest#builder()}
     * </p>
     *
     * @param listAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountsResponse> listAccounts(Consumer<ListAccountsRequest.Builder> listAccountsRequest) {
        return listAccounts(ListAccountsRequest.builder().applyMutation(listAccountsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name
     * prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address,
     * which returns one account result.
     * </p>
     *
     * @return A Java Future containing the result of the ListAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountsResponse> listAccounts() {
        return listAccounts(ListAccountsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name
     * prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address,
     * which returns one account result.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAccounts(software.amazon.awssdk.services.chime.model.ListAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListAccountsPublisher publisher = client.listAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListAccountsPublisher publisher = client.listAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccounts(software.amazon.awssdk.services.chime.model.ListAccountsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountsPublisher listAccountsPaginator() {
        return listAccountsPaginator(ListAccountsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name
     * prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address,
     * which returns one account result.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAccounts(software.amazon.awssdk.services.chime.model.ListAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListAccountsPublisher publisher = client.listAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListAccountsPublisher publisher = client.listAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccounts(software.amazon.awssdk.services.chime.model.ListAccountsRequest)} operation.</b>
     * </p>
     *
     * @param listAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountsPublisher listAccountsPaginator(ListAccountsRequest listAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name
     * prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address,
     * which returns one account result.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAccounts(software.amazon.awssdk.services.chime.model.ListAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListAccountsPublisher publisher = client.listAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListAccountsPublisher publisher = client.listAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccounts(software.amazon.awssdk.services.chime.model.ListAccountsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccountsRequest#builder()}
     * </p>
     *
     * @param listAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountsPublisher listAccountsPaginator(Consumer<ListAccountsRequest.Builder> listAccountsRequest) {
        return listAccountsPaginator(ListAccountsRequest.builder().applyMutation(listAccountsRequest).build());
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon Chime SDK attendee resource.
     * </p>
     *
     * @param listAttendeeTagsRequest
     * @return A Java Future containing the result of the ListAttendeeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAttendeeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendeeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttendeeTagsResponse> listAttendeeTags(ListAttendeeTagsRequest listAttendeeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon Chime SDK attendee resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttendeeTagsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAttendeeTagsRequest#builder()}
     * </p>
     *
     * @param listAttendeeTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListAttendeeTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAttendeeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAttendeeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendeeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttendeeTagsResponse> listAttendeeTags(
            Consumer<ListAttendeeTagsRequest.Builder> listAttendeeTagsRequest) {
        return listAttendeeTags(ListAttendeeTagsRequest.builder().applyMutation(listAttendeeTagsRequest).build());
    }

    /**
     * <p>
     * Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK,
     * see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     *
     * @param listAttendeesRequest
     * @return A Java Future containing the result of the ListAttendees operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAttendees
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendees" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttendeesResponse> listAttendees(ListAttendeesRequest listAttendeesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK,
     * see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttendeesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAttendeesRequest#builder()}
     * </p>
     *
     * @param listAttendeesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttendeesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAttendees operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAttendees
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendees" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttendeesResponse> listAttendees(Consumer<ListAttendeesRequest.Builder> listAttendeesRequest) {
        return listAttendees(ListAttendeesRequest.builder().applyMutation(listAttendeesRequest).build());
    }

    /**
     * <p>
     * Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK,
     * see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAttendees(software.amazon.awssdk.services.chime.model.ListAttendeesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListAttendeesPublisher publisher = client.listAttendeesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListAttendeesPublisher publisher = client.listAttendeesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListAttendeesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListAttendeesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttendees(software.amazon.awssdk.services.chime.model.ListAttendeesRequest)} operation.</b>
     * </p>
     *
     * @param listAttendeesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAttendees
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendees" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttendeesPublisher listAttendeesPaginator(ListAttendeesRequest listAttendeesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK,
     * see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAttendees(software.amazon.awssdk.services.chime.model.ListAttendeesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListAttendeesPublisher publisher = client.listAttendeesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListAttendeesPublisher publisher = client.listAttendeesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListAttendeesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListAttendeesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttendees(software.amazon.awssdk.services.chime.model.ListAttendeesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttendeesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAttendeesRequest#builder()}
     * </p>
     *
     * @param listAttendeesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttendeesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListAttendees
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendees" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttendeesPublisher listAttendeesPaginator(Consumer<ListAttendeesRequest.Builder> listAttendeesRequest) {
        return listAttendeesPaginator(ListAttendeesRequest.builder().applyMutation(listAttendeesRequest).build());
    }

    /**
     * <p>
     * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
     * </p>
     *
     * @param listBotsRequest
     * @return A Java Future containing the result of the ListBots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBotsResponse> listBots(ListBotsRequest listBotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBotsResponse> listBots(Consumer<ListBotsRequest.Builder> listBotsRequest) {
        return listBots(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.chime.model.ListBotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListBotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListBotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.chime.model.ListBotsRequest)} operation.</b>
     * </p>
     *
     * @param listBotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsPublisher listBotsPaginator(ListBotsRequest listBotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.chime.model.ListBotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListBotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListBotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.chime.model.ListBotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsPublisher listBotsPaginator(Consumer<ListBotsRequest.Builder> listBotsRequest) {
        return listBotsPaginator(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     * </p>
     *
     * @param listMeetingTagsRequest
     * @return A Java Future containing the result of the ListMeetingTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListMeetingTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetingTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMeetingTagsResponse> listMeetingTags(ListMeetingTagsRequest listMeetingTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMeetingTagsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMeetingTagsRequest#builder()}
     * </p>
     *
     * @param listMeetingTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListMeetingTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMeetingTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListMeetingTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetingTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMeetingTagsResponse> listMeetingTags(
            Consumer<ListMeetingTagsRequest.Builder> listMeetingTagsRequest) {
        return listMeetingTags(ListMeetingTagsRequest.builder().applyMutation(listMeetingTagsRequest).build());
    }

    /**
     * <p>
     * Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see <a
     * href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     *
     * @param listMeetingsRequest
     * @return A Java Future containing the result of the ListMeetings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListMeetings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMeetingsResponse> listMeetings(ListMeetingsRequest listMeetingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see <a
     * href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMeetingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMeetingsRequest#builder()}
     * </p>
     *
     * @param listMeetingsRequest
     *        A {@link Consumer} that will call methods on {@link ListMeetingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMeetings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListMeetings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMeetingsResponse> listMeetings(Consumer<ListMeetingsRequest.Builder> listMeetingsRequest) {
        return listMeetings(ListMeetingsRequest.builder().applyMutation(listMeetingsRequest).build());
    }

    /**
     * <p>
     * Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see <a
     * href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMeetings(software.amazon.awssdk.services.chime.model.ListMeetingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListMeetingsPublisher publisher = client.listMeetingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListMeetingsPublisher publisher = client.listMeetingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListMeetingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListMeetingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMeetings(software.amazon.awssdk.services.chime.model.ListMeetingsRequest)} operation.</b>
     * </p>
     *
     * @param listMeetingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListMeetings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMeetingsPublisher listMeetingsPaginator(ListMeetingsRequest listMeetingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see <a
     * href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the
     * <i>Amazon Chime Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMeetings(software.amazon.awssdk.services.chime.model.ListMeetingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListMeetingsPublisher publisher = client.listMeetingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListMeetingsPublisher publisher = client.listMeetingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListMeetingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListMeetingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMeetings(software.amazon.awssdk.services.chime.model.ListMeetingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMeetingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMeetingsRequest#builder()}
     * </p>
     *
     * @param listMeetingsRequest
     *        A {@link Consumer} that will call methods on {@link ListMeetingsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListMeetings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMeetingsPublisher listMeetingsPaginator(Consumer<ListMeetingsRequest.Builder> listMeetingsRequest) {
        return listMeetingsPaginator(ListMeetingsRequest.builder().applyMutation(listMeetingsRequest).build());
    }

    /**
     * <p>
     * Lists the phone number orders for the administrator's Amazon Chime account.
     * </p>
     *
     * @param listPhoneNumberOrdersRequest
     * @return A Java Future containing the result of the ListPhoneNumberOrders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListPhoneNumberOrders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPhoneNumberOrdersResponse> listPhoneNumberOrders(
            ListPhoneNumberOrdersRequest listPhoneNumberOrdersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the phone number orders for the administrator's Amazon Chime account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumberOrdersRequest.Builder} avoiding the
     * need to create one manually via {@link ListPhoneNumberOrdersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumberOrdersRequest
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumberOrdersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPhoneNumberOrders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListPhoneNumberOrders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPhoneNumberOrdersResponse> listPhoneNumberOrders(
            Consumer<ListPhoneNumberOrdersRequest.Builder> listPhoneNumberOrdersRequest) {
        return listPhoneNumberOrders(ListPhoneNumberOrdersRequest.builder().applyMutation(listPhoneNumberOrdersRequest).build());
    }

    /**
     * <p>
     * Lists the phone number orders for the administrator's Amazon Chime account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumberOrders(software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListPhoneNumberOrdersPublisher publisher = client.listPhoneNumberOrdersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListPhoneNumberOrdersPublisher publisher = client.listPhoneNumberOrdersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumberOrders(software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPhoneNumberOrdersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListPhoneNumberOrders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPhoneNumberOrdersPublisher listPhoneNumberOrdersPaginator(
            ListPhoneNumberOrdersRequest listPhoneNumberOrdersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the phone number orders for the administrator's Amazon Chime account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumberOrders(software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListPhoneNumberOrdersPublisher publisher = client.listPhoneNumberOrdersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListPhoneNumberOrdersPublisher publisher = client.listPhoneNumberOrdersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumberOrders(software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumberOrdersRequest.Builder} avoiding the
     * need to create one manually via {@link ListPhoneNumberOrdersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumberOrdersRequest
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumberOrdersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListPhoneNumberOrders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPhoneNumberOrdersPublisher listPhoneNumberOrdersPaginator(
            Consumer<ListPhoneNumberOrdersRequest.Builder> listPhoneNumberOrdersRequest) {
        return listPhoneNumberOrdersPaginator(ListPhoneNumberOrdersRequest.builder().applyMutation(listPhoneNumberOrdersRequest)
                .build());
    }

    /**
     * <p>
     * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector,
     * or Amazon Chime Voice Connector group.
     * </p>
     *
     * @param listPhoneNumbersRequest
     * @return A Java Future containing the result of the ListPhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListPhoneNumbers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPhoneNumbersResponse> listPhoneNumbers(ListPhoneNumbersRequest listPhoneNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector,
     * or Amazon Chime Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersRequest.Builder} avoiding the need
     * to create one manually via {@link ListPhoneNumbersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumbersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListPhoneNumbers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPhoneNumbersResponse> listPhoneNumbers(
            Consumer<ListPhoneNumbersRequest.Builder> listPhoneNumbersRequest) {
        return listPhoneNumbers(ListPhoneNumbersRequest.builder().applyMutation(listPhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector,
     * or Amazon Chime Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.chime.model.ListPhoneNumbersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListPhoneNumbersPublisher publisher = client.listPhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListPhoneNumbersPublisher publisher = client.listPhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListPhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListPhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.chime.model.ListPhoneNumbersRequest)} operation.</b>
     * </p>
     *
     * @param listPhoneNumbersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListPhoneNumbers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPhoneNumbersPublisher listPhoneNumbersPaginator(ListPhoneNumbersRequest listPhoneNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector,
     * or Amazon Chime Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.chime.model.ListPhoneNumbersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListPhoneNumbersPublisher publisher = client.listPhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListPhoneNumbersPublisher publisher = client.listPhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListPhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListPhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.chime.model.ListPhoneNumbersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersRequest.Builder} avoiding the need
     * to create one manually via {@link ListPhoneNumbersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumbersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListPhoneNumbers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPhoneNumbersPublisher listPhoneNumbersPaginator(Consumer<ListPhoneNumbersRequest.Builder> listPhoneNumbersRequest) {
        return listPhoneNumbersPaginator(ListPhoneNumbersRequest.builder().applyMutation(listPhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Lists the proxy sessions for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param listProxySessionsRequest
     * @return A Java Future containing the result of the ListProxySessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListProxySessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListProxySessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProxySessionsResponse> listProxySessions(ListProxySessionsRequest listProxySessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the proxy sessions for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProxySessionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProxySessionsRequest#builder()}
     * </p>
     *
     * @param listProxySessionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProxySessionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListProxySessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListProxySessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListProxySessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProxySessionsResponse> listProxySessions(
            Consumer<ListProxySessionsRequest.Builder> listProxySessionsRequest) {
        return listProxySessions(ListProxySessionsRequest.builder().applyMutation(listProxySessionsRequest).build());
    }

    /**
     * <p>
     * Lists the proxy sessions for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProxySessions(software.amazon.awssdk.services.chime.model.ListProxySessionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListProxySessionsPublisher publisher = client.listProxySessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListProxySessionsPublisher publisher = client.listProxySessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListProxySessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListProxySessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxySessions(software.amazon.awssdk.services.chime.model.ListProxySessionsRequest)} operation.</b>
     * </p>
     *
     * @param listProxySessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListProxySessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListProxySessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProxySessionsPublisher listProxySessionsPaginator(ListProxySessionsRequest listProxySessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the proxy sessions for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProxySessions(software.amazon.awssdk.services.chime.model.ListProxySessionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListProxySessionsPublisher publisher = client.listProxySessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListProxySessionsPublisher publisher = client.listProxySessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListProxySessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListProxySessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxySessions(software.amazon.awssdk.services.chime.model.ListProxySessionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProxySessionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProxySessionsRequest#builder()}
     * </p>
     *
     * @param listProxySessionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProxySessionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListProxySessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListProxySessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProxySessionsPublisher listProxySessionsPaginator(
            Consumer<ListProxySessionsRequest.Builder> listProxySessionsRequest) {
        return listProxySessionsPaginator(ListProxySessionsRequest.builder().applyMutation(listProxySessionsRequest).build());
    }

    /**
     * <p>
     * Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members'
     * IDs, email addresses, and names.
     * </p>
     *
     * @param listRoomMembershipsRequest
     * @return A Java Future containing the result of the ListRoomMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListRoomMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRoomMemberships" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRoomMembershipsResponse> listRoomMemberships(
            ListRoomMembershipsRequest listRoomMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members'
     * IDs, email addresses, and names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoomMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRoomMembershipsRequest#builder()}
     * </p>
     *
     * @param listRoomMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link ListRoomMembershipsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRoomMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListRoomMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRoomMemberships" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRoomMembershipsResponse> listRoomMemberships(
            Consumer<ListRoomMembershipsRequest.Builder> listRoomMembershipsRequest) {
        return listRoomMemberships(ListRoomMembershipsRequest.builder().applyMutation(listRoomMembershipsRequest).build());
    }

    /**
     * <p>
     * Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members'
     * IDs, email addresses, and names.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRoomMemberships(software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListRoomMembershipsPublisher publisher = client.listRoomMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListRoomMembershipsPublisher publisher = client.listRoomMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoomMemberships(software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRoomMembershipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListRoomMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRoomMemberships" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRoomMembershipsPublisher listRoomMembershipsPaginator(ListRoomMembershipsRequest listRoomMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members'
     * IDs, email addresses, and names.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRoomMemberships(software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListRoomMembershipsPublisher publisher = client.listRoomMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListRoomMembershipsPublisher publisher = client.listRoomMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListRoomMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoomMemberships(software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoomMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRoomMembershipsRequest#builder()}
     * </p>
     *
     * @param listRoomMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link ListRoomMembershipsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListRoomMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRoomMemberships" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRoomMembershipsPublisher listRoomMembershipsPaginator(
            Consumer<ListRoomMembershipsRequest.Builder> listRoomMembershipsRequest) {
        return listRoomMembershipsPaginator(ListRoomMembershipsRequest.builder().applyMutation(listRoomMembershipsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a
     * member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
     * </p>
     *
     * @param listRoomsRequest
     * @return A Java Future containing the result of the ListRooms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRooms" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRoomsResponse> listRooms(ListRoomsRequest listRoomsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a
     * member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoomsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRoomsRequest#builder()}
     * </p>
     *
     * @param listRoomsRequest
     *        A {@link Consumer} that will call methods on {@link ListRoomsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRooms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRooms" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRoomsResponse> listRooms(Consumer<ListRoomsRequest.Builder> listRoomsRequest) {
        return listRooms(ListRoomsRequest.builder().applyMutation(listRoomsRequest).build());
    }

    /**
     * <p>
     * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a
     * member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRooms(software.amazon.awssdk.services.chime.model.ListRoomsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListRoomsPublisher publisher = client.listRoomsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListRoomsPublisher publisher = client.listRoomsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListRoomsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListRoomsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRooms(software.amazon.awssdk.services.chime.model.ListRoomsRequest)} operation.</b>
     * </p>
     *
     * @param listRoomsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRooms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRoomsPublisher listRoomsPaginator(ListRoomsRequest listRoomsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a
     * member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRooms(software.amazon.awssdk.services.chime.model.ListRoomsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListRoomsPublisher publisher = client.listRoomsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListRoomsPublisher publisher = client.listRoomsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListRoomsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListRoomsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRooms(software.amazon.awssdk.services.chime.model.ListRoomsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoomsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRoomsRequest#builder()}
     * </p>
     *
     * @param listRoomsRequest
     *        A {@link Consumer} that will call methods on {@link ListRoomsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRooms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRoomsPublisher listRoomsPaginator(Consumer<ListRoomsRequest.Builder> listRoomsRequest) {
        return listRoomsPaginator(ListRoomsRequest.builder().applyMutation(listRoomsRequest).build());
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only
     * the user that the email address belongs to.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only
     * the user that the email address belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only
     * the user that the email address belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.chime.model.ListUsersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.chime.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only
     * the user that the email address belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.chime.model.ListUsersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.chime.model.ListUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.
     * </p>
     *
     * @param listVoiceConnectorGroupsRequest
     * @return A Java Future containing the result of the ListVoiceConnectorGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListVoiceConnectorGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorGroupsResponse> listVoiceConnectorGroups(
            ListVoiceConnectorGroupsRequest listVoiceConnectorGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceConnectorGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListVoiceConnectorGroupsRequest#builder()}
     * </p>
     *
     * @param listVoiceConnectorGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceConnectorGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVoiceConnectorGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListVoiceConnectorGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorGroupsResponse> listVoiceConnectorGroups(
            Consumer<ListVoiceConnectorGroupsRequest.Builder> listVoiceConnectorGroupsRequest) {
        return listVoiceConnectorGroups(ListVoiceConnectorGroupsRequest.builder().applyMutation(listVoiceConnectorGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceConnectorGroups(software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorGroupsPublisher publisher = client.listVoiceConnectorGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorGroupsPublisher publisher = client.listVoiceConnectorGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceConnectorGroups(software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVoiceConnectorGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListVoiceConnectorGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVoiceConnectorGroupsPublisher listVoiceConnectorGroupsPaginator(
            ListVoiceConnectorGroupsRequest listVoiceConnectorGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceConnectorGroups(software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorGroupsPublisher publisher = client.listVoiceConnectorGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorGroupsPublisher publisher = client.listVoiceConnectorGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceConnectorGroups(software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceConnectorGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListVoiceConnectorGroupsRequest#builder()}
     * </p>
     *
     * @param listVoiceConnectorGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceConnectorGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListVoiceConnectorGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVoiceConnectorGroupsPublisher listVoiceConnectorGroupsPaginator(
            Consumer<ListVoiceConnectorGroupsRequest.Builder> listVoiceConnectorGroupsRequest) {
        return listVoiceConnectorGroupsPaginator(ListVoiceConnectorGroupsRequest.builder()
                .applyMutation(listVoiceConnectorGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the SIP credentials for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param listVoiceConnectorTerminationCredentialsRequest
     * @return A Java Future containing the result of the ListVoiceConnectorTerminationCredentials operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListVoiceConnectorTerminationCredentials
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorTerminationCredentialsResponse> listVoiceConnectorTerminationCredentials(
            ListVoiceConnectorTerminationCredentialsRequest listVoiceConnectorTerminationCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SIP credentials for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListVoiceConnectorTerminationCredentialsRequest.Builder} avoiding the need to create one manually via
     * {@link ListVoiceConnectorTerminationCredentialsRequest#builder()}
     * </p>
     *
     * @param listVoiceConnectorTerminationCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListVoiceConnectorTerminationCredentialsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVoiceConnectorTerminationCredentials operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListVoiceConnectorTerminationCredentials
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorTerminationCredentialsResponse> listVoiceConnectorTerminationCredentials(
            Consumer<ListVoiceConnectorTerminationCredentialsRequest.Builder> listVoiceConnectorTerminationCredentialsRequest) {
        return listVoiceConnectorTerminationCredentials(ListVoiceConnectorTerminationCredentialsRequest.builder()
                .applyMutation(listVoiceConnectorTerminationCredentialsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
     * </p>
     *
     * @param listVoiceConnectorsRequest
     * @return A Java Future containing the result of the ListVoiceConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListVoiceConnectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorsResponse> listVoiceConnectors(
            ListVoiceConnectorsRequest listVoiceConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVoiceConnectorsRequest#builder()}
     * </p>
     *
     * @param listVoiceConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceConnectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVoiceConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListVoiceConnectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorsResponse> listVoiceConnectors(
            Consumer<ListVoiceConnectorsRequest.Builder> listVoiceConnectorsRequest) {
        return listVoiceConnectors(ListVoiceConnectorsRequest.builder().applyMutation(listVoiceConnectorsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceConnectors(software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorsPublisher publisher = client.listVoiceConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorsPublisher publisher = client.listVoiceConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListVoiceConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListVoiceConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceConnectors(software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVoiceConnectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListVoiceConnectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVoiceConnectorsPublisher listVoiceConnectorsPaginator(ListVoiceConnectorsRequest listVoiceConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceConnectors(software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorsPublisher publisher = client.listVoiceConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chime.paginators.ListVoiceConnectorsPublisher publisher = client.listVoiceConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chime.model.ListVoiceConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chime.model.ListVoiceConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceConnectors(software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVoiceConnectorsRequest#builder()}
     * </p>
     *
     * @param listVoiceConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceConnectorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ListVoiceConnectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVoiceConnectorsPublisher listVoiceConnectorsPaginator(
            Consumer<ListVoiceConnectorsRequest.Builder> listVoiceConnectorsRequest) {
        return listVoiceConnectorsPaginator(ListVoiceConnectorsRequest.builder().applyMutation(listVoiceConnectorsRequest)
                .build());
    }

    /**
     * <p>
     * Logs out the specified user from all of the devices they are currently logged into.
     * </p>
     *
     * @param logoutUserRequest
     * @return A Java Future containing the result of the LogoutUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.LogoutUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/LogoutUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LogoutUserResponse> logoutUser(LogoutUserRequest logoutUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Logs out the specified user from all of the devices they are currently logged into.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link LogoutUserRequest.Builder} avoiding the need to
     * create one manually via {@link LogoutUserRequest#builder()}
     * </p>
     *
     * @param logoutUserRequest
     *        A {@link Consumer} that will call methods on {@link LogoutUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the LogoutUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.LogoutUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/LogoutUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LogoutUserResponse> logoutUser(Consumer<LogoutUserRequest.Builder> logoutUserRequest) {
        return logoutUser(LogoutUserRequest.builder().applyMutation(logoutUserRequest).build());
    }

    /**
     * <p>
     * Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either
     * an HTTPS endpoint or a Lambda function ARN. For more information, see <a>Bot</a>.
     * </p>
     *
     * @param putEventsConfigurationRequest
     * @return A Java Future containing the result of the PutEventsConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutEventsConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutEventsConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEventsConfigurationResponse> putEventsConfiguration(
            PutEventsConfigurationRequest putEventsConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either
     * an HTTPS endpoint or a Lambda function ARN. For more information, see <a>Bot</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventsConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link PutEventsConfigurationRequest#builder()}
     * </p>
     *
     * @param putEventsConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutEventsConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutEventsConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutEventsConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutEventsConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEventsConfigurationResponse> putEventsConfiguration(
            Consumer<PutEventsConfigurationRequest.Builder> putEventsConfigurationRequest) {
        return putEventsConfiguration(PutEventsConfigurationRequest.builder().applyMutation(putEventsConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to
     * monitor usage of this API for your account. For more information, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html">Logging Amazon Chime API Calls with AWS
     * CloudTrail</a> in the <i>Amazon Chime Administration Guide</i>.
     * </p>
     * <p>
     * To turn off existing retention settings, remove the number of days from the corresponding <b>RetentionDays</b>
     * field in the <b>RetentionSettings</b> object. For more information about retention settings, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies</a> in
     * the <i>Amazon Chime Administration Guide</i>.
     * </p>
     *
     * @param putRetentionSettingsRequest
     * @return A Java Future containing the result of the PutRetentionSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutRetentionSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutRetentionSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutRetentionSettingsResponse> putRetentionSettings(
            PutRetentionSettingsRequest putRetentionSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to
     * monitor usage of this API for your account. For more information, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html">Logging Amazon Chime API Calls with AWS
     * CloudTrail</a> in the <i>Amazon Chime Administration Guide</i>.
     * </p>
     * <p>
     * To turn off existing retention settings, remove the number of days from the corresponding <b>RetentionDays</b>
     * field in the <b>RetentionSettings</b> object. For more information about retention settings, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies</a> in
     * the <i>Amazon Chime Administration Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRetentionSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link PutRetentionSettingsRequest#builder()}
     * </p>
     *
     * @param putRetentionSettingsRequest
     *        A {@link Consumer} that will call methods on {@link PutRetentionSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutRetentionSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutRetentionSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutRetentionSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutRetentionSettingsResponse> putRetentionSettings(
            Consumer<PutRetentionSettingsRequest.Builder> putRetentionSettingsRequest) {
        return putRetentionSettings(PutRetentionSettingsRequest.builder().applyMutation(putRetentionSettingsRequest).build());
    }

    /**
     * <p>
     * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies
     * whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
     * </p>
     *
     * @param putVoiceConnectorLoggingConfigurationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorLoggingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorLoggingConfigurationResponse> putVoiceConnectorLoggingConfiguration(
            PutVoiceConnectorLoggingConfigurationRequest putVoiceConnectorLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies
     * whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutVoiceConnectorLoggingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutVoiceConnectorLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutVoiceConnectorLoggingConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutVoiceConnectorLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorLoggingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorLoggingConfigurationResponse> putVoiceConnectorLoggingConfiguration(
            Consumer<PutVoiceConnectorLoggingConfigurationRequest.Builder> putVoiceConnectorLoggingConfigurationRequest) {
        return putVoiceConnectorLoggingConfiguration(PutVoiceConnectorLoggingConfigurationRequest.builder()
                .applyMutation(putVoiceConnectorLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Adds origination settings for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param putVoiceConnectorOriginationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorOrigination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorOriginationResponse> putVoiceConnectorOrigination(
            PutVoiceConnectorOriginationRequest putVoiceConnectorOriginationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds origination settings for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutVoiceConnectorOriginationRequest.Builder}
     * avoiding the need to create one manually via {@link PutVoiceConnectorOriginationRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorOriginationRequest
     *        A {@link Consumer} that will call methods on {@link PutVoiceConnectorOriginationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorOrigination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorOriginationResponse> putVoiceConnectorOrigination(
            Consumer<PutVoiceConnectorOriginationRequest.Builder> putVoiceConnectorOriginationRequest) {
        return putVoiceConnectorOrigination(PutVoiceConnectorOriginationRequest.builder()
                .applyMutation(putVoiceConnectorOriginationRequest).build());
    }

    /**
     * <p>
     * Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param putVoiceConnectorProxyRequest
     * @return A Java Future containing the result of the PutVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorProxy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorProxy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorProxyResponse> putVoiceConnectorProxy(
            PutVoiceConnectorProxyRequest putVoiceConnectorProxyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutVoiceConnectorProxyRequest.Builder} avoiding the
     * need to create one manually via {@link PutVoiceConnectorProxyRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorProxyRequest
     *        A {@link Consumer} that will call methods on {@link PutVoiceConnectorProxyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorProxy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorProxy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorProxyResponse> putVoiceConnectorProxy(
            Consumer<PutVoiceConnectorProxyRequest.Builder> putVoiceConnectorProxyRequest) {
        return putVoiceConnectorProxy(PutVoiceConnectorProxyRequest.builder().applyMutation(putVoiceConnectorProxyRequest)
                .build());
    }

    /**
     * <p>
     * Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration
     * specifies whether media streaming is enabled for sending to Amazon Kinesis. It also sets the retention period, in
     * hours, for the Amazon Kinesis data.
     * </p>
     *
     * @param putVoiceConnectorStreamingConfigurationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorStreamingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorStreamingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorStreamingConfigurationResponse> putVoiceConnectorStreamingConfiguration(
            PutVoiceConnectorStreamingConfigurationRequest putVoiceConnectorStreamingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration
     * specifies whether media streaming is enabled for sending to Amazon Kinesis. It also sets the retention period, in
     * hours, for the Amazon Kinesis data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutVoiceConnectorStreamingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutVoiceConnectorStreamingConfigurationRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorStreamingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link PutVoiceConnectorStreamingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutVoiceConnectorStreamingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorStreamingConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorStreamingConfigurationResponse> putVoiceConnectorStreamingConfiguration(
            Consumer<PutVoiceConnectorStreamingConfigurationRequest.Builder> putVoiceConnectorStreamingConfigurationRequest) {
        return putVoiceConnectorStreamingConfiguration(PutVoiceConnectorStreamingConfigurationRequest.builder()
                .applyMutation(putVoiceConnectorStreamingConfigurationRequest).build());
    }

    /**
     * <p>
     * Adds termination settings for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param putVoiceConnectorTerminationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorTermination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorTerminationResponse> putVoiceConnectorTermination(
            PutVoiceConnectorTerminationRequest putVoiceConnectorTerminationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds termination settings for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutVoiceConnectorTerminationRequest.Builder}
     * avoiding the need to create one manually via {@link PutVoiceConnectorTerminationRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorTerminationRequest
     *        A {@link Consumer} that will call methods on {@link PutVoiceConnectorTerminationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorTermination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorTerminationResponse> putVoiceConnectorTermination(
            Consumer<PutVoiceConnectorTerminationRequest.Builder> putVoiceConnectorTerminationRequest) {
        return putVoiceConnectorTermination(PutVoiceConnectorTerminationRequest.builder()
                .applyMutation(putVoiceConnectorTerminationRequest).build());
    }

    /**
     * <p>
     * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param putVoiceConnectorTerminationCredentialsRequest
     * @return A Java Future containing the result of the PutVoiceConnectorTerminationCredentials operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorTerminationCredentials
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorTerminationCredentialsResponse> putVoiceConnectorTerminationCredentials(
            PutVoiceConnectorTerminationCredentialsRequest putVoiceConnectorTerminationCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutVoiceConnectorTerminationCredentialsRequest.Builder} avoiding the need to create one manually via
     * {@link PutVoiceConnectorTerminationCredentialsRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorTerminationCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link PutVoiceConnectorTerminationCredentialsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutVoiceConnectorTerminationCredentials operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.PutVoiceConnectorTerminationCredentials
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorTerminationCredentialsResponse> putVoiceConnectorTerminationCredentials(
            Consumer<PutVoiceConnectorTerminationCredentialsRequest.Builder> putVoiceConnectorTerminationCredentialsRequest) {
        return putVoiceConnectorTerminationCredentials(PutVoiceConnectorTerminationCredentialsRequest.builder()
                .applyMutation(putVoiceConnectorTerminationCredentialsRequest).build());
    }

    /**
     * <p>
     * Redacts the specified message from the specified Amazon Chime conversation.
     * </p>
     *
     * @param redactConversationMessageRequest
     * @return A Java Future containing the result of the RedactConversationMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.RedactConversationMessage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactConversationMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RedactConversationMessageResponse> redactConversationMessage(
            RedactConversationMessageRequest redactConversationMessageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Redacts the specified message from the specified Amazon Chime conversation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RedactConversationMessageRequest.Builder} avoiding
     * the need to create one manually via {@link RedactConversationMessageRequest#builder()}
     * </p>
     *
     * @param redactConversationMessageRequest
     *        A {@link Consumer} that will call methods on {@link RedactConversationMessageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RedactConversationMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.RedactConversationMessage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactConversationMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RedactConversationMessageResponse> redactConversationMessage(
            Consumer<RedactConversationMessageRequest.Builder> redactConversationMessageRequest) {
        return redactConversationMessage(RedactConversationMessageRequest.builder()
                .applyMutation(redactConversationMessageRequest).build());
    }

    /**
     * <p>
     * Redacts the specified message from the specified Amazon Chime chat room.
     * </p>
     *
     * @param redactRoomMessageRequest
     * @return A Java Future containing the result of the RedactRoomMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.RedactRoomMessage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactRoomMessage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RedactRoomMessageResponse> redactRoomMessage(RedactRoomMessageRequest redactRoomMessageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Redacts the specified message from the specified Amazon Chime chat room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RedactRoomMessageRequest.Builder} avoiding the need
     * to create one manually via {@link RedactRoomMessageRequest#builder()}
     * </p>
     *
     * @param redactRoomMessageRequest
     *        A {@link Consumer} that will call methods on {@link RedactRoomMessageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RedactRoomMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.RedactRoomMessage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactRoomMessage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RedactRoomMessageResponse> redactRoomMessage(
            Consumer<RedactRoomMessageRequest.Builder> redactRoomMessageRequest) {
        return redactRoomMessage(RedactRoomMessageRequest.builder().applyMutation(redactRoomMessageRequest).build());
    }

    /**
     * <p>
     * Regenerates the security token for a bot.
     * </p>
     *
     * @param regenerateSecurityTokenRequest
     * @return A Java Future containing the result of the RegenerateSecurityToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.RegenerateSecurityToken
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RegenerateSecurityToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegenerateSecurityTokenResponse> regenerateSecurityToken(
            RegenerateSecurityTokenRequest regenerateSecurityTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Regenerates the security token for a bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegenerateSecurityTokenRequest.Builder} avoiding
     * the need to create one manually via {@link RegenerateSecurityTokenRequest#builder()}
     * </p>
     *
     * @param regenerateSecurityTokenRequest
     *        A {@link Consumer} that will call methods on {@link RegenerateSecurityTokenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegenerateSecurityToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.RegenerateSecurityToken
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RegenerateSecurityToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegenerateSecurityTokenResponse> regenerateSecurityToken(
            Consumer<RegenerateSecurityTokenRequest.Builder> regenerateSecurityTokenRequest) {
        return regenerateSecurityToken(RegenerateSecurityTokenRequest.builder().applyMutation(regenerateSecurityTokenRequest)
                .build());
    }

    /**
     * <p>
     * Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the <a>User</a> object
     * with the updated personal meeting PIN.
     * </p>
     *
     * @param resetPersonalPinRequest
     * @return A Java Future containing the result of the ResetPersonalPIN operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ResetPersonalPIN
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ResetPersonalPIN" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResetPersonalPinResponse> resetPersonalPIN(ResetPersonalPinRequest resetPersonalPinRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the <a>User</a> object
     * with the updated personal meeting PIN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetPersonalPinRequest.Builder} avoiding the need
     * to create one manually via {@link ResetPersonalPinRequest#builder()}
     * </p>
     *
     * @param resetPersonalPinRequest
     *        A {@link Consumer} that will call methods on {@link ResetPersonalPINRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ResetPersonalPIN operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.ResetPersonalPIN
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ResetPersonalPIN" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResetPersonalPinResponse> resetPersonalPIN(
            Consumer<ResetPersonalPinRequest.Builder> resetPersonalPinRequest) {
        return resetPersonalPIN(ResetPersonalPinRequest.builder().applyMutation(resetPersonalPinRequest).build());
    }

    /**
     * <p>
     * Moves a phone number from the <b>Deletion queue</b> back into the phone number <b>Inventory</b>.
     * </p>
     *
     * @param restorePhoneNumberRequest
     * @return A Java Future containing the result of the RestorePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.RestorePhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RestorePhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RestorePhoneNumberResponse> restorePhoneNumber(RestorePhoneNumberRequest restorePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves a phone number from the <b>Deletion queue</b> back into the phone number <b>Inventory</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestorePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link RestorePhoneNumberRequest#builder()}
     * </p>
     *
     * @param restorePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link RestorePhoneNumberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestorePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.RestorePhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RestorePhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RestorePhoneNumberResponse> restorePhoneNumber(
            Consumer<RestorePhoneNumberRequest.Builder> restorePhoneNumberRequest) {
        return restorePhoneNumber(RestorePhoneNumberRequest.builder().applyMutation(restorePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Searches phone numbers that can be ordered.
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     * @return A Java Future containing the result of the SearchAvailablePhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.SearchAvailablePhoneNumbers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbers(
            SearchAvailablePhoneNumbersRequest searchAvailablePhoneNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches phone numbers that can be ordered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAvailablePhoneNumbersRequest.Builder}
     * avoiding the need to create one manually via {@link SearchAvailablePhoneNumbersRequest#builder()}
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link SearchAvailablePhoneNumbersRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the SearchAvailablePhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.SearchAvailablePhoneNumbers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbers(
            Consumer<SearchAvailablePhoneNumbersRequest.Builder> searchAvailablePhoneNumbersRequest) {
        return searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest.builder()
                .applyMutation(searchAvailablePhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon Chime SDK attendee.
     * </p>
     *
     * @param tagAttendeeRequest
     * @return A Java Future containing the result of the TagAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.TagAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagAttendeeResponse> tagAttendee(TagAttendeeRequest tagAttendeeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon Chime SDK attendee.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagAttendeeRequest.Builder} avoiding the need to
     * create one manually via {@link TagAttendeeRequest#builder()}
     * </p>
     *
     * @param tagAttendeeRequest
     *        A {@link Consumer} that will call methods on {@link TagAttendeeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.TagAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagAttendeeResponse> tagAttendee(Consumer<TagAttendeeRequest.Builder> tagAttendeeRequest) {
        return tagAttendee(TagAttendeeRequest.builder().applyMutation(tagAttendeeRequest).build());
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon Chime SDK meeting.
     * </p>
     *
     * @param tagMeetingRequest
     * @return A Java Future containing the result of the TagMeeting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.TagMeeting
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagMeeting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagMeetingResponse> tagMeeting(TagMeetingRequest tagMeetingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon Chime SDK meeting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagMeetingRequest.Builder} avoiding the need to
     * create one manually via {@link TagMeetingRequest#builder()}
     * </p>
     *
     * @param tagMeetingRequest
     *        A {@link Consumer} that will call methods on {@link TagMeetingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagMeeting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.TagMeeting
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagMeeting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagMeetingResponse> tagMeeting(Consumer<TagMeetingRequest.Builder> tagMeetingRequest) {
        return tagMeeting(TagMeetingRequest.builder().applyMutation(tagMeetingRequest).build());
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon Chime SDK meeting resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon Chime SDK meeting resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untags the specified tags from the specified Amazon Chime SDK attendee.
     * </p>
     *
     * @param untagAttendeeRequest
     * @return A Java Future containing the result of the UntagAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UntagAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagAttendeeResponse> untagAttendee(UntagAttendeeRequest untagAttendeeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags the specified tags from the specified Amazon Chime SDK attendee.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagAttendeeRequest.Builder} avoiding the need to
     * create one manually via {@link UntagAttendeeRequest#builder()}
     * </p>
     *
     * @param untagAttendeeRequest
     *        A {@link Consumer} that will call methods on {@link UntagAttendeeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagAttendee operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UntagAttendee
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagAttendee" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagAttendeeResponse> untagAttendee(Consumer<UntagAttendeeRequest.Builder> untagAttendeeRequest) {
        return untagAttendee(UntagAttendeeRequest.builder().applyMutation(untagAttendeeRequest).build());
    }

    /**
     * <p>
     * Untags the specified tags from the specified Amazon Chime SDK meeting.
     * </p>
     *
     * @param untagMeetingRequest
     * @return A Java Future containing the result of the UntagMeeting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UntagMeeting
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagMeeting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagMeetingResponse> untagMeeting(UntagMeetingRequest untagMeetingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags the specified tags from the specified Amazon Chime SDK meeting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagMeetingRequest.Builder} avoiding the need to
     * create one manually via {@link UntagMeetingRequest#builder()}
     * </p>
     *
     * @param untagMeetingRequest
     *        A {@link Consumer} that will call methods on {@link UntagMeetingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagMeeting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UntagMeeting
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagMeeting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagMeetingResponse> untagMeeting(Consumer<UntagMeetingRequest.Builder> untagMeetingRequest) {
        return untagMeeting(UntagMeetingRequest.builder().applyMutation(untagMeetingRequest).build());
    }

    /**
     * <p>
     * Untags the specified tags from the specified Amazon Chime SDK meeting resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags the specified tags from the specified Amazon Chime SDK meeting resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates account details for the specified Amazon Chime account. Currently, only account name updates are
     * supported for this action.
     * </p>
     *
     * @param updateAccountRequest
     * @return A Java Future containing the result of the UpdateAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAccountResponse> updateAccount(UpdateAccountRequest updateAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates account details for the specified Amazon Chime account. Currently, only account name updates are
     * supported for this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAccountRequest#builder()}
     * </p>
     *
     * @param updateAccountRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAccountResponse> updateAccount(Consumer<UpdateAccountRequest.Builder> updateAccountRequest) {
        return updateAccount(UpdateAccountRequest.builder().applyMutation(updateAccountRequest).build());
    }

    /**
     * <p>
     * Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared
     * screens, or for the dial-out option. For more information about these settings, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime
     * Administration Guide</i>.
     * </p>
     *
     * @param updateAccountSettingsRequest
     * @return A Java Future containing the result of the UpdateAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAccountSettingsResponse> updateAccountSettings(
            UpdateAccountSettingsRequest updateAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared
     * screens, or for the dial-out option. For more information about these settings, see <a
     * href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime
     * Administration Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccountSettingsRequest#builder()}
     * </p>
     *
     * @param updateAccountSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccountSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAccountSettingsResponse> updateAccountSettings(
            Consumer<UpdateAccountSettingsRequest.Builder> updateAccountSettingsRequest) {
        return updateAccountSettings(UpdateAccountSettingsRequest.builder().applyMutation(updateAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime
     * Enterprise account.
     * </p>
     *
     * @param updateBotRequest
     * @return A Java Future containing the result of the UpdateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBotResponse> updateBot(UpdateBotRequest updateBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime
     * Enterprise account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBotRequest#builder()}
     * </p>
     *
     * @param updateBotRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBotResponse> updateBot(Consumer<UpdateBotRequest.Builder> updateBotRequest) {
        return updateBot(UpdateBotRequest.builder().applyMutation(updateBotRequest).build());
    }

    /**
     * <p>
     * Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon
     * Chime Voice Connector settings.
     * </p>
     *
     * @param updateGlobalSettingsRequest
     * @return A Java Future containing the result of the UpdateGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateGlobalSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateGlobalSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(
            UpdateGlobalSettingsRequest updateGlobalSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon
     * Chime Voice Connector settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlobalSettingsRequest#builder()}
     * </p>
     *
     * @param updateGlobalSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGlobalSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateGlobalSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateGlobalSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(
            Consumer<UpdateGlobalSettingsRequest.Builder> updateGlobalSettingsRequest) {
        return updateGlobalSettings(UpdateGlobalSettingsRequest.builder().applyMutation(updateGlobalSettingsRequest).build());
    }

    /**
     * <p>
     * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can
     * update one phone number detail at a time. For example, you can update either the product type or the calling name
     * in one action.
     * </p>
     * <p>
     * For toll-free numbers, you must use the Amazon Chime Voice Connector product type.
     * </p>
     * <p>
     * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names
     * must be complete before you can request another update.
     * </p>
     *
     * @param updatePhoneNumberRequest
     * @return A Java Future containing the result of the UpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdatePhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePhoneNumberResponse> updatePhoneNumber(UpdatePhoneNumberRequest updatePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can
     * update one phone number detail at a time. For example, you can update either the product type or the calling name
     * in one action.
     * </p>
     * <p>
     * For toll-free numbers, you must use the Amazon Chime Voice Connector product type.
     * </p>
     * <p>
     * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names
     * must be complete before you can request another update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePhoneNumberRequest#builder()}
     * </p>
     *
     * @param updatePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePhoneNumberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdatePhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePhoneNumberResponse> updatePhoneNumber(
            Consumer<UpdatePhoneNumberRequest.Builder> updatePhoneNumberRequest) {
        return updatePhoneNumber(UpdatePhoneNumberRequest.builder().applyMutation(updatePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name.
     * You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72
     * hours to update.
     * </p>
     *
     * @param updatePhoneNumberSettingsRequest
     * @return A Java Future containing the result of the UpdatePhoneNumberSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdatePhoneNumberSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumberSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePhoneNumberSettingsResponse> updatePhoneNumberSettings(
            UpdatePhoneNumberSettingsRequest updatePhoneNumberSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name.
     * You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72
     * hours to update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePhoneNumberSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdatePhoneNumberSettingsRequest#builder()}
     * </p>
     *
     * @param updatePhoneNumberSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePhoneNumberSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePhoneNumberSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdatePhoneNumberSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumberSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePhoneNumberSettingsResponse> updatePhoneNumberSettings(
            Consumer<UpdatePhoneNumberSettingsRequest.Builder> updatePhoneNumberSettingsRequest) {
        return updatePhoneNumberSettings(UpdatePhoneNumberSettingsRequest.builder()
                .applyMutation(updatePhoneNumberSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the specified proxy session details, such as voice or SMS capabilities.
     * </p>
     *
     * @param updateProxySessionRequest
     * @return A Java Future containing the result of the UpdateProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateProxySession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateProxySession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProxySessionResponse> updateProxySession(UpdateProxySessionRequest updateProxySessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified proxy session details, such as voice or SMS capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProxySessionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateProxySessionRequest#builder()}
     * </p>
     *
     * @param updateProxySessionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProxySessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateProxySession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateProxySession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProxySessionResponse> updateProxySession(
            Consumer<UpdateProxySessionRequest.Builder> updateProxySessionRequest) {
        return updateProxySession(UpdateProxySessionRequest.builder().applyMutation(updateProxySessionRequest).build());
    }

    /**
     * <p>
     * Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     * </p>
     *
     * @param updateRoomRequest
     * @return A Java Future containing the result of the UpdateRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRoomResponse> updateRoom(UpdateRoomRequest updateRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoomRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRoomRequest#builder()}
     * </p>
     *
     * @param updateRoomRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoomRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRoomResponse> updateRoom(Consumer<UpdateRoomRequest.Builder> updateRoomRequest) {
        return updateRoom(UpdateRoomRequest.builder().applyMutation(updateRoomRequest).build());
    }

    /**
     * <p>
     * Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The
     * member role designates whether the member is a chat room administrator or a general chat room member. The member
     * role can be updated only for user IDs.
     * </p>
     *
     * @param updateRoomMembershipRequest
     * @return A Java Future containing the result of the UpdateRoomMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateRoomMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoomMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRoomMembershipResponse> updateRoomMembership(
            UpdateRoomMembershipRequest updateRoomMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The
     * member role designates whether the member is a chat room administrator or a general chat room member. The member
     * role can be updated only for user IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoomMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRoomMembershipRequest#builder()}
     * </p>
     *
     * @param updateRoomMembershipRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoomMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRoomMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateRoomMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoomMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRoomMembershipResponse> updateRoomMembership(
            Consumer<UpdateRoomMembershipRequest.Builder> updateRoomMembershipRequest) {
        return updateRoomMembership(UpdateRoomMembershipRequest.builder().applyMutation(updateRoomMembershipRequest).build());
    }

    /**
     * <p>
     * Updates user details for a specified user ID. Currently, only <code>LicenseType</code> updates are supported for
     * this action.
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates user details for a specified user ID. Currently, only <code>LicenseType</code> updates are supported for
     * this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    /**
     * <p>
     * Updates the settings for the specified user, such as phone number settings.
     * </p>
     *
     * @param updateUserSettingsRequest
     * @return A Java Future containing the result of the UpdateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateUserSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUserSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserSettingsResponse> updateUserSettings(UpdateUserSettingsRequest updateUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for the specified user, such as phone number settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserSettingsRequest#builder()}
     * </p>
     *
     * @param updateUserSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateUserSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUserSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserSettingsResponse> updateUserSettings(
            Consumer<UpdateUserSettingsRequest.Builder> updateUserSettingsRequest) {
        return updateUserSettings(UpdateUserSettingsRequest.builder().applyMutation(updateUserSettingsRequest).build());
    }

    /**
     * <p>
     * Updates details for the specified Amazon Chime Voice Connector.
     * </p>
     *
     * @param updateVoiceConnectorRequest
     * @return A Java Future containing the result of the UpdateVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateVoiceConnectorResponse> updateVoiceConnector(
            UpdateVoiceConnectorRequest updateVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates details for the specified Amazon Chime Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVoiceConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param updateVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVoiceConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateVoiceConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateVoiceConnectorResponse> updateVoiceConnector(
            Consumer<UpdateVoiceConnectorRequest.Builder> updateVoiceConnectorRequest) {
        return updateVoiceConnector(UpdateVoiceConnectorRequest.builder().applyMutation(updateVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Updates details for the specified Amazon Chime Voice Connector group, such as the name and Amazon Chime Voice
     * Connector priority ranking.
     * </p>
     *
     * @param updateVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the UpdateVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateVoiceConnectorGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceConnectorGroupResponse> updateVoiceConnectorGroup(
            UpdateVoiceConnectorGroupRequest updateVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates details for the specified Amazon Chime Voice Connector group, such as the name and Amazon Chime Voice
     * Connector priority ranking.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVoiceConnectorGroupRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param updateVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVoiceConnectorGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request. For example, when a
     *         user tries to create an account from an unsupported Region.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeAsyncClient.UpdateVoiceConnectorGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceConnectorGroupResponse> updateVoiceConnectorGroup(
            Consumer<UpdateVoiceConnectorGroupRequest.Builder> updateVoiceConnectorGroupRequest) {
        return updateVoiceConnectorGroup(UpdateVoiceConnectorGroupRequest.builder()
                .applyMutation(updateVoiceConnectorGroupRequest).build());
    }
}
