/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.UserEmailListCopier;
import software.amazon.awssdk.services.chime.model.UserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InviteUsersRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, InviteUsersRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InviteUsersRequest.getter(InviteUsersRequest::accountId)).setter(InviteUsersRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<List<String>> USER_EMAIL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InviteUsersRequest.getter(InviteUsersRequest::userEmailList)).setter(InviteUsersRequest.setter(Builder::userEmailList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserEmailList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InviteUsersRequest.getter(InviteUsersRequest::userTypeAsString)).setter(InviteUsersRequest.setter(Builder::userType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, USER_EMAIL_LIST_FIELD, USER_TYPE_FIELD));
    private final String accountId;
    private final List<String> userEmailList;
    private final String userType;

    private InviteUsersRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.userEmailList = builder.userEmailList;
        this.userType = builder.userType;
    }

    public String accountId() {
        return this.accountId;
    }

    public boolean hasUserEmailList() {
        return this.userEmailList != null && !(this.userEmailList instanceof SdkAutoConstructList);
    }

    public List<String> userEmailList() {
        return this.userEmailList;
    }

    public UserType userType() {
        return UserType.fromValue(this.userType);
    }

    public String userTypeAsString() {
        return this.userType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userEmailList());
        hashCode = 31 * hashCode + Objects.hashCode(this.userTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InviteUsersRequest)) {
            return false;
        }
        InviteUsersRequest other = (InviteUsersRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.userEmailList(), other.userEmailList()) && Objects.equals(this.userTypeAsString(), other.userTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"InviteUsersRequest").add("AccountId", (Object)this.accountId()).add("UserEmailList", (Object)(this.userEmailList() == null ? null : "*** Sensitive Data Redacted ***")).add("UserType", (Object)this.userTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "UserEmailList": {
                return Optional.ofNullable(clazz.cast(this.userEmailList()));
            }
            case "UserType": {
                return Optional.ofNullable(clazz.cast(this.userTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InviteUsersRequest, T> g) {
        return obj -> g.apply((InviteUsersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private List<String> userEmailList = DefaultSdkAutoConstructList.getInstance();
        private String userType;

        private BuilderImpl() {
        }

        private BuilderImpl(InviteUsersRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.userEmailList(model.userEmailList);
            this.userType(model.userType);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Collection<String> getUserEmailList() {
            return this.userEmailList;
        }

        @Override
        public final Builder userEmailList(Collection<String> userEmailList) {
            this.userEmailList = UserEmailListCopier.copy(userEmailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userEmailList(String ... userEmailList) {
            this.userEmailList(Arrays.asList(userEmailList));
            return this;
        }

        public final void setUserEmailList(Collection<String> userEmailList) {
            this.userEmailList = UserEmailListCopier.copy(userEmailList);
        }

        public final String getUserTypeAsString() {
            return this.userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(UserType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InviteUsersRequest build() {
            return new InviteUsersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InviteUsersRequest> {
        public Builder accountId(String var1);

        public Builder userEmailList(Collection<String> var1);

        public Builder userEmailList(String ... var1);

        public Builder userType(String var1);

        public Builder userType(UserType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

