/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The streaming configuration associated with an Amazon Chime Voice Connector. Specifies whether media streaming is
 * enabled for sending to Amazon Kinesis, and shows the retention period for the Amazon Kinesis data, in hours.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingConfiguration.Builder, StreamingConfiguration> {
    private static final SdkField<Integer> DATA_RETENTION_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StreamingConfiguration::dataRetentionInHours)).setter(setter(Builder::dataRetentionInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionInHours").build())
            .build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(StreamingConfiguration::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_RETENTION_IN_HOURS_FIELD,
            DISABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer dataRetentionInHours;

    private final Boolean disabled;

    private StreamingConfiguration(BuilderImpl builder) {
        this.dataRetentionInHours = builder.dataRetentionInHours;
        this.disabled = builder.disabled;
    }

    /**
     * <p>
     * The retention period, in hours, for the Amazon Kinesis data.
     * </p>
     * 
     * @return The retention period, in hours, for the Amazon Kinesis data.
     */
    public Integer dataRetentionInHours() {
        return dataRetentionInHours;
    }

    /**
     * <p>
     * When true, media streaming to Amazon Kinesis is turned off.
     * </p>
     * 
     * @return When true, media streaming to Amazon Kinesis is turned off.
     */
    public Boolean disabled() {
        return disabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataRetentionInHours());
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingConfiguration)) {
            return false;
        }
        StreamingConfiguration other = (StreamingConfiguration) obj;
        return Objects.equals(dataRetentionInHours(), other.dataRetentionInHours())
                && Objects.equals(disabled(), other.disabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StreamingConfiguration").add("DataRetentionInHours", dataRetentionInHours())
                .add("Disabled", disabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataRetentionInHours":
            return Optional.ofNullable(clazz.cast(dataRetentionInHours()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingConfiguration, T> g) {
        return obj -> g.apply((StreamingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingConfiguration> {
        /**
         * <p>
         * The retention period, in hours, for the Amazon Kinesis data.
         * </p>
         * 
         * @param dataRetentionInHours
         *        The retention period, in hours, for the Amazon Kinesis data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRetentionInHours(Integer dataRetentionInHours);

        /**
         * <p>
         * When true, media streaming to Amazon Kinesis is turned off.
         * </p>
         * 
         * @param disabled
         *        When true, media streaming to Amazon Kinesis is turned off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);
    }

    static final class BuilderImpl implements Builder {
        private Integer dataRetentionInHours;

        private Boolean disabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingConfiguration model) {
            dataRetentionInHours(model.dataRetentionInHours);
            disabled(model.disabled);
        }

        public final Integer getDataRetentionInHours() {
            return dataRetentionInHours;
        }

        @Override
        public final Builder dataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
            return this;
        }

        public final void setDataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public StreamingConfiguration build() {
            return new StreamingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
