/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAvailablePhoneNumbersResponse extends ChimeResponse implements
        ToCopyableBuilder<SearchAvailablePhoneNumbersResponse.Builder, SearchAvailablePhoneNumbersResponse> {
    private static final SdkField<List<String>> E164_PHONE_NUMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SearchAvailablePhoneNumbersResponse::e164PhoneNumbers))
            .setter(setter(Builder::e164PhoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E164_PHONE_NUMBERS_FIELD));

    private final List<String> e164PhoneNumbers;

    private SearchAvailablePhoneNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.e164PhoneNumbers = builder.e164PhoneNumbers;
    }

    /**
     * Returns true if the E164PhoneNumbers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasE164PhoneNumbers() {
        return e164PhoneNumbers != null && !(e164PhoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of phone numbers, in E.164 format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasE164PhoneNumbers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of phone numbers, in E.164 format.
     */
    public List<String> e164PhoneNumbers() {
        return e164PhoneNumbers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(e164PhoneNumbers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAvailablePhoneNumbersResponse)) {
            return false;
        }
        SearchAvailablePhoneNumbersResponse other = (SearchAvailablePhoneNumbersResponse) obj;
        return Objects.equals(e164PhoneNumbers(), other.e164PhoneNumbers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchAvailablePhoneNumbersResponse")
                .add("E164PhoneNumbers", e164PhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "E164PhoneNumbers":
            return Optional.ofNullable(clazz.cast(e164PhoneNumbers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAvailablePhoneNumbersResponse, T> g) {
        return obj -> g.apply((SearchAvailablePhoneNumbersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchAvailablePhoneNumbersResponse> {
        /**
         * <p>
         * List of phone numbers, in E.164 format.
         * </p>
         * 
         * @param e164PhoneNumbers
         *        List of phone numbers, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers);

        /**
         * <p>
         * List of phone numbers, in E.164 format.
         * </p>
         * 
         * @param e164PhoneNumbers
         *        List of phone numbers, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumbers(String... e164PhoneNumbers);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<String> e164PhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAvailablePhoneNumbersResponse model) {
            super(model);
            e164PhoneNumbers(model.e164PhoneNumbers);
        }

        public final Collection<String> getE164PhoneNumbers() {
            return e164PhoneNumbers;
        }

        @Override
        public final Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder e164PhoneNumbers(String... e164PhoneNumbers) {
            e164PhoneNumbers(Arrays.asList(e164PhoneNumbers));
            return this;
        }

        public final void setE164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
        }

        @Override
        public SearchAvailablePhoneNumbersResponse build() {
            return new SearchAvailablePhoneNumbersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
