/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAvailablePhoneNumbersRequest extends ChimeRequest implements
        ToCopyableBuilder<SearchAvailablePhoneNumbersRequest.Builder, SearchAvailablePhoneNumbersRequest> {
    private static final SdkField<String> AREA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchAvailablePhoneNumbersRequest::areaCode)).setter(setter(Builder::areaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("area-code").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchAvailablePhoneNumbersRequest::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("city").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchAvailablePhoneNumbersRequest::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("country").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchAvailablePhoneNumbersRequest::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()).build();

    private static final SdkField<String> TOLL_FREE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchAvailablePhoneNumbersRequest::tollFreePrefix)).setter(setter(Builder::tollFreePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("toll-free-prefix").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SearchAvailablePhoneNumbersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchAvailablePhoneNumbersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREA_CODE_FIELD, CITY_FIELD,
            COUNTRY_FIELD, STATE_FIELD, TOLL_FREE_PREFIX_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String areaCode;

    private final String city;

    private final String country;

    private final String state;

    private final String tollFreePrefix;

    private final Integer maxResults;

    private final String nextToken;

    private SearchAvailablePhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.areaCode = builder.areaCode;
        this.city = builder.city;
        this.country = builder.country;
        this.state = builder.state;
        this.tollFreePrefix = builder.tollFreePrefix;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The area code used to filter results.
     * </p>
     * 
     * @return The area code used to filter results.
     */
    public String areaCode() {
        return areaCode;
    }

    /**
     * <p>
     * The city used to filter results.
     * </p>
     * 
     * @return The city used to filter results.
     */
    public String city() {
        return city;
    }

    /**
     * <p>
     * The country used to filter results.
     * </p>
     * 
     * @return The country used to filter results.
     */
    public String country() {
        return country;
    }

    /**
     * <p>
     * The state used to filter results.
     * </p>
     * 
     * @return The state used to filter results.
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The toll-free prefix that you use to filter results.
     * </p>
     * 
     * @return The toll-free prefix that you use to filter results.
     */
    public String tollFreePrefix() {
        return tollFreePrefix;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(areaCode());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(tollFreePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAvailablePhoneNumbersRequest)) {
            return false;
        }
        SearchAvailablePhoneNumbersRequest other = (SearchAvailablePhoneNumbersRequest) obj;
        return Objects.equals(areaCode(), other.areaCode()) && Objects.equals(city(), other.city())
                && Objects.equals(country(), other.country()) && Objects.equals(state(), other.state())
                && Objects.equals(tollFreePrefix(), other.tollFreePrefix()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchAvailablePhoneNumbersRequest").add("AreaCode", areaCode()).add("City", city())
                .add("Country", country()).add("State", state()).add("TollFreePrefix", tollFreePrefix())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AreaCode":
            return Optional.ofNullable(clazz.cast(areaCode()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "TollFreePrefix":
            return Optional.ofNullable(clazz.cast(tollFreePrefix()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAvailablePhoneNumbersRequest, T> g) {
        return obj -> g.apply((SearchAvailablePhoneNumbersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchAvailablePhoneNumbersRequest> {
        /**
         * <p>
         * The area code used to filter results.
         * </p>
         * 
         * @param areaCode
         *        The area code used to filter results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areaCode(String areaCode);

        /**
         * <p>
         * The city used to filter results.
         * </p>
         * 
         * @param city
         *        The city used to filter results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The country used to filter results.
         * </p>
         * 
         * @param country
         *        The country used to filter results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The state used to filter results.
         * </p>
         * 
         * @param state
         *        The state used to filter results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The toll-free prefix that you use to filter results.
         * </p>
         * 
         * @param tollFreePrefix
         *        The toll-free prefix that you use to filter results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tollFreePrefix(String tollFreePrefix);

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String areaCode;

        private String city;

        private String country;

        private String state;

        private String tollFreePrefix;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAvailablePhoneNumbersRequest model) {
            super(model);
            areaCode(model.areaCode);
            city(model.city);
            country(model.country);
            state(model.state);
            tollFreePrefix(model.tollFreePrefix);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAreaCode() {
            return areaCode;
        }

        @Override
        public final Builder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public final void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        public final String getCity() {
            return city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getCountry() {
            return country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getTollFreePrefix() {
            return tollFreePrefix;
        }

        @Override
        public final Builder tollFreePrefix(String tollFreePrefix) {
            this.tollFreePrefix = tollFreePrefix;
            return this;
        }

        public final void setTollFreePrefix(String tollFreePrefix) {
            this.tollFreePrefix = tollFreePrefix;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchAvailablePhoneNumbersRequest build() {
            return new SearchAvailablePhoneNumbersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
