/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestorePhoneNumberResponse extends ChimeResponse implements
        ToCopyableBuilder<RestorePhoneNumberResponse.Builder, RestorePhoneNumberResponse> {
    private static final SdkField<PhoneNumber> PHONE_NUMBER_FIELD = SdkField.<PhoneNumber> builder(MarshallingType.SDK_POJO)
            .getter(getter(RestorePhoneNumberResponse::phoneNumber)).setter(setter(Builder::phoneNumber))
            .constructor(PhoneNumber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD));

    private final PhoneNumber phoneNumber;

    private RestorePhoneNumberResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumber = builder.phoneNumber;
    }

    /**
     * <p>
     * The phone number details.
     * </p>
     * 
     * @return The phone number details.
     */
    public PhoneNumber phoneNumber() {
        return phoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestorePhoneNumberResponse)) {
            return false;
        }
        RestorePhoneNumberResponse other = (RestorePhoneNumberResponse) obj;
        return Objects.equals(phoneNumber(), other.phoneNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RestorePhoneNumberResponse").add("PhoneNumber", phoneNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestorePhoneNumberResponse, T> g) {
        return obj -> g.apply((RestorePhoneNumberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, RestorePhoneNumberResponse> {
        /**
         * <p>
         * The phone number details.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(PhoneNumber phoneNumber);

        /**
         * <p>
         * The phone number details.
         * </p>
         * This is a convenience that creates an instance of the {@link PhoneNumber.Builder} avoiding the need to create
         * one manually via {@link PhoneNumber#builder()}.
         *
         * When the {@link Consumer} completes, {@link PhoneNumber.Builder#build()} is called immediately and its result
         * is passed to {@link #phoneNumber(PhoneNumber)}.
         * 
         * @param phoneNumber
         *        a consumer that will call methods on {@link PhoneNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumber(PhoneNumber)
         */
        default Builder phoneNumber(Consumer<PhoneNumber.Builder> phoneNumber) {
            return phoneNumber(PhoneNumber.builder().applyMutation(phoneNumber).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private PhoneNumber phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(RestorePhoneNumberResponse model) {
            super(model);
            phoneNumber(model.phoneNumber);
        }

        public final PhoneNumber.Builder getPhoneNumber() {
            return phoneNumber != null ? phoneNumber.toBuilder() : null;
        }

        @Override
        public final Builder phoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(PhoneNumber.BuilderImpl phoneNumber) {
            this.phoneNumber = phoneNumber != null ? phoneNumber.build() : null;
        }

        @Override
        public RestorePhoneNumberResponse build() {
            return new RestorePhoneNumberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
