/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMeetingsResponse extends ChimeResponse implements
        ToCopyableBuilder<ListMeetingsResponse.Builder, ListMeetingsResponse> {
    private static final SdkField<List<Meeting>> MEETINGS_FIELD = SdkField
            .<List<Meeting>> builder(MarshallingType.LIST)
            .getter(getter(ListMeetingsResponse::meetings))
            .setter(setter(Builder::meetings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Meetings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Meeting> builder(MarshallingType.SDK_POJO)
                                            .constructor(Meeting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMeetingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETINGS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Meeting> meetings;

    private final String nextToken;

    private ListMeetingsResponse(BuilderImpl builder) {
        super(builder);
        this.meetings = builder.meetings;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Meetings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMeetings() {
        return meetings != null && !(meetings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Chime SDK meeting information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMeetings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Chime SDK meeting information.
     */
    public List<Meeting> meetings() {
        return meetings;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meetings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMeetingsResponse)) {
            return false;
        }
        ListMeetingsResponse other = (ListMeetingsResponse) obj;
        return Objects.equals(meetings(), other.meetings()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMeetingsResponse").add("Meetings", meetings()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Meetings":
            return Optional.ofNullable(clazz.cast(meetings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMeetingsResponse, T> g) {
        return obj -> g.apply((ListMeetingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMeetingsResponse> {
        /**
         * <p>
         * The Amazon Chime SDK meeting information.
         * </p>
         * 
         * @param meetings
         *        The Amazon Chime SDK meeting information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetings(Collection<Meeting> meetings);

        /**
         * <p>
         * The Amazon Chime SDK meeting information.
         * </p>
         * 
         * @param meetings
         *        The Amazon Chime SDK meeting information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetings(Meeting... meetings);

        /**
         * <p>
         * The Amazon Chime SDK meeting information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Meeting>.Builder} avoiding the need to
         * create one manually via {@link List<Meeting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Meeting>.Builder#build()} is called immediately and its
         * result is passed to {@link #meetings(List<Meeting>)}.
         * 
         * @param meetings
         *        a consumer that will call methods on {@link List<Meeting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meetings(List<Meeting>)
         */
        Builder meetings(Consumer<Meeting.Builder>... meetings);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<Meeting> meetings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMeetingsResponse model) {
            super(model);
            meetings(model.meetings);
            nextToken(model.nextToken);
        }

        public final Collection<Meeting.Builder> getMeetings() {
            return meetings != null ? meetings.stream().map(Meeting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder meetings(Collection<Meeting> meetings) {
            this.meetings = MeetingListCopier.copy(meetings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder meetings(Meeting... meetings) {
            meetings(Arrays.asList(meetings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder meetings(Consumer<Meeting.Builder>... meetings) {
            meetings(Stream.of(meetings).map(c -> Meeting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMeetings(Collection<Meeting.BuilderImpl> meetings) {
            this.meetings = MeetingListCopier.copyFromBuilder(meetings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMeetingsResponse build() {
            return new ListMeetingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
