/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVoiceConnectorTerminationResponse extends ChimeResponse implements
        ToCopyableBuilder<GetVoiceConnectorTerminationResponse.Builder, GetVoiceConnectorTerminationResponse> {
    private static final SdkField<Termination> TERMINATION_FIELD = SdkField.<Termination> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetVoiceConnectorTerminationResponse::termination)).setter(setter(Builder::termination))
            .constructor(Termination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Termination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINATION_FIELD));

    private final Termination termination;

    private GetVoiceConnectorTerminationResponse(BuilderImpl builder) {
        super(builder);
        this.termination = builder.termination;
    }

    /**
     * <p>
     * The termination setting details.
     * </p>
     * 
     * @return The termination setting details.
     */
    public Termination termination() {
        return termination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(termination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVoiceConnectorTerminationResponse)) {
            return false;
        }
        GetVoiceConnectorTerminationResponse other = (GetVoiceConnectorTerminationResponse) obj;
        return Objects.equals(termination(), other.termination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetVoiceConnectorTerminationResponse").add("Termination", termination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Termination":
            return Optional.ofNullable(clazz.cast(termination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVoiceConnectorTerminationResponse, T> g) {
        return obj -> g.apply((GetVoiceConnectorTerminationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVoiceConnectorTerminationResponse> {
        /**
         * <p>
         * The termination setting details.
         * </p>
         * 
         * @param termination
         *        The termination setting details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termination(Termination termination);

        /**
         * <p>
         * The termination setting details.
         * </p>
         * This is a convenience that creates an instance of the {@link Termination.Builder} avoiding the need to create
         * one manually via {@link Termination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Termination.Builder#build()} is called immediately and its result
         * is passed to {@link #termination(Termination)}.
         * 
         * @param termination
         *        a consumer that will call methods on {@link Termination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #termination(Termination)
         */
        default Builder termination(Consumer<Termination.Builder> termination) {
            return termination(Termination.builder().applyMutation(termination).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private Termination termination;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVoiceConnectorTerminationResponse model) {
            super(model);
            termination(model.termination);
        }

        public final Termination.Builder getTermination() {
            return termination != null ? termination.toBuilder() : null;
        }

        @Override
        public final Builder termination(Termination termination) {
            this.termination = termination;
            return this;
        }

        public final void setTermination(Termination.BuilderImpl termination) {
            this.termination = termination != null ? termination.build() : null;
        }

        @Override
        public GetVoiceConnectorTerminationResponse build() {
            return new GetVoiceConnectorTerminationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
