/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAttendeeRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateAttendeeRequest.Builder, CreateAttendeeRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAttendeeRequest::meetingId)).setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meetingId").build()).build();

    private static final SdkField<String> EXTERNAL_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAttendeeRequest::externalUserId)).setter(setter(Builder::externalUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalUserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD,
            EXTERNAL_USER_ID_FIELD));

    private final String meetingId;

    private final String externalUserId;

    private CreateAttendeeRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.externalUserId = builder.externalUserId;
    }

    /**
     * <p>
     * The Amazon Chime SDK meeting ID.
     * </p>
     * 
     * @return The Amazon Chime SDK meeting ID.
     */
    public String meetingId() {
        return meetingId;
    }

    /**
     * <p>
     * The Amazon Chime SDK external user ID. Links the attendee to an identity managed by a builder application.
     * </p>
     * 
     * @return The Amazon Chime SDK external user ID. Links the attendee to an identity managed by a builder
     *         application.
     */
    public String externalUserId() {
        return externalUserId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(externalUserId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAttendeeRequest)) {
            return false;
        }
        CreateAttendeeRequest other = (CreateAttendeeRequest) obj;
        return Objects.equals(meetingId(), other.meetingId()) && Objects.equals(externalUserId(), other.externalUserId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAttendeeRequest").add("MeetingId", meetingId())
                .add("ExternalUserId", externalUserId() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        case "ExternalUserId":
            return Optional.ofNullable(clazz.cast(externalUserId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAttendeeRequest, T> g) {
        return obj -> g.apply((CreateAttendeeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAttendeeRequest> {
        /**
         * <p>
         * The Amazon Chime SDK meeting ID.
         * </p>
         * 
         * @param meetingId
         *        The Amazon Chime SDK meeting ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);

        /**
         * <p>
         * The Amazon Chime SDK external user ID. Links the attendee to an identity managed by a builder application.
         * </p>
         * 
         * @param externalUserId
         *        The Amazon Chime SDK external user ID. Links the attendee to an identity managed by a builder
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalUserId(String externalUserId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String meetingId;

        private String externalUserId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAttendeeRequest model) {
            super(model);
            meetingId(model.meetingId);
            externalUserId(model.externalUserId);
        }

        public final String getMeetingId() {
            return meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        public final String getExternalUserId() {
            return externalUserId;
        }

        @Override
        public final Builder externalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
            return this;
        }

        public final void setExternalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAttendeeRequest build() {
            return new CreateAttendeeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
