/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotAsyncClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.ListCustomActionsRequest;
import software.amazon.awssdk.services.chatbot.model.ListCustomActionsResponse;

public class ListCustomActionsPublisher
implements SdkPublisher<ListCustomActionsResponse> {
    private final ChatbotAsyncClient client;
    private final ListCustomActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomActionsPublisher(ChatbotAsyncClient client, ListCustomActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomActionsPublisher(ChatbotAsyncClient client, ListCustomActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> customActions() {
        Function<ListCustomActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customActions() != null) {
                return response.customActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomActionsResponseFetcher
    implements AsyncPageFetcher<ListCustomActionsResponse> {
        private ListCustomActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomActionsResponse> nextPage(ListCustomActionsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomActionsPublisher.this.client.listCustomActions(ListCustomActionsPublisher.this.firstRequest);
            }
            return ListCustomActionsPublisher.this.client.listCustomActions((ListCustomActionsRequest)((Object)ListCustomActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

