/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse;

public class ListMicrosoftTeamsUserIdentitiesIterable
implements SdkIterable<ListMicrosoftTeamsUserIdentitiesResponse> {
    private final ChatbotClient client;
    private final ListMicrosoftTeamsUserIdentitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMicrosoftTeamsUserIdentitiesIterable(ChatbotClient client, ListMicrosoftTeamsUserIdentitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMicrosoftTeamsUserIdentitiesResponseFetcher();
    }

    public Iterator<ListMicrosoftTeamsUserIdentitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMicrosoftTeamsUserIdentitiesResponseFetcher
    implements SyncPageFetcher<ListMicrosoftTeamsUserIdentitiesResponse> {
        private ListMicrosoftTeamsUserIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListMicrosoftTeamsUserIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMicrosoftTeamsUserIdentitiesResponse nextPage(ListMicrosoftTeamsUserIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListMicrosoftTeamsUserIdentitiesIterable.this.client.listMicrosoftTeamsUserIdentities(ListMicrosoftTeamsUserIdentitiesIterable.this.firstRequest);
            }
            return ListMicrosoftTeamsUserIdentitiesIterable.this.client.listMicrosoftTeamsUserIdentities((ListMicrosoftTeamsUserIdentitiesRequest)((Object)ListMicrosoftTeamsUserIdentitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

