/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComplianceSummaryRequest extends ResourceGroupsTaggingApiRequest implements
        ToCopyableBuilder<GetComplianceSummaryRequest.Builder, GetComplianceSummaryRequest> {
    private static final SdkField<List<String>> TARGET_ID_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetIdFilters")
            .getter(getter(GetComplianceSummaryRequest::targetIdFilters))
            .setter(setter(Builder::targetIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGION_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RegionFilters")
            .getter(getter(GetComplianceSummaryRequest::regionFilters))
            .setter(setter(Builder::regionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPE_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypeFilters")
            .getter(getter(GetComplianceSummaryRequest::resourceTypeFilters))
            .setter(setter(Builder::resourceTypeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TAG_KEY_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagKeyFilters")
            .getter(getter(GetComplianceSummaryRequest::tagKeyFilters))
            .setter(setter(Builder::tagKeyFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeyFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> GROUP_BY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupBy")
            .getter(getter(GetComplianceSummaryRequest::groupByAsStrings))
            .setter(setter(Builder::groupByWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetComplianceSummaryRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaginationToken").getter(getter(GetComplianceSummaryRequest::paginationToken))
            .setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ID_FILTERS_FIELD,
            REGION_FILTERS_FIELD, RESOURCE_TYPE_FILTERS_FIELD, TAG_KEY_FILTERS_FIELD, GROUP_BY_FIELD, MAX_RESULTS_FIELD,
            PAGINATION_TOKEN_FIELD));

    private final List<String> targetIdFilters;

    private final List<String> regionFilters;

    private final List<String> resourceTypeFilters;

    private final List<String> tagKeyFilters;

    private final List<String> groupBy;

    private final Integer maxResults;

    private final String paginationToken;

    private GetComplianceSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.targetIdFilters = builder.targetIdFilters;
        this.regionFilters = builder.regionFilters;
        this.resourceTypeFilters = builder.resourceTypeFilters;
        this.tagKeyFilters = builder.tagKeyFilters;
        this.groupBy = builder.groupBy;
        this.maxResults = builder.maxResults;
        this.paginationToken = builder.paginationToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetIdFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetIdFilters() {
        return targetIdFilters != null && !(targetIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies target identifiers (usually, specific account IDs) to limit the output by. If you use this parameter,
     * the count of returned noncompliant resources includes only resources with the specified target IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetIdFilters} method.
     * </p>
     * 
     * @return Specifies target identifiers (usually, specific account IDs) to limit the output by. If you use this
     *         parameter, the count of returned noncompliant resources includes only resources with the specified target
     *         IDs.
     */
    public final List<String> targetIdFilters() {
        return targetIdFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegionFilters() {
        return regionFilters != null && !(regionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of Amazon Web Services Regions to limit the output to. If you use this parameter, the count of
     * returned noncompliant resources includes only resources in the specified Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionFilters} method.
     * </p>
     * 
     * @return Specifies a list of Amazon Web Services Regions to limit the output to. If you use this parameter, the
     *         count of returned noncompliant resources includes only resources in the specified Regions.
     */
    public final List<String> regionFilters() {
        return regionFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypeFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypeFilters() {
        return resourceTypeFilters != null && !(resourceTypeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies that you want the response to include information for only resources of the specified types. The format
     * of each resource type is <code>service[:resourceType]</code>. For example, specifying a resource type of
     * <code>ec2</code> returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of
     * <code>ec2:instance</code> returns only EC2 instances.
     * </p>
     * <p>
     * The string for each service name and resource type is the same as that embedded in a resource's Amazon Resource
     * Name (ARN). Consult the <i> <a href="https://docs.aws.amazon.com/general/latest/gr/">Amazon Web Services General
     * Reference</a> </i> for the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a list of service name strings, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     * >Amazon Web Services Service Namespaces</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For resource type strings, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax">Example ARNs</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and Amazon Web Services Service Namespaces</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify multiple resource types by using a comma separated array. The array can include up to 100 items.
     * Note that the length constraint requirement applies to each resource type filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypeFilters} method.
     * </p>
     * 
     * @return Specifies that you want the response to include information for only resources of the specified types.
     *         The format of each resource type is <code>service[:resourceType]</code>. For example, specifying a
     *         resource type of <code>ec2</code> returns all Amazon EC2 resources (which includes EC2 instances).
     *         Specifying a resource type of <code>ec2:instance</code> returns only EC2 instances.</p>
     *         <p>
     *         The string for each service name and resource type is the same as that embedded in a resource's Amazon
     *         Resource Name (ARN). Consult the <i> <a href="https://docs.aws.amazon.com/general/latest/gr/">Amazon Web
     *         Services General Reference</a> </i> for the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For a list of service name strings, see <a href=
     *         "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     *         >Amazon Web Services Service Namespaces</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For resource type strings, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax">Example
     *         ARNs</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and Amazon Web Services Service Namespaces</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can specify multiple resource types by using a comma separated array. The array can include up to 100
     *         items. Note that the length constraint requirement applies to each resource type filter.
     */
    public final List<String> resourceTypeFilters() {
        return resourceTypeFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagKeyFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagKeyFilters() {
        return tagKeyFilters != null && !(tagKeyFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies that you want the response to include information for only resources that have tags with the specified
     * tag keys. If you use this parameter, the count of returned noncompliant resources includes only resources that
     * have the specified tag keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagKeyFilters} method.
     * </p>
     * 
     * @return Specifies that you want the response to include information for only resources that have tags with the
     *         specified tag keys. If you use this parameter, the count of returned noncompliant resources includes only
     *         resources that have the specified tag keys.
     */
    public final List<String> tagKeyFilters() {
        return tagKeyFilters;
    }

    /**
     * <p>
     * Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the counts are
     * sorted by those attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the counts
     *         are sorted by those attributes.
     */
    public final List<GroupByAttribute> groupBy() {
        return GroupByCopier.copyStringToEnum(groupBy);
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupBy() {
        return groupBy != null && !(groupBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the counts are
     * sorted by those attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the counts
     *         are sorted by those attributes.
     */
    public final List<String> groupByAsStrings() {
        return groupBy;
    }

    /**
     * <p>
     * Specifies the maximum number of results to be returned in each page. A query can return fewer than this maximum,
     * even if there are more results still to return. You should always check the <code>PaginationToken</code> response
     * value to see if there are more results. You can specify a minimum of 1 and a maximum value of 100.
     * </p>
     * 
     * @return Specifies the maximum number of results to be returned in each page. A query can return fewer than this
     *         maximum, even if there are more results still to return. You should always check the
     *         <code>PaginationToken</code> response value to see if there are more results. You can specify a minimum
     *         of 1 and a maximum value of 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies a <code>PaginationToken</code> response value from a previous request to indicate that you want the
     * next page of results. Leave this parameter empty in your initial request.
     * </p>
     * 
     * @return Specifies a <code>PaginationToken</code> response value from a previous request to indicate that you want
     *         the next page of results. Leave this parameter empty in your initial request.
     */
    public final String paginationToken() {
        return paginationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetIdFilters() ? targetIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionFilters() ? regionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypeFilters() ? resourceTypeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagKeyFilters() ? tagKeyFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupBy() ? groupByAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceSummaryRequest)) {
            return false;
        }
        GetComplianceSummaryRequest other = (GetComplianceSummaryRequest) obj;
        return hasTargetIdFilters() == other.hasTargetIdFilters() && Objects.equals(targetIdFilters(), other.targetIdFilters())
                && hasRegionFilters() == other.hasRegionFilters() && Objects.equals(regionFilters(), other.regionFilters())
                && hasResourceTypeFilters() == other.hasResourceTypeFilters()
                && Objects.equals(resourceTypeFilters(), other.resourceTypeFilters())
                && hasTagKeyFilters() == other.hasTagKeyFilters() && Objects.equals(tagKeyFilters(), other.tagKeyFilters())
                && hasGroupBy() == other.hasGroupBy() && Objects.equals(groupByAsStrings(), other.groupByAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(paginationToken(), other.paginationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetComplianceSummaryRequest")
                .add("TargetIdFilters", hasTargetIdFilters() ? targetIdFilters() : null)
                .add("RegionFilters", hasRegionFilters() ? regionFilters() : null)
                .add("ResourceTypeFilters", hasResourceTypeFilters() ? resourceTypeFilters() : null)
                .add("TagKeyFilters", hasTagKeyFilters() ? tagKeyFilters() : null)
                .add("GroupBy", hasGroupBy() ? groupByAsStrings() : null).add("MaxResults", maxResults())
                .add("PaginationToken", paginationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetIdFilters":
            return Optional.ofNullable(clazz.cast(targetIdFilters()));
        case "RegionFilters":
            return Optional.ofNullable(clazz.cast(regionFilters()));
        case "ResourceTypeFilters":
            return Optional.ofNullable(clazz.cast(resourceTypeFilters()));
        case "TagKeyFilters":
            return Optional.ofNullable(clazz.cast(tagKeyFilters()));
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupByAsStrings()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceSummaryRequest, T> g) {
        return obj -> g.apply((GetComplianceSummaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsTaggingApiRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetComplianceSummaryRequest> {
        /**
         * <p>
         * Specifies target identifiers (usually, specific account IDs) to limit the output by. If you use this
         * parameter, the count of returned noncompliant resources includes only resources with the specified target
         * IDs.
         * </p>
         * 
         * @param targetIdFilters
         *        Specifies target identifiers (usually, specific account IDs) to limit the output by. If you use this
         *        parameter, the count of returned noncompliant resources includes only resources with the specified
         *        target IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdFilters(Collection<String> targetIdFilters);

        /**
         * <p>
         * Specifies target identifiers (usually, specific account IDs) to limit the output by. If you use this
         * parameter, the count of returned noncompliant resources includes only resources with the specified target
         * IDs.
         * </p>
         * 
         * @param targetIdFilters
         *        Specifies target identifiers (usually, specific account IDs) to limit the output by. If you use this
         *        parameter, the count of returned noncompliant resources includes only resources with the specified
         *        target IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdFilters(String... targetIdFilters);

        /**
         * <p>
         * Specifies a list of Amazon Web Services Regions to limit the output to. If you use this parameter, the count
         * of returned noncompliant resources includes only resources in the specified Regions.
         * </p>
         * 
         * @param regionFilters
         *        Specifies a list of Amazon Web Services Regions to limit the output to. If you use this parameter, the
         *        count of returned noncompliant resources includes only resources in the specified Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionFilters(Collection<String> regionFilters);

        /**
         * <p>
         * Specifies a list of Amazon Web Services Regions to limit the output to. If you use this parameter, the count
         * of returned noncompliant resources includes only resources in the specified Regions.
         * </p>
         * 
         * @param regionFilters
         *        Specifies a list of Amazon Web Services Regions to limit the output to. If you use this parameter, the
         *        count of returned noncompliant resources includes only resources in the specified Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionFilters(String... regionFilters);

        /**
         * <p>
         * Specifies that you want the response to include information for only resources of the specified types. The
         * format of each resource type is <code>service[:resourceType]</code>. For example, specifying a resource type
         * of <code>ec2</code> returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource
         * type of <code>ec2:instance</code> returns only EC2 instances.
         * </p>
         * <p>
         * The string for each service name and resource type is the same as that embedded in a resource's Amazon
         * Resource Name (ARN). Consult the <i> <a href="https://docs.aws.amazon.com/general/latest/gr/">Amazon Web
         * Services General Reference</a> </i> for the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For a list of service name strings, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         * >Amazon Web Services Service Namespaces</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For resource type strings, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax">Example
         * ARNs</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and Amazon Web Services Service Namespaces</a>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can specify multiple resource types by using a comma separated array. The array can include up to 100
         * items. Note that the length constraint requirement applies to each resource type filter.
         * </p>
         * 
         * @param resourceTypeFilters
         *        Specifies that you want the response to include information for only resources of the specified types.
         *        The format of each resource type is <code>service[:resourceType]</code>. For example, specifying a
         *        resource type of <code>ec2</code> returns all Amazon EC2 resources (which includes EC2 instances).
         *        Specifying a resource type of <code>ec2:instance</code> returns only EC2 instances.</p>
         *        <p>
         *        The string for each service name and resource type is the same as that embedded in a resource's Amazon
         *        Resource Name (ARN). Consult the <i> <a href="https://docs.aws.amazon.com/general/latest/gr/">Amazon
         *        Web Services General Reference</a> </i> for the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For a list of service name strings, see <a href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         *        >Amazon Web Services Service Namespaces</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For resource type strings, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax">Example
         *        ARNs</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can specify multiple resource types by using a comma separated array. The array can include up to
         *        100 items. Note that the length constraint requirement applies to each resource type filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeFilters(Collection<String> resourceTypeFilters);

        /**
         * <p>
         * Specifies that you want the response to include information for only resources of the specified types. The
         * format of each resource type is <code>service[:resourceType]</code>. For example, specifying a resource type
         * of <code>ec2</code> returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource
         * type of <code>ec2:instance</code> returns only EC2 instances.
         * </p>
         * <p>
         * The string for each service name and resource type is the same as that embedded in a resource's Amazon
         * Resource Name (ARN). Consult the <i> <a href="https://docs.aws.amazon.com/general/latest/gr/">Amazon Web
         * Services General Reference</a> </i> for the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For a list of service name strings, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         * >Amazon Web Services Service Namespaces</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For resource type strings, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax">Example
         * ARNs</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and Amazon Web Services Service Namespaces</a>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can specify multiple resource types by using a comma separated array. The array can include up to 100
         * items. Note that the length constraint requirement applies to each resource type filter.
         * </p>
         * 
         * @param resourceTypeFilters
         *        Specifies that you want the response to include information for only resources of the specified types.
         *        The format of each resource type is <code>service[:resourceType]</code>. For example, specifying a
         *        resource type of <code>ec2</code> returns all Amazon EC2 resources (which includes EC2 instances).
         *        Specifying a resource type of <code>ec2:instance</code> returns only EC2 instances.</p>
         *        <p>
         *        The string for each service name and resource type is the same as that embedded in a resource's Amazon
         *        Resource Name (ARN). Consult the <i> <a href="https://docs.aws.amazon.com/general/latest/gr/">Amazon
         *        Web Services General Reference</a> </i> for the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For a list of service name strings, see <a href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         *        >Amazon Web Services Service Namespaces</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For resource type strings, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax">Example
         *        ARNs</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can specify multiple resource types by using a comma separated array. The array can include up to
         *        100 items. Note that the length constraint requirement applies to each resource type filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeFilters(String... resourceTypeFilters);

        /**
         * <p>
         * Specifies that you want the response to include information for only resources that have tags with the
         * specified tag keys. If you use this parameter, the count of returned noncompliant resources includes only
         * resources that have the specified tag keys.
         * </p>
         * 
         * @param tagKeyFilters
         *        Specifies that you want the response to include information for only resources that have tags with the
         *        specified tag keys. If you use this parameter, the count of returned noncompliant resources includes
         *        only resources that have the specified tag keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyFilters(Collection<String> tagKeyFilters);

        /**
         * <p>
         * Specifies that you want the response to include information for only resources that have tags with the
         * specified tag keys. If you use this parameter, the count of returned noncompliant resources includes only
         * resources that have the specified tag keys.
         * </p>
         * 
         * @param tagKeyFilters
         *        Specifies that you want the response to include information for only resources that have tags with the
         *        specified tag keys. If you use this parameter, the count of returned noncompliant resources includes
         *        only resources that have the specified tag keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyFilters(String... tagKeyFilters);

        /**
         * <p>
         * Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the counts are
         * sorted by those attributes.
         * </p>
         * 
         * @param groupBy
         *        Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the
         *        counts are sorted by those attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByWithStrings(Collection<String> groupBy);

        /**
         * <p>
         * Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the counts are
         * sorted by those attributes.
         * </p>
         * 
         * @param groupBy
         *        Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the
         *        counts are sorted by those attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByWithStrings(String... groupBy);

        /**
         * <p>
         * Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the counts are
         * sorted by those attributes.
         * </p>
         * 
         * @param groupBy
         *        Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the
         *        counts are sorted by those attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(Collection<GroupByAttribute> groupBy);

        /**
         * <p>
         * Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the counts are
         * sorted by those attributes.
         * </p>
         * 
         * @param groupBy
         *        Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the
         *        counts are sorted by those attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(GroupByAttribute... groupBy);

        /**
         * <p>
         * Specifies the maximum number of results to be returned in each page. A query can return fewer than this
         * maximum, even if there are more results still to return. You should always check the
         * <code>PaginationToken</code> response value to see if there are more results. You can specify a minimum of 1
         * and a maximum value of 100.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of results to be returned in each page. A query can return fewer than
         *        this maximum, even if there are more results still to return. You should always check the
         *        <code>PaginationToken</code> response value to see if there are more results. You can specify a
         *        minimum of 1 and a maximum value of 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies a <code>PaginationToken</code> response value from a previous request to indicate that you want the
         * next page of results. Leave this parameter empty in your initial request.
         * </p>
         * 
         * @param paginationToken
         *        Specifies a <code>PaginationToken</code> response value from a previous request to indicate that you
         *        want the next page of results. Leave this parameter empty in your initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsTaggingApiRequest.BuilderImpl implements Builder {
        private List<String> targetIdFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> regionFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypeFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> tagKeyFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> groupBy = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceSummaryRequest model) {
            super(model);
            targetIdFilters(model.targetIdFilters);
            regionFilters(model.regionFilters);
            resourceTypeFilters(model.resourceTypeFilters);
            tagKeyFilters(model.tagKeyFilters);
            groupByWithStrings(model.groupBy);
            maxResults(model.maxResults);
            paginationToken(model.paginationToken);
        }

        public final Collection<String> getTargetIdFilters() {
            if (targetIdFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return targetIdFilters;
        }

        public final void setTargetIdFilters(Collection<String> targetIdFilters) {
            this.targetIdFilters = TargetIdFilterListCopier.copy(targetIdFilters);
        }

        @Override
        public final Builder targetIdFilters(Collection<String> targetIdFilters) {
            this.targetIdFilters = TargetIdFilterListCopier.copy(targetIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIdFilters(String... targetIdFilters) {
            targetIdFilters(Arrays.asList(targetIdFilters));
            return this;
        }

        public final Collection<String> getRegionFilters() {
            if (regionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return regionFilters;
        }

        public final void setRegionFilters(Collection<String> regionFilters) {
            this.regionFilters = RegionFilterListCopier.copy(regionFilters);
        }

        @Override
        public final Builder regionFilters(Collection<String> regionFilters) {
            this.regionFilters = RegionFilterListCopier.copy(regionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionFilters(String... regionFilters) {
            regionFilters(Arrays.asList(regionFilters));
            return this;
        }

        public final Collection<String> getResourceTypeFilters() {
            if (resourceTypeFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypeFilters;
        }

        public final void setResourceTypeFilters(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFilterListCopier.copy(resourceTypeFilters);
        }

        @Override
        public final Builder resourceTypeFilters(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFilterListCopier.copy(resourceTypeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeFilters(String... resourceTypeFilters) {
            resourceTypeFilters(Arrays.asList(resourceTypeFilters));
            return this;
        }

        public final Collection<String> getTagKeyFilters() {
            if (tagKeyFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return tagKeyFilters;
        }

        public final void setTagKeyFilters(Collection<String> tagKeyFilters) {
            this.tagKeyFilters = TagKeyFilterListCopier.copy(tagKeyFilters);
        }

        @Override
        public final Builder tagKeyFilters(Collection<String> tagKeyFilters) {
            this.tagKeyFilters = TagKeyFilterListCopier.copy(tagKeyFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyFilters(String... tagKeyFilters) {
            tagKeyFilters(Arrays.asList(tagKeyFilters));
            return this;
        }

        public final Collection<String> getGroupBy() {
            if (groupBy instanceof SdkAutoConstructList) {
                return null;
            }
            return groupBy;
        }

        public final void setGroupBy(Collection<String> groupBy) {
            this.groupBy = GroupByCopier.copy(groupBy);
        }

        @Override
        public final Builder groupByWithStrings(Collection<String> groupBy) {
            this.groupBy = GroupByCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByWithStrings(String... groupBy) {
            groupByWithStrings(Arrays.asList(groupBy));
            return this;
        }

        @Override
        public final Builder groupBy(Collection<GroupByAttribute> groupBy) {
            this.groupBy = GroupByCopier.copyEnumToString(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupByAttribute... groupBy) {
            groupBy(Arrays.asList(groupBy));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComplianceSummaryRequest build() {
            return new GetComplianceSummaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
