/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The association of a datashare from a producer account with a data consumer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataShareAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<DataShareAssociation.Builder, DataShareAssociation> {
    private static final SdkField<String> CONSUMER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerIdentifier").getter(getter(DataShareAssociation::consumerIdentifier))
            .setter(setter(Builder::consumerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DataShareAssociation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CONSUMER_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerRegion").getter(getter(DataShareAssociation::consumerRegion))
            .setter(setter(Builder::consumerRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerRegion").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(DataShareAssociation::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<Instant> STATUS_CHANGE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StatusChangeDate").getter(getter(DataShareAssociation::statusChangeDate))
            .setter(setter(Builder::statusChangeDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusChangeDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_IDENTIFIER_FIELD,
            STATUS_FIELD, CONSUMER_REGION_FIELD, CREATED_DATE_FIELD, STATUS_CHANGE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String consumerIdentifier;

    private final String status;

    private final String consumerRegion;

    private final Instant createdDate;

    private final Instant statusChangeDate;

    private DataShareAssociation(BuilderImpl builder) {
        this.consumerIdentifier = builder.consumerIdentifier;
        this.status = builder.status;
        this.consumerRegion = builder.consumerRegion;
        this.createdDate = builder.createdDate;
        this.statusChangeDate = builder.statusChangeDate;
    }

    /**
     * <p>
     * The name of the consumer accounts that have an association with a producer datashare.
     * </p>
     * 
     * @return The name of the consumer accounts that have an association with a producer datashare.
     */
    public final String consumerIdentifier() {
        return consumerIdentifier;
    }

    /**
     * <p>
     * The status of the datashare that is associated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the datashare that is associated.
     * @see DataShareStatus
     */
    public final DataShareStatus status() {
        return DataShareStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the datashare that is associated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the datashare that is associated.
     * @see DataShareStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.
     * </p>
     * 
     * @return The Amazon Web Services Region of the consumer accounts that have an association with a producer
     *         datashare.
     */
    public final String consumerRegion() {
        return consumerRegion;
    }

    /**
     * <p>
     * The creation date of the datashare that is associated.
     * </p>
     * 
     * @return The creation date of the datashare that is associated.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The status change data of the datashare that is associated.
     * </p>
     * 
     * @return The status change data of the datashare that is associated.
     */
    public final Instant statusChangeDate() {
        return statusChangeDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(consumerRegion());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusChangeDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataShareAssociation)) {
            return false;
        }
        DataShareAssociation other = (DataShareAssociation) obj;
        return Objects.equals(consumerIdentifier(), other.consumerIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(consumerRegion(), other.consumerRegion()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(statusChangeDate(), other.statusChangeDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataShareAssociation").add("ConsumerIdentifier", consumerIdentifier())
                .add("Status", statusAsString()).add("ConsumerRegion", consumerRegion()).add("CreatedDate", createdDate())
                .add("StatusChangeDate", statusChangeDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerIdentifier":
            return Optional.ofNullable(clazz.cast(consumerIdentifier()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ConsumerRegion":
            return Optional.ofNullable(clazz.cast(consumerRegion()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "StatusChangeDate":
            return Optional.ofNullable(clazz.cast(statusChangeDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataShareAssociation, T> g) {
        return obj -> g.apply((DataShareAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataShareAssociation> {
        /**
         * <p>
         * The name of the consumer accounts that have an association with a producer datashare.
         * </p>
         * 
         * @param consumerIdentifier
         *        The name of the consumer accounts that have an association with a producer datashare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerIdentifier(String consumerIdentifier);

        /**
         * <p>
         * The status of the datashare that is associated.
         * </p>
         * 
         * @param status
         *        The status of the datashare that is associated.
         * @see DataShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataShareStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the datashare that is associated.
         * </p>
         * 
         * @param status
         *        The status of the datashare that is associated.
         * @see DataShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataShareStatus
         */
        Builder status(DataShareStatus status);

        /**
         * <p>
         * The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.
         * </p>
         * 
         * @param consumerRegion
         *        The Amazon Web Services Region of the consumer accounts that have an association with a producer
         *        datashare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerRegion(String consumerRegion);

        /**
         * <p>
         * The creation date of the datashare that is associated.
         * </p>
         * 
         * @param createdDate
         *        The creation date of the datashare that is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The status change data of the datashare that is associated.
         * </p>
         * 
         * @param statusChangeDate
         *        The status change data of the datashare that is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusChangeDate(Instant statusChangeDate);
    }

    static final class BuilderImpl implements Builder {
        private String consumerIdentifier;

        private String status;

        private String consumerRegion;

        private Instant createdDate;

        private Instant statusChangeDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DataShareAssociation model) {
            consumerIdentifier(model.consumerIdentifier);
            status(model.status);
            consumerRegion(model.consumerRegion);
            createdDate(model.createdDate);
            statusChangeDate(model.statusChangeDate);
        }

        public final String getConsumerIdentifier() {
            return consumerIdentifier;
        }

        public final void setConsumerIdentifier(String consumerIdentifier) {
            this.consumerIdentifier = consumerIdentifier;
        }

        @Override
        public final Builder consumerIdentifier(String consumerIdentifier) {
            this.consumerIdentifier = consumerIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getConsumerRegion() {
            return consumerRegion;
        }

        public final void setConsumerRegion(String consumerRegion) {
            this.consumerRegion = consumerRegion;
        }

        @Override
        public final Builder consumerRegion(String consumerRegion) {
            this.consumerRegion = consumerRegion;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getStatusChangeDate() {
            return statusChangeDate;
        }

        public final void setStatusChangeDate(Instant statusChangeDate) {
            this.statusChangeDate = statusChangeDate;
        }

        @Override
        public final Builder statusChangeDate(Instant statusChangeDate) {
            this.statusChangeDate = statusChangeDate;
            return this;
        }

        @Override
        public DataShareAssociation build() {
            return new DataShareAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
