/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data structure with information about any primary and secondary clusters associated with a global cluster (Aurora
 * global database).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalClusterMember implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalClusterMember.Builder, GlobalClusterMember> {
    private static final SdkField<String> DB_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterArn").getter(getter(GlobalClusterMember::dbClusterArn)).setter(setter(Builder::dbClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterArn").build()).build();

    private static final SdkField<List<String>> READERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Readers")
            .getter(getter(GlobalClusterMember::readers))
            .setter(setter(Builder::readers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Readers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_WRITER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsWriter").getter(getter(GlobalClusterMember::isWriter)).setter(setter(Builder::isWriter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsWriter").build()).build();

    private static final SdkField<String> GLOBAL_WRITE_FORWARDING_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GlobalWriteForwardingStatus")
            .getter(getter(GlobalClusterMember::globalWriteForwardingStatusAsString))
            .setter(setter(Builder::globalWriteForwardingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalWriteForwardingStatus")
                    .build()).build();

    private static final SdkField<String> SYNCHRONIZATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SynchronizationStatus").getter(getter(GlobalClusterMember::synchronizationStatusAsString))
            .setter(setter(Builder::synchronizationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SynchronizationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ARN_FIELD,
            READERS_FIELD, IS_WRITER_FIELD, GLOBAL_WRITE_FORWARDING_STATUS_FIELD, SYNCHRONIZATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbClusterArn;

    private final List<String> readers;

    private final Boolean isWriter;

    private final String globalWriteForwardingStatus;

    private final String synchronizationStatus;

    private GlobalClusterMember(BuilderImpl builder) {
        this.dbClusterArn = builder.dbClusterArn;
        this.readers = builder.readers;
        this.isWriter = builder.isWriter;
        this.globalWriteForwardingStatus = builder.globalWriteForwardingStatus;
        this.synchronizationStatus = builder.synchronizationStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for each Aurora DB cluster in the global cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for each Aurora DB cluster in the global cluster.
     */
    public final String dbClusterArn() {
        return dbClusterArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Readers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReaders() {
        return readers != null && !(readers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the global cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReaders} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the global cluster.
     */
    public final List<String> readers() {
        return readers;
    }

    /**
     * <p>
     * Specifies whether the Aurora DB cluster is the primary cluster (that is, has read-write capability) for the
     * global cluster with which it is associated.
     * </p>
     * 
     * @return Specifies whether the Aurora DB cluster is the primary cluster (that is, has read-write capability) for
     *         the global cluster with which it is associated.
     */
    public final Boolean isWriter() {
        return isWriter;
    }

    /**
     * <p>
     * Specifies whether a secondary cluster in the global cluster has write forwarding enabled, not enabled, or is in
     * the process of enabling it.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #globalWriteForwardingStatus} will return {@link WriteForwardingStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #globalWriteForwardingStatusAsString}.
     * </p>
     * 
     * @return Specifies whether a secondary cluster in the global cluster has write forwarding enabled, not enabled, or
     *         is in the process of enabling it.
     * @see WriteForwardingStatus
     */
    public final WriteForwardingStatus globalWriteForwardingStatus() {
        return WriteForwardingStatus.fromValue(globalWriteForwardingStatus);
    }

    /**
     * <p>
     * Specifies whether a secondary cluster in the global cluster has write forwarding enabled, not enabled, or is in
     * the process of enabling it.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #globalWriteForwardingStatus} will return {@link WriteForwardingStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #globalWriteForwardingStatusAsString}.
     * </p>
     * 
     * @return Specifies whether a secondary cluster in the global cluster has write forwarding enabled, not enabled, or
     *         is in the process of enabling it.
     * @see WriteForwardingStatus
     */
    public final String globalWriteForwardingStatusAsString() {
        return globalWriteForwardingStatus;
    }

    /**
     * <p>
     * The status of synchronization of each Aurora DB cluster in the global cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #synchronizationStatus} will return
     * {@link GlobalClusterMemberSynchronizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #synchronizationStatusAsString}.
     * </p>
     * 
     * @return The status of synchronization of each Aurora DB cluster in the global cluster.
     * @see GlobalClusterMemberSynchronizationStatus
     */
    public final GlobalClusterMemberSynchronizationStatus synchronizationStatus() {
        return GlobalClusterMemberSynchronizationStatus.fromValue(synchronizationStatus);
    }

    /**
     * <p>
     * The status of synchronization of each Aurora DB cluster in the global cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #synchronizationStatus} will return
     * {@link GlobalClusterMemberSynchronizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #synchronizationStatusAsString}.
     * </p>
     * 
     * @return The status of synchronization of each Aurora DB cluster in the global cluster.
     * @see GlobalClusterMemberSynchronizationStatus
     */
    public final String synchronizationStatusAsString() {
        return synchronizationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasReaders() ? readers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isWriter());
        hashCode = 31 * hashCode + Objects.hashCode(globalWriteForwardingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(synchronizationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalClusterMember)) {
            return false;
        }
        GlobalClusterMember other = (GlobalClusterMember) obj;
        return Objects.equals(dbClusterArn(), other.dbClusterArn()) && hasReaders() == other.hasReaders()
                && Objects.equals(readers(), other.readers()) && Objects.equals(isWriter(), other.isWriter())
                && Objects.equals(globalWriteForwardingStatusAsString(), other.globalWriteForwardingStatusAsString())
                && Objects.equals(synchronizationStatusAsString(), other.synchronizationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalClusterMember").add("DBClusterArn", dbClusterArn())
                .add("Readers", hasReaders() ? readers() : null).add("IsWriter", isWriter())
                .add("GlobalWriteForwardingStatus", globalWriteForwardingStatusAsString())
                .add("SynchronizationStatus", synchronizationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterArn":
            return Optional.ofNullable(clazz.cast(dbClusterArn()));
        case "Readers":
            return Optional.ofNullable(clazz.cast(readers()));
        case "IsWriter":
            return Optional.ofNullable(clazz.cast(isWriter()));
        case "GlobalWriteForwardingStatus":
            return Optional.ofNullable(clazz.cast(globalWriteForwardingStatusAsString()));
        case "SynchronizationStatus":
            return Optional.ofNullable(clazz.cast(synchronizationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalClusterMember, T> g) {
        return obj -> g.apply((GlobalClusterMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalClusterMember> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for each Aurora DB cluster in the global cluster.
         * </p>
         * 
         * @param dbClusterArn
         *        The Amazon Resource Name (ARN) for each Aurora DB cluster in the global cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterArn(String dbClusterArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the global cluster.
         * </p>
         * 
         * @param readers
         *        The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the global
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readers(Collection<String> readers);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the global cluster.
         * </p>
         * 
         * @param readers
         *        The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the global
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readers(String... readers);

        /**
         * <p>
         * Specifies whether the Aurora DB cluster is the primary cluster (that is, has read-write capability) for the
         * global cluster with which it is associated.
         * </p>
         * 
         * @param isWriter
         *        Specifies whether the Aurora DB cluster is the primary cluster (that is, has read-write capability)
         *        for the global cluster with which it is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isWriter(Boolean isWriter);

        /**
         * <p>
         * Specifies whether a secondary cluster in the global cluster has write forwarding enabled, not enabled, or is
         * in the process of enabling it.
         * </p>
         * 
         * @param globalWriteForwardingStatus
         *        Specifies whether a secondary cluster in the global cluster has write forwarding enabled, not enabled,
         *        or is in the process of enabling it.
         * @see WriteForwardingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WriteForwardingStatus
         */
        Builder globalWriteForwardingStatus(String globalWriteForwardingStatus);

        /**
         * <p>
         * Specifies whether a secondary cluster in the global cluster has write forwarding enabled, not enabled, or is
         * in the process of enabling it.
         * </p>
         * 
         * @param globalWriteForwardingStatus
         *        Specifies whether a secondary cluster in the global cluster has write forwarding enabled, not enabled,
         *        or is in the process of enabling it.
         * @see WriteForwardingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WriteForwardingStatus
         */
        Builder globalWriteForwardingStatus(WriteForwardingStatus globalWriteForwardingStatus);

        /**
         * <p>
         * The status of synchronization of each Aurora DB cluster in the global cluster.
         * </p>
         * 
         * @param synchronizationStatus
         *        The status of synchronization of each Aurora DB cluster in the global cluster.
         * @see GlobalClusterMemberSynchronizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalClusterMemberSynchronizationStatus
         */
        Builder synchronizationStatus(String synchronizationStatus);

        /**
         * <p>
         * The status of synchronization of each Aurora DB cluster in the global cluster.
         * </p>
         * 
         * @param synchronizationStatus
         *        The status of synchronization of each Aurora DB cluster in the global cluster.
         * @see GlobalClusterMemberSynchronizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalClusterMemberSynchronizationStatus
         */
        Builder synchronizationStatus(GlobalClusterMemberSynchronizationStatus synchronizationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String dbClusterArn;

        private List<String> readers = DefaultSdkAutoConstructList.getInstance();

        private Boolean isWriter;

        private String globalWriteForwardingStatus;

        private String synchronizationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalClusterMember model) {
            dbClusterArn(model.dbClusterArn);
            readers(model.readers);
            isWriter(model.isWriter);
            globalWriteForwardingStatus(model.globalWriteForwardingStatus);
            synchronizationStatus(model.synchronizationStatus);
        }

        public final String getDbClusterArn() {
            return dbClusterArn;
        }

        public final void setDbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        @Override
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final Collection<String> getReaders() {
            if (readers instanceof SdkAutoConstructList) {
                return null;
            }
            return readers;
        }

        public final void setReaders(Collection<String> readers) {
            this.readers = ReadersArnListCopier.copy(readers);
        }

        @Override
        public final Builder readers(Collection<String> readers) {
            this.readers = ReadersArnListCopier.copy(readers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readers(String... readers) {
            readers(Arrays.asList(readers));
            return this;
        }

        public final Boolean getIsWriter() {
            return isWriter;
        }

        public final void setIsWriter(Boolean isWriter) {
            this.isWriter = isWriter;
        }

        @Override
        public final Builder isWriter(Boolean isWriter) {
            this.isWriter = isWriter;
            return this;
        }

        public final String getGlobalWriteForwardingStatus() {
            return globalWriteForwardingStatus;
        }

        public final void setGlobalWriteForwardingStatus(String globalWriteForwardingStatus) {
            this.globalWriteForwardingStatus = globalWriteForwardingStatus;
        }

        @Override
        public final Builder globalWriteForwardingStatus(String globalWriteForwardingStatus) {
            this.globalWriteForwardingStatus = globalWriteForwardingStatus;
            return this;
        }

        @Override
        public final Builder globalWriteForwardingStatus(WriteForwardingStatus globalWriteForwardingStatus) {
            this.globalWriteForwardingStatus(globalWriteForwardingStatus == null ? null : globalWriteForwardingStatus.toString());
            return this;
        }

        public final String getSynchronizationStatus() {
            return synchronizationStatus;
        }

        public final void setSynchronizationStatus(String synchronizationStatus) {
            this.synchronizationStatus = synchronizationStatus;
        }

        @Override
        public final Builder synchronizationStatus(String synchronizationStatus) {
            this.synchronizationStatus = synchronizationStatus;
            return this;
        }

        @Override
        public final Builder synchronizationStatus(GlobalClusterMemberSynchronizationStatus synchronizationStatus) {
            this.synchronizationStatus(synchronizationStatus == null ? null : synchronizationStatus.toString());
            return this;
        }

        @Override
        public GlobalClusterMember build() {
            return new GlobalClusterMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
