/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGovCloudAccountResponse extends OrganizationsResponse implements
        ToCopyableBuilder<CreateGovCloudAccountResponse.Builder, CreateGovCloudAccountResponse> {
    private static final SdkField<CreateAccountStatus> CREATE_ACCOUNT_STATUS_FIELD = SdkField
            .<CreateAccountStatus> builder(MarshallingType.SDK_POJO).memberName("CreateAccountStatus")
            .getter(getter(CreateGovCloudAccountResponse::createAccountStatus)).setter(setter(Builder::createAccountStatus))
            .constructor(CreateAccountStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAccountStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_ACCOUNT_STATUS_FIELD));

    private final CreateAccountStatus createAccountStatus;

    private CreateGovCloudAccountResponse(BuilderImpl builder) {
        super(builder);
        this.createAccountStatus = builder.createAccountStatus;
    }

    /**
     * Returns the value of the CreateAccountStatus property for this object.
     * 
     * @return The value of the CreateAccountStatus property for this object.
     */
    public final CreateAccountStatus createAccountStatus() {
        return createAccountStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createAccountStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGovCloudAccountResponse)) {
            return false;
        }
        CreateGovCloudAccountResponse other = (CreateGovCloudAccountResponse) obj;
        return Objects.equals(createAccountStatus(), other.createAccountStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGovCloudAccountResponse").add("CreateAccountStatus", createAccountStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateAccountStatus":
            return Optional.ofNullable(clazz.cast(createAccountStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGovCloudAccountResponse, T> g) {
        return obj -> g.apply((CreateGovCloudAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGovCloudAccountResponse> {
        /**
         * Sets the value of the CreateAccountStatus property for this object.
         *
         * @param createAccountStatus
         *        The new value for the CreateAccountStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createAccountStatus(CreateAccountStatus createAccountStatus);

        /**
         * Sets the value of the CreateAccountStatus property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CreateAccountStatus.Builder} avoiding the
         * need to create one manually via {@link CreateAccountStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateAccountStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #createAccountStatus(CreateAccountStatus)}.
         * 
         * @param createAccountStatus
         *        a consumer that will call methods on {@link CreateAccountStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createAccountStatus(CreateAccountStatus)
         */
        default Builder createAccountStatus(Consumer<CreateAccountStatus.Builder> createAccountStatus) {
            return createAccountStatus(CreateAccountStatus.builder().applyMutation(createAccountStatus).build());
        }
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private CreateAccountStatus createAccountStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGovCloudAccountResponse model) {
            super(model);
            createAccountStatus(model.createAccountStatus);
        }

        public final CreateAccountStatus.Builder getCreateAccountStatus() {
            return createAccountStatus != null ? createAccountStatus.toBuilder() : null;
        }

        public final void setCreateAccountStatus(CreateAccountStatus.BuilderImpl createAccountStatus) {
            this.createAccountStatus = createAccountStatus != null ? createAccountStatus.build() : null;
        }

        @Override
        public final Builder createAccountStatus(CreateAccountStatus createAccountStatus) {
            this.createAccountStatus = createAccountStatus;
            return this;
        }

        @Override
        public CreateGovCloudAccountResponse build() {
            return new CreateGovCloudAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
