/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Webvtt Destination Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebvttDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<WebvttDestinationSettings.Builder, WebvttDestinationSettings> {
    private static final SdkField<String> STYLE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StyleControl").getter(getter(WebvttDestinationSettings::styleControlAsString))
            .setter(setter(Builder::styleControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("styleControl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_CONTROL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String styleControl;

    private WebvttDestinationSettings(BuilderImpl builder) {
        this.styleControl = builder.styleControl;
    }

    /**
     * Controls whether the color and position of the source captions is passed through to the WebVTT output captions.
     * PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO_STYLE_DATA - Don't pass through the
     * style. The output captions will not contain any font styling information.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #styleControl} will
     * return {@link WebvttDestinationStyleControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #styleControlAsString}.
     * </p>
     * 
     * @return Controls whether the color and position of the source captions is passed through to the WebVTT output
     *         captions. PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO_STYLE_DATA - Don't
     *         pass through the style. The output captions will not contain any font styling information.
     * @see WebvttDestinationStyleControl
     */
    public final WebvttDestinationStyleControl styleControl() {
        return WebvttDestinationStyleControl.fromValue(styleControl);
    }

    /**
     * Controls whether the color and position of the source captions is passed through to the WebVTT output captions.
     * PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO_STYLE_DATA - Don't pass through the
     * style. The output captions will not contain any font styling information.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #styleControl} will
     * return {@link WebvttDestinationStyleControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #styleControlAsString}.
     * </p>
     * 
     * @return Controls whether the color and position of the source captions is passed through to the WebVTT output
     *         captions. PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO_STYLE_DATA - Don't
     *         pass through the style. The output captions will not contain any font styling information.
     * @see WebvttDestinationStyleControl
     */
    public final String styleControlAsString() {
        return styleControl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(styleControlAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebvttDestinationSettings)) {
            return false;
        }
        WebvttDestinationSettings other = (WebvttDestinationSettings) obj;
        return Objects.equals(styleControlAsString(), other.styleControlAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebvttDestinationSettings").add("StyleControl", styleControlAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StyleControl":
            return Optional.ofNullable(clazz.cast(styleControlAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebvttDestinationSettings, T> g) {
        return obj -> g.apply((WebvttDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebvttDestinationSettings> {
        /**
         * Controls whether the color and position of the source captions is passed through to the WebVTT output
         * captions. PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO_STYLE_DATA - Don't
         * pass through the style. The output captions will not contain any font styling information.
         * 
         * @param styleControl
         *        Controls whether the color and position of the source captions is passed through to the WebVTT output
         *        captions. PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO_STYLE_DATA -
         *        Don't pass through the style. The output captions will not contain any font styling information.
         * @see WebvttDestinationStyleControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebvttDestinationStyleControl
         */
        Builder styleControl(String styleControl);

        /**
         * Controls whether the color and position of the source captions is passed through to the WebVTT output
         * captions. PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO_STYLE_DATA - Don't
         * pass through the style. The output captions will not contain any font styling information.
         * 
         * @param styleControl
         *        Controls whether the color and position of the source captions is passed through to the WebVTT output
         *        captions. PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO_STYLE_DATA -
         *        Don't pass through the style. The output captions will not contain any font styling information.
         * @see WebvttDestinationStyleControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebvttDestinationStyleControl
         */
        Builder styleControl(WebvttDestinationStyleControl styleControl);
    }

    static final class BuilderImpl implements Builder {
        private String styleControl;

        private BuilderImpl() {
        }

        private BuilderImpl(WebvttDestinationSettings model) {
            styleControl(model.styleControl);
        }

        public final String getStyleControl() {
            return styleControl;
        }

        public final void setStyleControl(String styleControl) {
            this.styleControl = styleControl;
        }

        @Override
        public final Builder styleControl(String styleControl) {
            this.styleControl = styleControl;
            return this;
        }

        @Override
        public final Builder styleControl(WebvttDestinationStyleControl styleControl) {
            this.styleControl(styleControl == null ? null : styleControl.toString());
            return this;
        }

        @Override
        public WebvttDestinationSettings build() {
            return new WebvttDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
