/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for MaintenanceStatus
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceStatus.Builder, MaintenanceStatus> {
    private static final SdkField<String> MAINTENANCE_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceDay").getter(getter(MaintenanceStatus::maintenanceDayAsString))
            .setter(setter(Builder::maintenanceDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceDay").build()).build();

    private static final SdkField<String> MAINTENANCE_DEADLINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceDeadline").getter(getter(MaintenanceStatus::maintenanceDeadline))
            .setter(setter(Builder::maintenanceDeadline))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceDeadline").build())
            .build();

    private static final SdkField<String> MAINTENANCE_SCHEDULED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceScheduledDate").getter(getter(MaintenanceStatus::maintenanceScheduledDate))
            .setter(setter(Builder::maintenanceScheduledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceScheduledDate").build())
            .build();

    private static final SdkField<String> MAINTENANCE_START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceStartTime").getter(getter(MaintenanceStatus::maintenanceStartTime))
            .setter(setter(Builder::maintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceStartTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_DAY_FIELD,
            MAINTENANCE_DEADLINE_FIELD, MAINTENANCE_SCHEDULED_DATE_FIELD, MAINTENANCE_START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String maintenanceDay;

    private final String maintenanceDeadline;

    private final String maintenanceScheduledDate;

    private final String maintenanceStartTime;

    private MaintenanceStatus(BuilderImpl builder) {
        this.maintenanceDay = builder.maintenanceDay;
        this.maintenanceDeadline = builder.maintenanceDeadline;
        this.maintenanceScheduledDate = builder.maintenanceScheduledDate;
        this.maintenanceStartTime = builder.maintenanceStartTime;
    }

    /**
     * The currently selected maintenance day.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceDay}
     * will return {@link MaintenanceDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maintenanceDayAsString}.
     * </p>
     * 
     * @return The currently selected maintenance day.
     * @see MaintenanceDay
     */
    public final MaintenanceDay maintenanceDay() {
        return MaintenanceDay.fromValue(maintenanceDay);
    }

    /**
     * The currently selected maintenance day.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceDay}
     * will return {@link MaintenanceDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maintenanceDayAsString}.
     * </p>
     * 
     * @return The currently selected maintenance day.
     * @see MaintenanceDay
     */
    public final String maintenanceDayAsString() {
        return maintenanceDay;
    }

    /**
     * Maintenance is required by the displayed date and time. Date and time is in ISO.
     * 
     * @return Maintenance is required by the displayed date and time. Date and time is in ISO.
     */
    public final String maintenanceDeadline() {
        return maintenanceDeadline;
    }

    /**
     * The currently scheduled maintenance date and time. Date and time is in ISO.
     * 
     * @return The currently scheduled maintenance date and time. Date and time is in ISO.
     */
    public final String maintenanceScheduledDate() {
        return maintenanceScheduledDate;
    }

    /**
     * The currently selected maintenance start time. Time is in UTC.
     * 
     * @return The currently selected maintenance start time. Time is in UTC.
     */
    public final String maintenanceStartTime() {
        return maintenanceStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceDayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceDeadline());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceScheduledDate());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceStatus)) {
            return false;
        }
        MaintenanceStatus other = (MaintenanceStatus) obj;
        return Objects.equals(maintenanceDayAsString(), other.maintenanceDayAsString())
                && Objects.equals(maintenanceDeadline(), other.maintenanceDeadline())
                && Objects.equals(maintenanceScheduledDate(), other.maintenanceScheduledDate())
                && Objects.equals(maintenanceStartTime(), other.maintenanceStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceStatus").add("MaintenanceDay", maintenanceDayAsString())
                .add("MaintenanceDeadline", maintenanceDeadline()).add("MaintenanceScheduledDate", maintenanceScheduledDate())
                .add("MaintenanceStartTime", maintenanceStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaintenanceDay":
            return Optional.ofNullable(clazz.cast(maintenanceDayAsString()));
        case "MaintenanceDeadline":
            return Optional.ofNullable(clazz.cast(maintenanceDeadline()));
        case "MaintenanceScheduledDate":
            return Optional.ofNullable(clazz.cast(maintenanceScheduledDate()));
        case "MaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(maintenanceStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceStatus, T> g) {
        return obj -> g.apply((MaintenanceStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceStatus> {
        /**
         * The currently selected maintenance day.
         * 
         * @param maintenanceDay
         *        The currently selected maintenance day.
         * @see MaintenanceDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceDay
         */
        Builder maintenanceDay(String maintenanceDay);

        /**
         * The currently selected maintenance day.
         * 
         * @param maintenanceDay
         *        The currently selected maintenance day.
         * @see MaintenanceDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceDay
         */
        Builder maintenanceDay(MaintenanceDay maintenanceDay);

        /**
         * Maintenance is required by the displayed date and time. Date and time is in ISO.
         * 
         * @param maintenanceDeadline
         *        Maintenance is required by the displayed date and time. Date and time is in ISO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceDeadline(String maintenanceDeadline);

        /**
         * The currently scheduled maintenance date and time. Date and time is in ISO.
         * 
         * @param maintenanceScheduledDate
         *        The currently scheduled maintenance date and time. Date and time is in ISO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceScheduledDate(String maintenanceScheduledDate);

        /**
         * The currently selected maintenance start time. Time is in UTC.
         * 
         * @param maintenanceStartTime
         *        The currently selected maintenance start time. Time is in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceStartTime(String maintenanceStartTime);
    }

    static final class BuilderImpl implements Builder {
        private String maintenanceDay;

        private String maintenanceDeadline;

        private String maintenanceScheduledDate;

        private String maintenanceStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceStatus model) {
            maintenanceDay(model.maintenanceDay);
            maintenanceDeadline(model.maintenanceDeadline);
            maintenanceScheduledDate(model.maintenanceScheduledDate);
            maintenanceStartTime(model.maintenanceStartTime);
        }

        public final String getMaintenanceDay() {
            return maintenanceDay;
        }

        public final void setMaintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
        }

        @Override
        public final Builder maintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
            return this;
        }

        @Override
        public final Builder maintenanceDay(MaintenanceDay maintenanceDay) {
            this.maintenanceDay(maintenanceDay == null ? null : maintenanceDay.toString());
            return this;
        }

        public final String getMaintenanceDeadline() {
            return maintenanceDeadline;
        }

        public final void setMaintenanceDeadline(String maintenanceDeadline) {
            this.maintenanceDeadline = maintenanceDeadline;
        }

        @Override
        public final Builder maintenanceDeadline(String maintenanceDeadline) {
            this.maintenanceDeadline = maintenanceDeadline;
            return this;
        }

        public final String getMaintenanceScheduledDate() {
            return maintenanceScheduledDate;
        }

        public final void setMaintenanceScheduledDate(String maintenanceScheduledDate) {
            this.maintenanceScheduledDate = maintenanceScheduledDate;
        }

        @Override
        public final Builder maintenanceScheduledDate(String maintenanceScheduledDate) {
            this.maintenanceScheduledDate = maintenanceScheduledDate;
            return this;
        }

        public final String getMaintenanceStartTime() {
            return maintenanceStartTime;
        }

        public final void setMaintenanceStartTime(String maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
        }

        @Override
        public final Builder maintenanceStartTime(String maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
            return this;
        }

        @Override
        public MaintenanceStatus build() {
            return new MaintenanceStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
