/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Hls Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsSettings implements SdkPojo, Serializable, ToCopyableBuilder<HlsSettings.Builder, HlsSettings> {
    private static final SdkField<AudioOnlyHlsSettings> AUDIO_ONLY_HLS_SETTINGS_FIELD = SdkField
            .<AudioOnlyHlsSettings> builder(MarshallingType.SDK_POJO).memberName("AudioOnlyHlsSettings")
            .getter(getter(HlsSettings::audioOnlyHlsSettings)).setter(setter(Builder::audioOnlyHlsSettings))
            .constructor(AudioOnlyHlsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyHlsSettings").build())
            .build();

    private static final SdkField<Fmp4HlsSettings> FMP4_HLS_SETTINGS_FIELD = SdkField
            .<Fmp4HlsSettings> builder(MarshallingType.SDK_POJO).memberName("Fmp4HlsSettings")
            .getter(getter(HlsSettings::fmp4HlsSettings)).setter(setter(Builder::fmp4HlsSettings))
            .constructor(Fmp4HlsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fmp4HlsSettings").build()).build();

    private static final SdkField<FrameCaptureHlsSettings> FRAME_CAPTURE_HLS_SETTINGS_FIELD = SdkField
            .<FrameCaptureHlsSettings> builder(MarshallingType.SDK_POJO).memberName("FrameCaptureHlsSettings")
            .getter(getter(HlsSettings::frameCaptureHlsSettings)).setter(setter(Builder::frameCaptureHlsSettings))
            .constructor(FrameCaptureHlsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureHlsSettings").build())
            .build();

    private static final SdkField<StandardHlsSettings> STANDARD_HLS_SETTINGS_FIELD = SdkField
            .<StandardHlsSettings> builder(MarshallingType.SDK_POJO).memberName("StandardHlsSettings")
            .getter(getter(HlsSettings::standardHlsSettings)).setter(setter(Builder::standardHlsSettings))
            .constructor(StandardHlsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardHlsSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_ONLY_HLS_SETTINGS_FIELD,
            FMP4_HLS_SETTINGS_FIELD, FRAME_CAPTURE_HLS_SETTINGS_FIELD, STANDARD_HLS_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AudioOnlyHlsSettings audioOnlyHlsSettings;

    private final Fmp4HlsSettings fmp4HlsSettings;

    private final FrameCaptureHlsSettings frameCaptureHlsSettings;

    private final StandardHlsSettings standardHlsSettings;

    private HlsSettings(BuilderImpl builder) {
        this.audioOnlyHlsSettings = builder.audioOnlyHlsSettings;
        this.fmp4HlsSettings = builder.fmp4HlsSettings;
        this.frameCaptureHlsSettings = builder.frameCaptureHlsSettings;
        this.standardHlsSettings = builder.standardHlsSettings;
    }

    /**
     * Returns the value of the AudioOnlyHlsSettings property for this object.
     * 
     * @return The value of the AudioOnlyHlsSettings property for this object.
     */
    public final AudioOnlyHlsSettings audioOnlyHlsSettings() {
        return audioOnlyHlsSettings;
    }

    /**
     * Returns the value of the Fmp4HlsSettings property for this object.
     * 
     * @return The value of the Fmp4HlsSettings property for this object.
     */
    public final Fmp4HlsSettings fmp4HlsSettings() {
        return fmp4HlsSettings;
    }

    /**
     * Returns the value of the FrameCaptureHlsSettings property for this object.
     * 
     * @return The value of the FrameCaptureHlsSettings property for this object.
     */
    public final FrameCaptureHlsSettings frameCaptureHlsSettings() {
        return frameCaptureHlsSettings;
    }

    /**
     * Returns the value of the StandardHlsSettings property for this object.
     * 
     * @return The value of the StandardHlsSettings property for this object.
     */
    public final StandardHlsSettings standardHlsSettings() {
        return standardHlsSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioOnlyHlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(fmp4HlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(frameCaptureHlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(standardHlsSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsSettings)) {
            return false;
        }
        HlsSettings other = (HlsSettings) obj;
        return Objects.equals(audioOnlyHlsSettings(), other.audioOnlyHlsSettings())
                && Objects.equals(fmp4HlsSettings(), other.fmp4HlsSettings())
                && Objects.equals(frameCaptureHlsSettings(), other.frameCaptureHlsSettings())
                && Objects.equals(standardHlsSettings(), other.standardHlsSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsSettings").add("AudioOnlyHlsSettings", audioOnlyHlsSettings())
                .add("Fmp4HlsSettings", fmp4HlsSettings()).add("FrameCaptureHlsSettings", frameCaptureHlsSettings())
                .add("StandardHlsSettings", standardHlsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioOnlyHlsSettings":
            return Optional.ofNullable(clazz.cast(audioOnlyHlsSettings()));
        case "Fmp4HlsSettings":
            return Optional.ofNullable(clazz.cast(fmp4HlsSettings()));
        case "FrameCaptureHlsSettings":
            return Optional.ofNullable(clazz.cast(frameCaptureHlsSettings()));
        case "StandardHlsSettings":
            return Optional.ofNullable(clazz.cast(standardHlsSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsSettings, T> g) {
        return obj -> g.apply((HlsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsSettings> {
        /**
         * Sets the value of the AudioOnlyHlsSettings property for this object.
         *
         * @param audioOnlyHlsSettings
         *        The new value for the AudioOnlyHlsSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioOnlyHlsSettings(AudioOnlyHlsSettings audioOnlyHlsSettings);

        /**
         * Sets the value of the AudioOnlyHlsSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AudioOnlyHlsSettings.Builder} avoiding
         * the need to create one manually via {@link AudioOnlyHlsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioOnlyHlsSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #audioOnlyHlsSettings(AudioOnlyHlsSettings)}.
         * 
         * @param audioOnlyHlsSettings
         *        a consumer that will call methods on {@link AudioOnlyHlsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioOnlyHlsSettings(AudioOnlyHlsSettings)
         */
        default Builder audioOnlyHlsSettings(Consumer<AudioOnlyHlsSettings.Builder> audioOnlyHlsSettings) {
            return audioOnlyHlsSettings(AudioOnlyHlsSettings.builder().applyMutation(audioOnlyHlsSettings).build());
        }

        /**
         * Sets the value of the Fmp4HlsSettings property for this object.
         *
         * @param fmp4HlsSettings
         *        The new value for the Fmp4HlsSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fmp4HlsSettings(Fmp4HlsSettings fmp4HlsSettings);

        /**
         * Sets the value of the Fmp4HlsSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Fmp4HlsSettings.Builder} avoiding the
         * need to create one manually via {@link Fmp4HlsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Fmp4HlsSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #fmp4HlsSettings(Fmp4HlsSettings)}.
         * 
         * @param fmp4HlsSettings
         *        a consumer that will call methods on {@link Fmp4HlsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fmp4HlsSettings(Fmp4HlsSettings)
         */
        default Builder fmp4HlsSettings(Consumer<Fmp4HlsSettings.Builder> fmp4HlsSettings) {
            return fmp4HlsSettings(Fmp4HlsSettings.builder().applyMutation(fmp4HlsSettings).build());
        }

        /**
         * Sets the value of the FrameCaptureHlsSettings property for this object.
         *
         * @param frameCaptureHlsSettings
         *        The new value for the FrameCaptureHlsSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameCaptureHlsSettings(FrameCaptureHlsSettings frameCaptureHlsSettings);

        /**
         * Sets the value of the FrameCaptureHlsSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FrameCaptureHlsSettings.Builder} avoiding
         * the need to create one manually via {@link FrameCaptureHlsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FrameCaptureHlsSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #frameCaptureHlsSettings(FrameCaptureHlsSettings)}.
         * 
         * @param frameCaptureHlsSettings
         *        a consumer that will call methods on {@link FrameCaptureHlsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameCaptureHlsSettings(FrameCaptureHlsSettings)
         */
        default Builder frameCaptureHlsSettings(Consumer<FrameCaptureHlsSettings.Builder> frameCaptureHlsSettings) {
            return frameCaptureHlsSettings(FrameCaptureHlsSettings.builder().applyMutation(frameCaptureHlsSettings).build());
        }

        /**
         * Sets the value of the StandardHlsSettings property for this object.
         *
         * @param standardHlsSettings
         *        The new value for the StandardHlsSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardHlsSettings(StandardHlsSettings standardHlsSettings);

        /**
         * Sets the value of the StandardHlsSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StandardHlsSettings.Builder} avoiding the
         * need to create one manually via {@link StandardHlsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardHlsSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #standardHlsSettings(StandardHlsSettings)}.
         * 
         * @param standardHlsSettings
         *        a consumer that will call methods on {@link StandardHlsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardHlsSettings(StandardHlsSettings)
         */
        default Builder standardHlsSettings(Consumer<StandardHlsSettings.Builder> standardHlsSettings) {
            return standardHlsSettings(StandardHlsSettings.builder().applyMutation(standardHlsSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AudioOnlyHlsSettings audioOnlyHlsSettings;

        private Fmp4HlsSettings fmp4HlsSettings;

        private FrameCaptureHlsSettings frameCaptureHlsSettings;

        private StandardHlsSettings standardHlsSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsSettings model) {
            audioOnlyHlsSettings(model.audioOnlyHlsSettings);
            fmp4HlsSettings(model.fmp4HlsSettings);
            frameCaptureHlsSettings(model.frameCaptureHlsSettings);
            standardHlsSettings(model.standardHlsSettings);
        }

        public final AudioOnlyHlsSettings.Builder getAudioOnlyHlsSettings() {
            return audioOnlyHlsSettings != null ? audioOnlyHlsSettings.toBuilder() : null;
        }

        public final void setAudioOnlyHlsSettings(AudioOnlyHlsSettings.BuilderImpl audioOnlyHlsSettings) {
            this.audioOnlyHlsSettings = audioOnlyHlsSettings != null ? audioOnlyHlsSettings.build() : null;
        }

        @Override
        public final Builder audioOnlyHlsSettings(AudioOnlyHlsSettings audioOnlyHlsSettings) {
            this.audioOnlyHlsSettings = audioOnlyHlsSettings;
            return this;
        }

        public final Fmp4HlsSettings.Builder getFmp4HlsSettings() {
            return fmp4HlsSettings != null ? fmp4HlsSettings.toBuilder() : null;
        }

        public final void setFmp4HlsSettings(Fmp4HlsSettings.BuilderImpl fmp4HlsSettings) {
            this.fmp4HlsSettings = fmp4HlsSettings != null ? fmp4HlsSettings.build() : null;
        }

        @Override
        public final Builder fmp4HlsSettings(Fmp4HlsSettings fmp4HlsSettings) {
            this.fmp4HlsSettings = fmp4HlsSettings;
            return this;
        }

        public final FrameCaptureHlsSettings.Builder getFrameCaptureHlsSettings() {
            return frameCaptureHlsSettings != null ? frameCaptureHlsSettings.toBuilder() : null;
        }

        public final void setFrameCaptureHlsSettings(FrameCaptureHlsSettings.BuilderImpl frameCaptureHlsSettings) {
            this.frameCaptureHlsSettings = frameCaptureHlsSettings != null ? frameCaptureHlsSettings.build() : null;
        }

        @Override
        public final Builder frameCaptureHlsSettings(FrameCaptureHlsSettings frameCaptureHlsSettings) {
            this.frameCaptureHlsSettings = frameCaptureHlsSettings;
            return this;
        }

        public final StandardHlsSettings.Builder getStandardHlsSettings() {
            return standardHlsSettings != null ? standardHlsSettings.toBuilder() : null;
        }

        public final void setStandardHlsSettings(StandardHlsSettings.BuilderImpl standardHlsSettings) {
            this.standardHlsSettings = standardHlsSettings != null ? standardHlsSettings.build() : null;
        }

        @Override
        public final Builder standardHlsSettings(StandardHlsSettings standardHlsSettings) {
            this.standardHlsSettings = standardHlsSettings;
            return this;
        }

        @Override
        public HlsSettings build() {
            return new HlsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
