/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Epoch Locking Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class EpochLockingSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<EpochLockingSettings.Builder, EpochLockingSettings> {
    private static final SdkField<String> CUSTOM_EPOCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomEpoch").getter(getter(EpochLockingSettings::customEpoch)).setter(setter(Builder::customEpoch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customEpoch").build()).build();

    private static final SdkField<String> JAM_SYNC_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JamSyncTime").getter(getter(EpochLockingSettings::jamSyncTime)).setter(setter(Builder::jamSyncTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jamSyncTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_EPOCH_FIELD,
            JAM_SYNC_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customEpoch;

    private final String jamSyncTime;

    private EpochLockingSettings(BuilderImpl builder) {
        this.customEpoch = builder.customEpoch;
        this.jamSyncTime = builder.jamSyncTime;
    }

    /**
     * Optional. Enter a value here to use a custom epoch, instead of the standard epoch (which started at
     * 1970-01-01T00:00:00 UTC). Specify the start time of the custom epoch, in YYYY-MM-DDTHH:MM:SS in UTC. The time
     * must be 2000-01-01T00:00:00 or later. Always set the MM:SS portion to 00:00.
     * 
     * @return Optional. Enter a value here to use a custom epoch, instead of the standard epoch (which started at
     *         1970-01-01T00:00:00 UTC). Specify the start time of the custom epoch, in YYYY-MM-DDTHH:MM:SS in UTC. The
     *         time must be 2000-01-01T00:00:00 or later. Always set the MM:SS portion to 00:00.
     */
    public final String customEpoch() {
        return customEpoch;
    }

    /**
     * Optional. Enter a time for the jam sync. The default is midnight UTC. When epoch locking is enabled, MediaLive
     * performs a daily jam sync on every output encode to ensure timecodes don’t diverge from the wall clock. The jam
     * sync applies only to encodes with frame rate of 29.97 or 59.94 FPS. To override, enter a time in HH:MM:SS in UTC.
     * Always set the MM:SS portion to 00:00.
     * 
     * @return Optional. Enter a time for the jam sync. The default is midnight UTC. When epoch locking is enabled,
     *         MediaLive performs a daily jam sync on every output encode to ensure timecodes don’t diverge from the
     *         wall clock. The jam sync applies only to encodes with frame rate of 29.97 or 59.94 FPS. To override,
     *         enter a time in HH:MM:SS in UTC. Always set the MM:SS portion to 00:00.
     */
    public final String jamSyncTime() {
        return jamSyncTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customEpoch());
        hashCode = 31 * hashCode + Objects.hashCode(jamSyncTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EpochLockingSettings)) {
            return false;
        }
        EpochLockingSettings other = (EpochLockingSettings) obj;
        return Objects.equals(customEpoch(), other.customEpoch()) && Objects.equals(jamSyncTime(), other.jamSyncTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EpochLockingSettings").add("CustomEpoch", customEpoch()).add("JamSyncTime", jamSyncTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomEpoch":
            return Optional.ofNullable(clazz.cast(customEpoch()));
        case "JamSyncTime":
            return Optional.ofNullable(clazz.cast(jamSyncTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EpochLockingSettings, T> g) {
        return obj -> g.apply((EpochLockingSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EpochLockingSettings> {
        /**
         * Optional. Enter a value here to use a custom epoch, instead of the standard epoch (which started at
         * 1970-01-01T00:00:00 UTC). Specify the start time of the custom epoch, in YYYY-MM-DDTHH:MM:SS in UTC. The time
         * must be 2000-01-01T00:00:00 or later. Always set the MM:SS portion to 00:00.
         * 
         * @param customEpoch
         *        Optional. Enter a value here to use a custom epoch, instead of the standard epoch (which started at
         *        1970-01-01T00:00:00 UTC). Specify the start time of the custom epoch, in YYYY-MM-DDTHH:MM:SS in UTC.
         *        The time must be 2000-01-01T00:00:00 or later. Always set the MM:SS portion to 00:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEpoch(String customEpoch);

        /**
         * Optional. Enter a time for the jam sync. The default is midnight UTC. When epoch locking is enabled,
         * MediaLive performs a daily jam sync on every output encode to ensure timecodes don’t diverge from the wall
         * clock. The jam sync applies only to encodes with frame rate of 29.97 or 59.94 FPS. To override, enter a time
         * in HH:MM:SS in UTC. Always set the MM:SS portion to 00:00.
         * 
         * @param jamSyncTime
         *        Optional. Enter a time for the jam sync. The default is midnight UTC. When epoch locking is enabled,
         *        MediaLive performs a daily jam sync on every output encode to ensure timecodes don’t diverge from the
         *        wall clock. The jam sync applies only to encodes with frame rate of 29.97 or 59.94 FPS. To override,
         *        enter a time in HH:MM:SS in UTC. Always set the MM:SS portion to 00:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jamSyncTime(String jamSyncTime);
    }

    static final class BuilderImpl implements Builder {
        private String customEpoch;

        private String jamSyncTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EpochLockingSettings model) {
            customEpoch(model.customEpoch);
            jamSyncTime(model.jamSyncTime);
        }

        public final String getCustomEpoch() {
            return customEpoch;
        }

        public final void setCustomEpoch(String customEpoch) {
            this.customEpoch = customEpoch;
        }

        @Override
        public final Builder customEpoch(String customEpoch) {
            this.customEpoch = customEpoch;
            return this;
        }

        public final String getJamSyncTime() {
            return jamSyncTime;
        }

        public final void setJamSyncTime(String jamSyncTime) {
            this.jamSyncTime = jamSyncTime;
        }

        @Override
        public final Builder jamSyncTime(String jamSyncTime) {
            this.jamSyncTime = jamSyncTime;
            return this;
        }

        @Override
        public EpochLockingSettings build() {
            return new EpochLockingSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
