/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeInputDeviceResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInputDeviceResponse extends MediaLiveResponse implements
        ToCopyableBuilder<DescribeInputDeviceResponse.Builder, DescribeInputDeviceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeInputDeviceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionState").getter(getter(DescribeInputDeviceResponse::connectionStateAsString))
            .setter(setter(Builder::connectionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()).build();

    private static final SdkField<String> DEVICE_SETTINGS_SYNC_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceSettingsSyncState").getter(getter(DescribeInputDeviceResponse::deviceSettingsSyncStateAsString))
            .setter(setter(Builder::deviceSettingsSyncState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceSettingsSyncState").build())
            .build();

    private static final SdkField<String> DEVICE_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceUpdateStatus").getter(getter(DescribeInputDeviceResponse::deviceUpdateStatusAsString))
            .setter(setter(Builder::deviceUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceUpdateStatus").build())
            .build();

    private static final SdkField<InputDeviceHdSettings> HD_DEVICE_SETTINGS_FIELD = SdkField
            .<InputDeviceHdSettings> builder(MarshallingType.SDK_POJO).memberName("HdDeviceSettings")
            .getter(getter(DescribeInputDeviceResponse::hdDeviceSettings)).setter(setter(Builder::hdDeviceSettings))
            .constructor(InputDeviceHdSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdDeviceSettings").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeInputDeviceResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MacAddress").getter(getter(DescribeInputDeviceResponse::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeInputDeviceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<InputDeviceNetworkSettings> NETWORK_SETTINGS_FIELD = SdkField
            .<InputDeviceNetworkSettings> builder(MarshallingType.SDK_POJO).memberName("NetworkSettings")
            .getter(getter(DescribeInputDeviceResponse::networkSettings)).setter(setter(Builder::networkSettings))
            .constructor(InputDeviceNetworkSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettings").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(DescribeInputDeviceResponse::serialNumber))
            .setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeInputDeviceResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<InputDeviceUhdSettings> UHD_DEVICE_SETTINGS_FIELD = SdkField
            .<InputDeviceUhdSettings> builder(MarshallingType.SDK_POJO).memberName("UhdDeviceSettings")
            .getter(getter(DescribeInputDeviceResponse::uhdDeviceSettings)).setter(setter(Builder::uhdDeviceSettings))
            .constructor(InputDeviceUhdSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uhdDeviceSettings").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeInputDeviceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(DescribeInputDeviceResponse::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<List<String>> MEDIALIVE_INPUT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MedialiveInputArns")
            .getter(getter(DescribeInputDeviceResponse::medialiveInputArns))
            .setter(setter(Builder::medialiveInputArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("medialiveInputArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputType").getter(getter(DescribeInputDeviceResponse::outputTypeAsString))
            .setter(setter(Builder::outputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONNECTION_STATE_FIELD, DEVICE_SETTINGS_SYNC_STATE_FIELD, DEVICE_UPDATE_STATUS_FIELD, HD_DEVICE_SETTINGS_FIELD,
            ID_FIELD, MAC_ADDRESS_FIELD, NAME_FIELD, NETWORK_SETTINGS_FIELD, SERIAL_NUMBER_FIELD, TYPE_FIELD,
            UHD_DEVICE_SETTINGS_FIELD, TAGS_FIELD, AVAILABILITY_ZONE_FIELD, MEDIALIVE_INPUT_ARNS_FIELD, OUTPUT_TYPE_FIELD));

    private final String arn;

    private final String connectionState;

    private final String deviceSettingsSyncState;

    private final String deviceUpdateStatus;

    private final InputDeviceHdSettings hdDeviceSettings;

    private final String id;

    private final String macAddress;

    private final String name;

    private final InputDeviceNetworkSettings networkSettings;

    private final String serialNumber;

    private final String type;

    private final InputDeviceUhdSettings uhdDeviceSettings;

    private final Map<String, String> tags;

    private final String availabilityZone;

    private final List<String> medialiveInputArns;

    private final String outputType;

    private DescribeInputDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.connectionState = builder.connectionState;
        this.deviceSettingsSyncState = builder.deviceSettingsSyncState;
        this.deviceUpdateStatus = builder.deviceUpdateStatus;
        this.hdDeviceSettings = builder.hdDeviceSettings;
        this.id = builder.id;
        this.macAddress = builder.macAddress;
        this.name = builder.name;
        this.networkSettings = builder.networkSettings;
        this.serialNumber = builder.serialNumber;
        this.type = builder.type;
        this.uhdDeviceSettings = builder.uhdDeviceSettings;
        this.tags = builder.tags;
        this.availabilityZone = builder.availabilityZone;
        this.medialiveInputArns = builder.medialiveInputArns;
        this.outputType = builder.outputType;
    }

    /**
     * The unique ARN of the input device.
     * 
     * @return The unique ARN of the input device.
     */
    public final String arn() {
        return arn;
    }

    /**
     * The state of the connection between the input device and AWS.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link InputDeviceConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection between the input device and AWS.
     * @see InputDeviceConnectionState
     */
    public final InputDeviceConnectionState connectionState() {
        return InputDeviceConnectionState.fromValue(connectionState);
    }

    /**
     * The state of the connection between the input device and AWS.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link InputDeviceConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection between the input device and AWS.
     * @see InputDeviceConnectionState
     */
    public final String connectionStateAsString() {
        return connectionState;
    }

    /**
     * The status of the action to synchronize the device configuration. If you change the configuration of the input
     * device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not
     * update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not
     * updated its configuration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceSettingsSyncState} will return {@link DeviceSettingsSyncState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceSettingsSyncStateAsString}.
     * </p>
     * 
     * @return The status of the action to synchronize the device configuration. If you change the configuration of the
     *         input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device
     *         might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means
     *         that it has not updated its configuration.
     * @see DeviceSettingsSyncState
     */
    public final DeviceSettingsSyncState deviceSettingsSyncState() {
        return DeviceSettingsSyncState.fromValue(deviceSettingsSyncState);
    }

    /**
     * The status of the action to synchronize the device configuration. If you change the configuration of the input
     * device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not
     * update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not
     * updated its configuration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceSettingsSyncState} will return {@link DeviceSettingsSyncState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceSettingsSyncStateAsString}.
     * </p>
     * 
     * @return The status of the action to synchronize the device configuration. If you change the configuration of the
     *         input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device
     *         might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means
     *         that it has not updated its configuration.
     * @see DeviceSettingsSyncState
     */
    public final String deviceSettingsSyncStateAsString() {
        return deviceSettingsSyncState;
    }

    /**
     * The status of software on the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceUpdateStatus} will return {@link DeviceUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deviceUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of software on the input device.
     * @see DeviceUpdateStatus
     */
    public final DeviceUpdateStatus deviceUpdateStatus() {
        return DeviceUpdateStatus.fromValue(deviceUpdateStatus);
    }

    /**
     * The status of software on the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceUpdateStatus} will return {@link DeviceUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deviceUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of software on the input device.
     * @see DeviceUpdateStatus
     */
    public final String deviceUpdateStatusAsString() {
        return deviceUpdateStatus;
    }

    /**
     * Settings that describe an input device that is type HD.
     * 
     * @return Settings that describe an input device that is type HD.
     */
    public final InputDeviceHdSettings hdDeviceSettings() {
        return hdDeviceSettings;
    }

    /**
     * The unique ID of the input device.
     * 
     * @return The unique ID of the input device.
     */
    public final String id() {
        return id;
    }

    /**
     * The network MAC address of the input device.
     * 
     * @return The network MAC address of the input device.
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * A name that you specify for the input device.
     * 
     * @return A name that you specify for the input device.
     */
    public final String name() {
        return name;
    }

    /**
     * The network settings for the input device.
     * 
     * @return The network settings for the input device.
     */
    public final InputDeviceNetworkSettings networkSettings() {
        return networkSettings;
    }

    /**
     * The unique serial number of the input device.
     * 
     * @return The unique serial number of the input device.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * The type of the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InputDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the input device.
     * @see InputDeviceType
     */
    public final InputDeviceType type() {
        return InputDeviceType.fromValue(type);
    }

    /**
     * The type of the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InputDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the input device.
     * @see InputDeviceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Settings that describe an input device that is type UHD.
     * 
     * @return Settings that describe an input device that is type UHD.
     */
    public final InputDeviceUhdSettings uhdDeviceSettings() {
        return uhdDeviceSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * The Availability Zone associated with this input device.
     * 
     * @return The Availability Zone associated with this input device.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the MedialiveInputArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMedialiveInputArns() {
        return medialiveInputArns != null && !(medialiveInputArns instanceof SdkAutoConstructList);
    }

    /**
     * An array of the ARNs for the MediaLive inputs attached to the device. Returned only if the outputType is
     * MEDIALIVE_INPUT.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMedialiveInputArns} method.
     * </p>
     * 
     * @return An array of the ARNs for the MediaLive inputs attached to the device. Returned only if the outputType is
     *         MEDIALIVE_INPUT.
     */
    public final List<String> medialiveInputArns() {
        return medialiveInputArns;
    }

    /**
     * The output attachment type of the input device. Specifies MEDIACONNECT_FLOW if this device is the source for a
     * MediaConnect flow. Specifies MEDIALIVE_INPUT if this device is the source for a MediaLive input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link InputDeviceOutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputTypeAsString}.
     * </p>
     * 
     * @return The output attachment type of the input device. Specifies MEDIACONNECT_FLOW if this device is the source
     *         for a MediaConnect flow. Specifies MEDIALIVE_INPUT if this device is the source for a MediaLive input.
     * @see InputDeviceOutputType
     */
    public final InputDeviceOutputType outputType() {
        return InputDeviceOutputType.fromValue(outputType);
    }

    /**
     * The output attachment type of the input device. Specifies MEDIACONNECT_FLOW if this device is the source for a
     * MediaConnect flow. Specifies MEDIALIVE_INPUT if this device is the source for a MediaLive input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link InputDeviceOutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputTypeAsString}.
     * </p>
     * 
     * @return The output attachment type of the input device. Specifies MEDIACONNECT_FLOW if this device is the source
     *         for a MediaConnect flow. Specifies MEDIALIVE_INPUT if this device is the source for a MediaLive input.
     * @see InputDeviceOutputType
     */
    public final String outputTypeAsString() {
        return outputType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceSettingsSyncStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hdDeviceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkSettings());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uhdDeviceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasMedialiveInputArns() ? medialiveInputArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInputDeviceResponse)) {
            return false;
        }
        DescribeInputDeviceResponse other = (DescribeInputDeviceResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(connectionStateAsString(), other.connectionStateAsString())
                && Objects.equals(deviceSettingsSyncStateAsString(), other.deviceSettingsSyncStateAsString())
                && Objects.equals(deviceUpdateStatusAsString(), other.deviceUpdateStatusAsString())
                && Objects.equals(hdDeviceSettings(), other.hdDeviceSettings()) && Objects.equals(id(), other.id())
                && Objects.equals(macAddress(), other.macAddress()) && Objects.equals(name(), other.name())
                && Objects.equals(networkSettings(), other.networkSettings())
                && Objects.equals(serialNumber(), other.serialNumber()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(uhdDeviceSettings(), other.uhdDeviceSettings()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && hasMedialiveInputArns() == other.hasMedialiveInputArns()
                && Objects.equals(medialiveInputArns(), other.medialiveInputArns())
                && Objects.equals(outputTypeAsString(), other.outputTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInputDeviceResponse").add("Arn", arn())
                .add("ConnectionState", connectionStateAsString())
                .add("DeviceSettingsSyncState", deviceSettingsSyncStateAsString())
                .add("DeviceUpdateStatus", deviceUpdateStatusAsString()).add("HdDeviceSettings", hdDeviceSettings())
                .add("Id", id()).add("MacAddress", macAddress()).add("Name", name()).add("NetworkSettings", networkSettings())
                .add("SerialNumber", serialNumber()).add("Type", typeAsString()).add("UhdDeviceSettings", uhdDeviceSettings())
                .add("Tags", hasTags() ? tags() : null).add("AvailabilityZone", availabilityZone())
                .add("MedialiveInputArns", hasMedialiveInputArns() ? medialiveInputArns() : null)
                .add("OutputType", outputTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ConnectionState":
            return Optional.ofNullable(clazz.cast(connectionStateAsString()));
        case "DeviceSettingsSyncState":
            return Optional.ofNullable(clazz.cast(deviceSettingsSyncStateAsString()));
        case "DeviceUpdateStatus":
            return Optional.ofNullable(clazz.cast(deviceUpdateStatusAsString()));
        case "HdDeviceSettings":
            return Optional.ofNullable(clazz.cast(hdDeviceSettings()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkSettings":
            return Optional.ofNullable(clazz.cast(networkSettings()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "UhdDeviceSettings":
            return Optional.ofNullable(clazz.cast(uhdDeviceSettings()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "MedialiveInputArns":
            return Optional.ofNullable(clazz.cast(medialiveInputArns()));
        case "OutputType":
            return Optional.ofNullable(clazz.cast(outputTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInputDeviceResponse, T> g) {
        return obj -> g.apply((DescribeInputDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInputDeviceResponse> {
        /**
         * The unique ARN of the input device.
         * 
         * @param arn
         *        The unique ARN of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The state of the connection between the input device and AWS.
         * 
         * @param connectionState
         *        The state of the connection between the input device and AWS.
         * @see InputDeviceConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConnectionState
         */
        Builder connectionState(String connectionState);

        /**
         * The state of the connection between the input device and AWS.
         * 
         * @param connectionState
         *        The state of the connection between the input device and AWS.
         * @see InputDeviceConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConnectionState
         */
        Builder connectionState(InputDeviceConnectionState connectionState);

        /**
         * The status of the action to synchronize the device configuration. If you change the configuration of the
         * input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might
         * not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it
         * has not updated its configuration.
         * 
         * @param deviceSettingsSyncState
         *        The status of the action to synchronize the device configuration. If you change the configuration of
         *        the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The
         *        device might not update itself immediately. SYNCED means the device has updated its configuration.
         *        SYNCING means that it has not updated its configuration.
         * @see DeviceSettingsSyncState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceSettingsSyncState
         */
        Builder deviceSettingsSyncState(String deviceSettingsSyncState);

        /**
         * The status of the action to synchronize the device configuration. If you change the configuration of the
         * input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might
         * not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it
         * has not updated its configuration.
         * 
         * @param deviceSettingsSyncState
         *        The status of the action to synchronize the device configuration. If you change the configuration of
         *        the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The
         *        device might not update itself immediately. SYNCED means the device has updated its configuration.
         *        SYNCING means that it has not updated its configuration.
         * @see DeviceSettingsSyncState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceSettingsSyncState
         */
        Builder deviceSettingsSyncState(DeviceSettingsSyncState deviceSettingsSyncState);

        /**
         * The status of software on the input device.
         * 
         * @param deviceUpdateStatus
         *        The status of software on the input device.
         * @see DeviceUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceUpdateStatus
         */
        Builder deviceUpdateStatus(String deviceUpdateStatus);

        /**
         * The status of software on the input device.
         * 
         * @param deviceUpdateStatus
         *        The status of software on the input device.
         * @see DeviceUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceUpdateStatus
         */
        Builder deviceUpdateStatus(DeviceUpdateStatus deviceUpdateStatus);

        /**
         * Settings that describe an input device that is type HD.
         * 
         * @param hdDeviceSettings
         *        Settings that describe an input device that is type HD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hdDeviceSettings(InputDeviceHdSettings hdDeviceSettings);

        /**
         * Settings that describe an input device that is type HD. This is a convenience method that creates an instance
         * of the {@link InputDeviceHdSettings.Builder} avoiding the need to create one manually via
         * {@link InputDeviceHdSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDeviceHdSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #hdDeviceSettings(InputDeviceHdSettings)}.
         * 
         * @param hdDeviceSettings
         *        a consumer that will call methods on {@link InputDeviceHdSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hdDeviceSettings(InputDeviceHdSettings)
         */
        default Builder hdDeviceSettings(Consumer<InputDeviceHdSettings.Builder> hdDeviceSettings) {
            return hdDeviceSettings(InputDeviceHdSettings.builder().applyMutation(hdDeviceSettings).build());
        }

        /**
         * The unique ID of the input device.
         * 
         * @param id
         *        The unique ID of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The network MAC address of the input device.
         * 
         * @param macAddress
         *        The network MAC address of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * A name that you specify for the input device.
         * 
         * @param name
         *        A name that you specify for the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The network settings for the input device.
         * 
         * @param networkSettings
         *        The network settings for the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettings(InputDeviceNetworkSettings networkSettings);

        /**
         * The network settings for the input device. This is a convenience method that creates an instance of the
         * {@link InputDeviceNetworkSettings.Builder} avoiding the need to create one manually via
         * {@link InputDeviceNetworkSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDeviceNetworkSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #networkSettings(InputDeviceNetworkSettings)}.
         * 
         * @param networkSettings
         *        a consumer that will call methods on {@link InputDeviceNetworkSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSettings(InputDeviceNetworkSettings)
         */
        default Builder networkSettings(Consumer<InputDeviceNetworkSettings.Builder> networkSettings) {
            return networkSettings(InputDeviceNetworkSettings.builder().applyMutation(networkSettings).build());
        }

        /**
         * The unique serial number of the input device.
         * 
         * @param serialNumber
         *        The unique serial number of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * The type of the input device.
         * 
         * @param type
         *        The type of the input device.
         * @see InputDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceType
         */
        Builder type(String type);

        /**
         * The type of the input device.
         * 
         * @param type
         *        The type of the input device.
         * @see InputDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceType
         */
        Builder type(InputDeviceType type);

        /**
         * Settings that describe an input device that is type UHD.
         * 
         * @param uhdDeviceSettings
         *        Settings that describe an input device that is type UHD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uhdDeviceSettings(InputDeviceUhdSettings uhdDeviceSettings);

        /**
         * Settings that describe an input device that is type UHD. This is a convenience method that creates an
         * instance of the {@link InputDeviceUhdSettings.Builder} avoiding the need to create one manually via
         * {@link InputDeviceUhdSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDeviceUhdSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #uhdDeviceSettings(InputDeviceUhdSettings)}.
         * 
         * @param uhdDeviceSettings
         *        a consumer that will call methods on {@link InputDeviceUhdSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uhdDeviceSettings(InputDeviceUhdSettings)
         */
        default Builder uhdDeviceSettings(Consumer<InputDeviceUhdSettings.Builder> uhdDeviceSettings) {
            return uhdDeviceSettings(InputDeviceUhdSettings.builder().applyMutation(uhdDeviceSettings).build());
        }

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * The Availability Zone associated with this input device.
         * 
         * @param availabilityZone
         *        The Availability Zone associated with this input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * An array of the ARNs for the MediaLive inputs attached to the device. Returned only if the outputType is
         * MEDIALIVE_INPUT.
         * 
         * @param medialiveInputArns
         *        An array of the ARNs for the MediaLive inputs attached to the device. Returned only if the outputType
         *        is MEDIALIVE_INPUT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medialiveInputArns(Collection<String> medialiveInputArns);

        /**
         * An array of the ARNs for the MediaLive inputs attached to the device. Returned only if the outputType is
         * MEDIALIVE_INPUT.
         * 
         * @param medialiveInputArns
         *        An array of the ARNs for the MediaLive inputs attached to the device. Returned only if the outputType
         *        is MEDIALIVE_INPUT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medialiveInputArns(String... medialiveInputArns);

        /**
         * The output attachment type of the input device. Specifies MEDIACONNECT_FLOW if this device is the source for
         * a MediaConnect flow. Specifies MEDIALIVE_INPUT if this device is the source for a MediaLive input.
         * 
         * @param outputType
         *        The output attachment type of the input device. Specifies MEDIACONNECT_FLOW if this device is the
         *        source for a MediaConnect flow. Specifies MEDIALIVE_INPUT if this device is the source for a MediaLive
         *        input.
         * @see InputDeviceOutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceOutputType
         */
        Builder outputType(String outputType);

        /**
         * The output attachment type of the input device. Specifies MEDIACONNECT_FLOW if this device is the source for
         * a MediaConnect flow. Specifies MEDIALIVE_INPUT if this device is the source for a MediaLive input.
         * 
         * @param outputType
         *        The output attachment type of the input device. Specifies MEDIACONNECT_FLOW if this device is the
         *        source for a MediaConnect flow. Specifies MEDIALIVE_INPUT if this device is the source for a MediaLive
         *        input.
         * @see InputDeviceOutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceOutputType
         */
        Builder outputType(InputDeviceOutputType outputType);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private String connectionState;

        private String deviceSettingsSyncState;

        private String deviceUpdateStatus;

        private InputDeviceHdSettings hdDeviceSettings;

        private String id;

        private String macAddress;

        private String name;

        private InputDeviceNetworkSettings networkSettings;

        private String serialNumber;

        private String type;

        private InputDeviceUhdSettings uhdDeviceSettings;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String availabilityZone;

        private List<String> medialiveInputArns = DefaultSdkAutoConstructList.getInstance();

        private String outputType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInputDeviceResponse model) {
            super(model);
            arn(model.arn);
            connectionState(model.connectionState);
            deviceSettingsSyncState(model.deviceSettingsSyncState);
            deviceUpdateStatus(model.deviceUpdateStatus);
            hdDeviceSettings(model.hdDeviceSettings);
            id(model.id);
            macAddress(model.macAddress);
            name(model.name);
            networkSettings(model.networkSettings);
            serialNumber(model.serialNumber);
            type(model.type);
            uhdDeviceSettings(model.uhdDeviceSettings);
            tags(model.tags);
            availabilityZone(model.availabilityZone);
            medialiveInputArns(model.medialiveInputArns);
            outputType(model.outputType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConnectionState() {
            return connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(InputDeviceConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final String getDeviceSettingsSyncState() {
            return deviceSettingsSyncState;
        }

        public final void setDeviceSettingsSyncState(String deviceSettingsSyncState) {
            this.deviceSettingsSyncState = deviceSettingsSyncState;
        }

        @Override
        public final Builder deviceSettingsSyncState(String deviceSettingsSyncState) {
            this.deviceSettingsSyncState = deviceSettingsSyncState;
            return this;
        }

        @Override
        public final Builder deviceSettingsSyncState(DeviceSettingsSyncState deviceSettingsSyncState) {
            this.deviceSettingsSyncState(deviceSettingsSyncState == null ? null : deviceSettingsSyncState.toString());
            return this;
        }

        public final String getDeviceUpdateStatus() {
            return deviceUpdateStatus;
        }

        public final void setDeviceUpdateStatus(String deviceUpdateStatus) {
            this.deviceUpdateStatus = deviceUpdateStatus;
        }

        @Override
        public final Builder deviceUpdateStatus(String deviceUpdateStatus) {
            this.deviceUpdateStatus = deviceUpdateStatus;
            return this;
        }

        @Override
        public final Builder deviceUpdateStatus(DeviceUpdateStatus deviceUpdateStatus) {
            this.deviceUpdateStatus(deviceUpdateStatus == null ? null : deviceUpdateStatus.toString());
            return this;
        }

        public final InputDeviceHdSettings.Builder getHdDeviceSettings() {
            return hdDeviceSettings != null ? hdDeviceSettings.toBuilder() : null;
        }

        public final void setHdDeviceSettings(InputDeviceHdSettings.BuilderImpl hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings != null ? hdDeviceSettings.build() : null;
        }

        @Override
        public final Builder hdDeviceSettings(InputDeviceHdSettings hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final InputDeviceNetworkSettings.Builder getNetworkSettings() {
            return networkSettings != null ? networkSettings.toBuilder() : null;
        }

        public final void setNetworkSettings(InputDeviceNetworkSettings.BuilderImpl networkSettings) {
            this.networkSettings = networkSettings != null ? networkSettings.build() : null;
        }

        @Override
        public final Builder networkSettings(InputDeviceNetworkSettings networkSettings) {
            this.networkSettings = networkSettings;
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputDeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final InputDeviceUhdSettings.Builder getUhdDeviceSettings() {
            return uhdDeviceSettings != null ? uhdDeviceSettings.toBuilder() : null;
        }

        public final void setUhdDeviceSettings(InputDeviceUhdSettings.BuilderImpl uhdDeviceSettings) {
            this.uhdDeviceSettings = uhdDeviceSettings != null ? uhdDeviceSettings.build() : null;
        }

        @Override
        public final Builder uhdDeviceSettings(InputDeviceUhdSettings uhdDeviceSettings) {
            this.uhdDeviceSettings = uhdDeviceSettings;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Collection<String> getMedialiveInputArns() {
            if (medialiveInputArns instanceof SdkAutoConstructList) {
                return null;
            }
            return medialiveInputArns;
        }

        public final void setMedialiveInputArns(Collection<String> medialiveInputArns) {
            this.medialiveInputArns = ___listOf__stringCopier.copy(medialiveInputArns);
        }

        @Override
        public final Builder medialiveInputArns(Collection<String> medialiveInputArns) {
            this.medialiveInputArns = ___listOf__stringCopier.copy(medialiveInputArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medialiveInputArns(String... medialiveInputArns) {
            medialiveInputArns(Arrays.asList(medialiveInputArns));
            return this;
        }

        public final String getOutputType() {
            return outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(InputDeviceOutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        @Override
        public DescribeInputDeviceResponse build() {
            return new DescribeInputDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
