/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Archive Cdn Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveCdnSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ArchiveCdnSettings.Builder, ArchiveCdnSettings> {
    private static final SdkField<ArchiveS3Settings> ARCHIVE_S3_SETTINGS_FIELD = SdkField
            .<ArchiveS3Settings> builder(MarshallingType.SDK_POJO).memberName("ArchiveS3Settings")
            .getter(getter(ArchiveCdnSettings::archiveS3Settings)).setter(setter(Builder::archiveS3Settings))
            .constructor(ArchiveS3Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveS3Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_S3_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ArchiveS3Settings archiveS3Settings;

    private ArchiveCdnSettings(BuilderImpl builder) {
        this.archiveS3Settings = builder.archiveS3Settings;
    }

    /**
     * Returns the value of the ArchiveS3Settings property for this object.
     * 
     * @return The value of the ArchiveS3Settings property for this object.
     */
    public final ArchiveS3Settings archiveS3Settings() {
        return archiveS3Settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(archiveS3Settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveCdnSettings)) {
            return false;
        }
        ArchiveCdnSettings other = (ArchiveCdnSettings) obj;
        return Objects.equals(archiveS3Settings(), other.archiveS3Settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveCdnSettings").add("ArchiveS3Settings", archiveS3Settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveS3Settings":
            return Optional.ofNullable(clazz.cast(archiveS3Settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveCdnSettings, T> g) {
        return obj -> g.apply((ArchiveCdnSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveCdnSettings> {
        /**
         * Sets the value of the ArchiveS3Settings property for this object.
         *
         * @param archiveS3Settings
         *        The new value for the ArchiveS3Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveS3Settings(ArchiveS3Settings archiveS3Settings);

        /**
         * Sets the value of the ArchiveS3Settings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ArchiveS3Settings.Builder} avoiding the
         * need to create one manually via {@link ArchiveS3Settings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveS3Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #archiveS3Settings(ArchiveS3Settings)}.
         * 
         * @param archiveS3Settings
         *        a consumer that will call methods on {@link ArchiveS3Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archiveS3Settings(ArchiveS3Settings)
         */
        default Builder archiveS3Settings(Consumer<ArchiveS3Settings.Builder> archiveS3Settings) {
            return archiveS3Settings(ArchiveS3Settings.builder().applyMutation(archiveS3Settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ArchiveS3Settings archiveS3Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveCdnSettings model) {
            archiveS3Settings(model.archiveS3Settings);
        }

        public final ArchiveS3Settings.Builder getArchiveS3Settings() {
            return archiveS3Settings != null ? archiveS3Settings.toBuilder() : null;
        }

        public final void setArchiveS3Settings(ArchiveS3Settings.BuilderImpl archiveS3Settings) {
            this.archiveS3Settings = archiveS3Settings != null ? archiveS3Settings.build() : null;
        }

        @Override
        public final Builder archiveS3Settings(ArchiveS3Settings archiveS3Settings) {
            this.archiveS3Settings = archiveS3Settings;
            return this;
        }

        @Override
        public ArchiveCdnSettings build() {
            return new ArchiveCdnSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
