/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Choose the scan line type for the output. Keep the default value, Progressive to create a progressive output,
 * regardless of the scan type of your input. Use Top field first or Bottom field first to create an output that's
 * interlaced with the same field polarity throughout. Use Follow, default top or Follow, default bottom to produce
 * outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity
 * might change over the course of the output. Follow behavior depends on the input scan type. If the source is
 * interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the
 * output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
 */
@Generated("software.amazon.awssdk:codegen")
public enum XavcInterlaceMode {
    PROGRESSIVE("PROGRESSIVE"),

    TOP_FIELD("TOP_FIELD"),

    BOTTOM_FIELD("BOTTOM_FIELD"),

    FOLLOW_TOP_FIELD("FOLLOW_TOP_FIELD"),

    FOLLOW_BOTTOM_FIELD("FOLLOW_BOTTOM_FIELD"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, XavcInterlaceMode> VALUE_MAP = EnumUtils.uniqueIndex(XavcInterlaceMode.class,
            XavcInterlaceMode::toString);

    private final String value;

    private XavcInterlaceMode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return XavcInterlaceMode corresponding to the value
     */
    public static XavcInterlaceMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link XavcInterlaceMode}s
     */
    public static Set<XavcInterlaceMode> knownValues() {
        Set<XavcInterlaceMode> knownValues = EnumSet.allOf(XavcInterlaceMode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
