/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set Codec, under AudioDescriptions>CodecSettings, to the value Vorbis.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VorbisSettings implements SdkPojo, Serializable, ToCopyableBuilder<VorbisSettings.Builder, VorbisSettings> {
    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Channels").getter(getter(VorbisSettings::channels)).setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()).build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleRate").getter(getter(VorbisSettings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final SdkField<Integer> VBR_QUALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VbrQuality").getter(getter(VorbisSettings::vbrQuality)).setter(setter(Builder::vbrQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vbrQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD,
            SAMPLE_RATE_FIELD, VBR_QUALITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer channels;

    private final Integer sampleRate;

    private final Integer vbrQuality;

    private VorbisSettings(BuilderImpl builder) {
        this.channels = builder.channels;
        this.sampleRate = builder.sampleRate;
        this.vbrQuality = builder.vbrQuality;
    }

    /**
     * Optional. Specify the number of channels in this output audio track. Choosing Mono on the console gives you 1
     * output channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2. The default value is 2.
     * 
     * @return Optional. Specify the number of channels in this output audio track. Choosing Mono on the console gives
     *         you 1 output channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2. The default
     *         value is 2.
     */
    public final Integer channels() {
        return channels;
    }

    /**
     * Optional. Specify the audio sample rate in Hz. Valid values are 22050, 32000, 44100, and 48000. The default value
     * is 48000.
     * 
     * @return Optional. Specify the audio sample rate in Hz. Valid values are 22050, 32000, 44100, and 48000. The
     *         default value is 48000.
     */
    public final Integer sampleRate() {
        return sampleRate;
    }

    /**
     * Optional. Specify the variable audio quality of this Vorbis output from -1 (lowest quality, ~45 kbit/s) to 10
     * (highest quality, ~500 kbit/s). The default value is 4 (~128 kbit/s). Values 5 and 6 are approximately 160 and
     * 192 kbit/s, respectively.
     * 
     * @return Optional. Specify the variable audio quality of this Vorbis output from -1 (lowest quality, ~45 kbit/s)
     *         to 10 (highest quality, ~500 kbit/s). The default value is 4 (~128 kbit/s). Values 5 and 6 are
     *         approximately 160 and 192 kbit/s, respectively.
     */
    public final Integer vbrQuality() {
        return vbrQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channels());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(vbrQuality());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VorbisSettings)) {
            return false;
        }
        VorbisSettings other = (VorbisSettings) obj;
        return Objects.equals(channels(), other.channels()) && Objects.equals(sampleRate(), other.sampleRate())
                && Objects.equals(vbrQuality(), other.vbrQuality());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VorbisSettings").add("Channels", channels()).add("SampleRate", sampleRate())
                .add("VbrQuality", vbrQuality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        case "VbrQuality":
            return Optional.ofNullable(clazz.cast(vbrQuality()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VorbisSettings, T> g) {
        return obj -> g.apply((VorbisSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VorbisSettings> {
        /**
         * Optional. Specify the number of channels in this output audio track. Choosing Mono on the console gives you 1
         * output channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2. The default value is 2.
         * 
         * @param channels
         *        Optional. Specify the number of channels in this output audio track. Choosing Mono on the console
         *        gives you 1 output channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2. The
         *        default value is 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Integer channels);

        /**
         * Optional. Specify the audio sample rate in Hz. Valid values are 22050, 32000, 44100, and 48000. The default
         * value is 48000.
         * 
         * @param sampleRate
         *        Optional. Specify the audio sample rate in Hz. Valid values are 22050, 32000, 44100, and 48000. The
         *        default value is 48000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);

        /**
         * Optional. Specify the variable audio quality of this Vorbis output from -1 (lowest quality, ~45 kbit/s) to 10
         * (highest quality, ~500 kbit/s). The default value is 4 (~128 kbit/s). Values 5 and 6 are approximately 160
         * and 192 kbit/s, respectively.
         * 
         * @param vbrQuality
         *        Optional. Specify the variable audio quality of this Vorbis output from -1 (lowest quality, ~45
         *        kbit/s) to 10 (highest quality, ~500 kbit/s). The default value is 4 (~128 kbit/s). Values 5 and 6 are
         *        approximately 160 and 192 kbit/s, respectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vbrQuality(Integer vbrQuality);
    }

    static final class BuilderImpl implements Builder {
        private Integer channels;

        private Integer sampleRate;

        private Integer vbrQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(VorbisSettings model) {
            channels(model.channels);
            sampleRate(model.sampleRate);
            vbrQuality(model.vbrQuality);
        }

        public final Integer getChannels() {
            return channels;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final Integer getVbrQuality() {
            return vbrQuality;
        }

        public final void setVbrQuality(Integer vbrQuality) {
            this.vbrQuality = vbrQuality;
        }

        @Override
        public final Builder vbrQuality(Integer vbrQuality) {
            this.vbrQuality = vbrQuality;
            return this;
        }

        @Override
        public VorbisSettings build() {
            return new VorbisSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
