/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream workflow
 * requires that your DASH manifest use the Dolby channel configuration tag, rather than the MPEG one. For example, you
 * might need to use this to make dynamic ad insertion work. Specify which audio channel configuration scheme ID URI
 * MediaConvert writes in your DASH manifest. Keep the default value, MPEG channel configuration, to have MediaConvert
 * write this: urn:mpeg:mpegB:cicp:ChannelConfiguration. Choose Dolby channel configuration to have MediaConvert write
 * this instead: tag:dolby.com,2014:dash:audio_channel_configuration:2011.
 */
@Generated("software.amazon.awssdk:codegen")
public enum DashIsoGroupAudioChannelConfigSchemeIdUri {
    MPEG_CHANNEL_CONFIGURATION("MPEG_CHANNEL_CONFIGURATION"),

    DOLBY_CHANNEL_CONFIGURATION("DOLBY_CHANNEL_CONFIGURATION"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DashIsoGroupAudioChannelConfigSchemeIdUri> VALUE_MAP = EnumUtils.uniqueIndex(
            DashIsoGroupAudioChannelConfigSchemeIdUri.class, DashIsoGroupAudioChannelConfigSchemeIdUri::toString);

    private final String value;

    private DashIsoGroupAudioChannelConfigSchemeIdUri(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DashIsoGroupAudioChannelConfigSchemeIdUri corresponding to the value
     */
    public static DashIsoGroupAudioChannelConfigSchemeIdUri fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DashIsoGroupAudioChannelConfigSchemeIdUri}s
     */
    public static Set<DashIsoGroupAudioChannelConfigSchemeIdUri> knownValues() {
        Set<DashIsoGroupAudioChannelConfigSchemeIdUri> knownValues = EnumSet
                .allOf(DashIsoGroupAudioChannelConfigSchemeIdUri.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
