/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMediaStorageConfigurationRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<UpdateMediaStorageConfigurationRequest.Builder, UpdateMediaStorageConfigurationRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelARN").getter(getter(UpdateMediaStorageConfigurationRequest::channelARN))
            .setter(setter(Builder::channelARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()).build();

    private static final SdkField<MediaStorageConfiguration> MEDIA_STORAGE_CONFIGURATION_FIELD = SdkField
            .<MediaStorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("MediaStorageConfiguration")
            .getter(getter(UpdateMediaStorageConfigurationRequest::mediaStorageConfiguration))
            .setter(setter(Builder::mediaStorageConfiguration)).constructor(MediaStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStorageConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            MEDIA_STORAGE_CONFIGURATION_FIELD));

    private final String channelARN;

    private final MediaStorageConfiguration mediaStorageConfiguration;

    private UpdateMediaStorageConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.channelARN = builder.channelARN;
        this.mediaStorageConfiguration = builder.mediaStorageConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the channel.
     */
    public final String channelARN() {
        return channelARN;
    }

    /**
     * <p>
     * A structure that encapsulates, or contains, the media storage configuration properties.
     * </p>
     * 
     * @return A structure that encapsulates, or contains, the media storage configuration properties.
     */
    public final MediaStorageConfiguration mediaStorageConfiguration() {
        return mediaStorageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStorageConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMediaStorageConfigurationRequest)) {
            return false;
        }
        UpdateMediaStorageConfigurationRequest other = (UpdateMediaStorageConfigurationRequest) obj;
        return Objects.equals(channelARN(), other.channelARN())
                && Objects.equals(mediaStorageConfiguration(), other.mediaStorageConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMediaStorageConfigurationRequest").add("ChannelARN", channelARN())
                .add("MediaStorageConfiguration", mediaStorageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelARN":
            return Optional.ofNullable(clazz.cast(channelARN()));
        case "MediaStorageConfiguration":
            return Optional.ofNullable(clazz.cast(mediaStorageConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMediaStorageConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateMediaStorageConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMediaStorageConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the channel.
         * </p>
         * 
         * @param channelARN
         *        The Amazon Resource Name (ARN) of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelARN(String channelARN);

        /**
         * <p>
         * A structure that encapsulates, or contains, the media storage configuration properties.
         * </p>
         * 
         * @param mediaStorageConfiguration
         *        A structure that encapsulates, or contains, the media storage configuration properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStorageConfiguration(MediaStorageConfiguration mediaStorageConfiguration);

        /**
         * <p>
         * A structure that encapsulates, or contains, the media storage configuration properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaStorageConfiguration.Builder}
         * avoiding the need to create one manually via {@link MediaStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaStorageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaStorageConfiguration(MediaStorageConfiguration)}.
         * 
         * @param mediaStorageConfiguration
         *        a consumer that will call methods on {@link MediaStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStorageConfiguration(MediaStorageConfiguration)
         */
        default Builder mediaStorageConfiguration(Consumer<MediaStorageConfiguration.Builder> mediaStorageConfiguration) {
            return mediaStorageConfiguration(MediaStorageConfiguration.builder().applyMutation(mediaStorageConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String channelARN;

        private MediaStorageConfiguration mediaStorageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMediaStorageConfigurationRequest model) {
            super(model);
            channelARN(model.channelARN);
            mediaStorageConfiguration(model.mediaStorageConfiguration);
        }

        public final String getChannelARN() {
            return channelARN;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        @Override
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final MediaStorageConfiguration.Builder getMediaStorageConfiguration() {
            return mediaStorageConfiguration != null ? mediaStorageConfiguration.toBuilder() : null;
        }

        public final void setMediaStorageConfiguration(MediaStorageConfiguration.BuilderImpl mediaStorageConfiguration) {
            this.mediaStorageConfiguration = mediaStorageConfiguration != null ? mediaStorageConfiguration.build() : null;
        }

        @Override
        public final Builder mediaStorageConfiguration(MediaStorageConfiguration mediaStorageConfiguration) {
            this.mediaStorageConfiguration = mediaStorageConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMediaStorageConfigurationRequest build() {
            return new UpdateMediaStorageConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
