/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSignalingChannelEndpointRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<GetSignalingChannelEndpointRequest.Builder, GetSignalingChannelEndpointRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelARN").getter(getter(GetSignalingChannelEndpointRequest::channelARN))
            .setter(setter(Builder::channelARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()).build();

    private static final SdkField<SingleMasterChannelEndpointConfiguration> SINGLE_MASTER_CHANNEL_ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<SingleMasterChannelEndpointConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SingleMasterChannelEndpointConfiguration")
            .getter(getter(GetSignalingChannelEndpointRequest::singleMasterChannelEndpointConfiguration))
            .setter(setter(Builder::singleMasterChannelEndpointConfiguration))
            .constructor(SingleMasterChannelEndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SingleMasterChannelEndpointConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            SINGLE_MASTER_CHANNEL_ENDPOINT_CONFIGURATION_FIELD));

    private final String channelARN;

    private final SingleMasterChannelEndpointConfiguration singleMasterChannelEndpointConfiguration;

    private GetSignalingChannelEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.channelARN = builder.channelARN;
        this.singleMasterChannelEndpointConfiguration = builder.singleMasterChannelEndpointConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the signalling channel for which you want to get an endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the signalling channel for which you want to get an endpoint.
     */
    public final String channelARN() {
        return channelARN;
    }

    /**
     * <p>
     * A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.
     * </p>
     * 
     * @return A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.
     */
    public final SingleMasterChannelEndpointConfiguration singleMasterChannelEndpointConfiguration() {
        return singleMasterChannelEndpointConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(singleMasterChannelEndpointConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSignalingChannelEndpointRequest)) {
            return false;
        }
        GetSignalingChannelEndpointRequest other = (GetSignalingChannelEndpointRequest) obj;
        return Objects.equals(channelARN(), other.channelARN())
                && Objects.equals(singleMasterChannelEndpointConfiguration(), other.singleMasterChannelEndpointConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSignalingChannelEndpointRequest").add("ChannelARN", channelARN())
                .add("SingleMasterChannelEndpointConfiguration", singleMasterChannelEndpointConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelARN":
            return Optional.ofNullable(clazz.cast(channelARN()));
        case "SingleMasterChannelEndpointConfiguration":
            return Optional.ofNullable(clazz.cast(singleMasterChannelEndpointConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSignalingChannelEndpointRequest, T> g) {
        return obj -> g.apply((GetSignalingChannelEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSignalingChannelEndpointRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the signalling channel for which you want to get an endpoint.
         * </p>
         * 
         * @param channelARN
         *        The Amazon Resource Name (ARN) of the signalling channel for which you want to get an endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelARN(String channelARN);

        /**
         * <p>
         * A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.
         * </p>
         * 
         * @param singleMasterChannelEndpointConfiguration
         *        A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleMasterChannelEndpointConfiguration(
                SingleMasterChannelEndpointConfiguration singleMasterChannelEndpointConfiguration);

        /**
         * <p>
         * A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SingleMasterChannelEndpointConfiguration.Builder} avoiding the need to create one manually via
         * {@link SingleMasterChannelEndpointConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleMasterChannelEndpointConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #singleMasterChannelEndpointConfiguration(SingleMasterChannelEndpointConfiguration)}.
         * 
         * @param singleMasterChannelEndpointConfiguration
         *        a consumer that will call methods on {@link SingleMasterChannelEndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleMasterChannelEndpointConfiguration(SingleMasterChannelEndpointConfiguration)
         */
        default Builder singleMasterChannelEndpointConfiguration(
                Consumer<SingleMasterChannelEndpointConfiguration.Builder> singleMasterChannelEndpointConfiguration) {
            return singleMasterChannelEndpointConfiguration(SingleMasterChannelEndpointConfiguration.builder()
                    .applyMutation(singleMasterChannelEndpointConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String channelARN;

        private SingleMasterChannelEndpointConfiguration singleMasterChannelEndpointConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSignalingChannelEndpointRequest model) {
            super(model);
            channelARN(model.channelARN);
            singleMasterChannelEndpointConfiguration(model.singleMasterChannelEndpointConfiguration);
        }

        public final String getChannelARN() {
            return channelARN;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        @Override
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final SingleMasterChannelEndpointConfiguration.Builder getSingleMasterChannelEndpointConfiguration() {
            return singleMasterChannelEndpointConfiguration != null ? singleMasterChannelEndpointConfiguration.toBuilder() : null;
        }

        public final void setSingleMasterChannelEndpointConfiguration(
                SingleMasterChannelEndpointConfiguration.BuilderImpl singleMasterChannelEndpointConfiguration) {
            this.singleMasterChannelEndpointConfiguration = singleMasterChannelEndpointConfiguration != null ? singleMasterChannelEndpointConfiguration
                    .build() : null;
        }

        @Override
        public final Builder singleMasterChannelEndpointConfiguration(
                SingleMasterChannelEndpointConfiguration singleMasterChannelEndpointConfiguration) {
            this.singleMasterChannelEndpointConfiguration = singleMasterChannelEndpointConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSignalingChannelEndpointRequest build() {
            return new GetSignalingChannelEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
