/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationsRequest extends KinesisAnalyticsRequest implements
        ToCopyableBuilder<ListApplicationsRequest.Builder, ListApplicationsRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListApplicationsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> EXCLUSIVE_START_APPLICATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExclusiveStartApplicationName")
            .getter(getter(ListApplicationsRequest::exclusiveStartApplicationName))
            .setter(setter(Builder::exclusiveStartApplicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartApplicationName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD,
            EXCLUSIVE_START_APPLICATION_NAME_FIELD));

    private final Integer limit;

    private final String exclusiveStartApplicationName;

    private ListApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.exclusiveStartApplicationName = builder.exclusiveStartApplicationName;
    }

    /**
     * <p>
     * Maximum number of applications to list.
     * </p>
     * 
     * @return Maximum number of applications to list.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Name of the application to start the list with. When using pagination to retrieve the list, you don't need to
     * specify this parameter in the first request. However, in subsequent requests, you add the last application name
     * from the previous response to get the next page of applications.
     * </p>
     * 
     * @return Name of the application to start the list with. When using pagination to retrieve the list, you don't
     *         need to specify this parameter in the first request. However, in subsequent requests, you add the last
     *         application name from the previous response to get the next page of applications.
     */
    public final String exclusiveStartApplicationName() {
        return exclusiveStartApplicationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartApplicationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsRequest)) {
            return false;
        }
        ListApplicationsRequest other = (ListApplicationsRequest) obj;
        return Objects.equals(limit(), other.limit())
                && Objects.equals(exclusiveStartApplicationName(), other.exclusiveStartApplicationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationsRequest").add("Limit", limit())
                .add("ExclusiveStartApplicationName", exclusiveStartApplicationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "ExclusiveStartApplicationName":
            return Optional.ofNullable(clazz.cast(exclusiveStartApplicationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationsRequest, T> g) {
        return obj -> g.apply((ListApplicationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListApplicationsRequest> {
        /**
         * <p>
         * Maximum number of applications to list.
         * </p>
         * 
         * @param limit
         *        Maximum number of applications to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Name of the application to start the list with. When using pagination to retrieve the list, you don't need to
         * specify this parameter in the first request. However, in subsequent requests, you add the last application
         * name from the previous response to get the next page of applications.
         * </p>
         * 
         * @param exclusiveStartApplicationName
         *        Name of the application to start the list with. When using pagination to retrieve the list, you don't
         *        need to specify this parameter in the first request. However, in subsequent requests, you add the last
         *        application name from the previous response to get the next page of applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartApplicationName(String exclusiveStartApplicationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private Integer limit;

        private String exclusiveStartApplicationName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsRequest model) {
            super(model);
            limit(model.limit);
            exclusiveStartApplicationName(model.exclusiveStartApplicationName);
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getExclusiveStartApplicationName() {
            return exclusiveStartApplicationName;
        }

        public final void setExclusiveStartApplicationName(String exclusiveStartApplicationName) {
            this.exclusiveStartApplicationName = exclusiveStartApplicationName;
        }

        @Override
        public final Builder exclusiveStartApplicationName(String exclusiveStartApplicationName) {
            this.exclusiveStartApplicationName = exclusiveStartApplicationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListApplicationsRequest build() {
            return new ListApplicationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
