/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Includes details about the failed items.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedItemDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedItemDetails.Builder, FailedItemDetails> {
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(FailedItemDetails::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<Boolean> RETRYABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("retryable").getter(getter(FailedItemDetails::retryable)).setter(setter(Builder::retryable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_CODE_FIELD,
            RETRYABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failureCode;

    private final Boolean retryableValue;

    private FailedItemDetails(BuilderImpl builder) {
        this.failureCode = builder.failureCode;
        this.retryableValue = builder.retryableValue;
    }

    /**
     * <p>
     * The status code of a failed item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link FailedItemErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The status code of a failed item.
     * @see FailedItemErrorCode
     */
    public final FailedItemErrorCode failureCode() {
        return FailedItemErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The status code of a failed item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link FailedItemErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The status code of a failed item.
     * @see FailedItemErrorCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * Indicates whether you can immediately retry a request for this item for a specified resource.
     * </p>
     * 
     * @return Indicates whether you can immediately retry a request for this item for a specified resource.
     */
    public final Boolean retryable() {
        return retryableValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retryable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedItemDetails)) {
            return false;
        }
        FailedItemDetails other = (FailedItemDetails) obj;
        return Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(retryable(), other.retryable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedItemDetails").add("FailureCode", failureCodeAsString()).add("Retryable", retryable())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "retryable":
            return Optional.ofNullable(clazz.cast(retryable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedItemDetails, T> g) {
        return obj -> g.apply((FailedItemDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedItemDetails> {
        /**
         * <p>
         * The status code of a failed item.
         * </p>
         * 
         * @param failureCode
         *        The status code of a failed item.
         * @see FailedItemErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailedItemErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The status code of a failed item.
         * </p>
         * 
         * @param failureCode
         *        The status code of a failed item.
         * @see FailedItemErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailedItemErrorCode
         */
        Builder failureCode(FailedItemErrorCode failureCode);

        /**
         * <p>
         * Indicates whether you can immediately retry a request for this item for a specified resource.
         * </p>
         * 
         * @param retryableValue
         *        Indicates whether you can immediately retry a request for this item for a specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryable(Boolean retryableValue);
    }

    static final class BuilderImpl implements Builder {
        private String failureCode;

        private Boolean retryableValue;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedItemDetails model) {
            failureCode(model.failureCode);
            retryable(model.retryableValue);
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(FailedItemErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final Boolean getRetryable() {
            return retryableValue;
        }

        public final void setRetryable(Boolean retryableValue) {
            this.retryableValue = retryableValue;
        }

        @Override
        public final Builder retryable(Boolean retryableValue) {
            this.retryableValue = retryableValue;
            return this;
        }

        @Override
        public FailedItemDetails build() {
            return new FailedItemDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
