/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DescribeEventDetailsFailedSetCopier {
    static List<EventDetailsErrorItem> copy(Collection<? extends EventDetailsErrorItem> describeEventDetailsFailedSetParam) {
        List<EventDetailsErrorItem> list;
        if (describeEventDetailsFailedSetParam == null || describeEventDetailsFailedSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EventDetailsErrorItem> modifiableList = new ArrayList<>();
            describeEventDetailsFailedSetParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EventDetailsErrorItem> copyFromBuilder(
            Collection<? extends EventDetailsErrorItem.Builder> describeEventDetailsFailedSetParam) {
        List<EventDetailsErrorItem> list;
        if (describeEventDetailsFailedSetParam == null || describeEventDetailsFailedSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EventDetailsErrorItem> modifiableList = new ArrayList<>();
            describeEventDetailsFailedSetParam.forEach(entry -> {
                EventDetailsErrorItem member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EventDetailsErrorItem.Builder> copyToBuilder(
            Collection<? extends EventDetailsErrorItem> describeEventDetailsFailedSetParam) {
        List<EventDetailsErrorItem.Builder> list;
        if (describeEventDetailsFailedSetParam == null || describeEventDetailsFailedSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EventDetailsErrorItem.Builder> modifiableList = new ArrayList<>();
            describeEventDetailsFailedSetParam.forEach(entry -> {
                EventDetailsErrorItem.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
