/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing migration status information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CatalogImportStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<CatalogImportStatus.Builder, CatalogImportStatus> {
    private static final SdkField<Boolean> IMPORT_COMPLETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ImportCompleted").getter(getter(CatalogImportStatus::importCompleted))
            .setter(setter(Builder::importCompleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportCompleted").build()).build();

    private static final SdkField<Instant> IMPORT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ImportTime").getter(getter(CatalogImportStatus::importTime)).setter(setter(Builder::importTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTime").build()).build();

    private static final SdkField<String> IMPORTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportedBy").getter(getter(CatalogImportStatus::importedBy)).setter(setter(Builder::importedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_COMPLETED_FIELD,
            IMPORT_TIME_FIELD, IMPORTED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean importCompleted;

    private final Instant importTime;

    private final String importedBy;

    private CatalogImportStatus(BuilderImpl builder) {
        this.importCompleted = builder.importCompleted;
        this.importTime = builder.importTime;
        this.importedBy = builder.importedBy;
    }

    /**
     * <p>
     * <code>True</code> if the migration has completed, or <code>False</code> otherwise.
     * </p>
     * 
     * @return <code>True</code> if the migration has completed, or <code>False</code> otherwise.
     */
    public final Boolean importCompleted() {
        return importCompleted;
    }

    /**
     * <p>
     * The time that the migration was started.
     * </p>
     * 
     * @return The time that the migration was started.
     */
    public final Instant importTime() {
        return importTime;
    }

    /**
     * <p>
     * The name of the person who initiated the migration.
     * </p>
     * 
     * @return The name of the person who initiated the migration.
     */
    public final String importedBy() {
        return importedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(importTime());
        hashCode = 31 * hashCode + Objects.hashCode(importedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogImportStatus)) {
            return false;
        }
        CatalogImportStatus other = (CatalogImportStatus) obj;
        return Objects.equals(importCompleted(), other.importCompleted()) && Objects.equals(importTime(), other.importTime())
                && Objects.equals(importedBy(), other.importedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CatalogImportStatus").add("ImportCompleted", importCompleted()).add("ImportTime", importTime())
                .add("ImportedBy", importedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportCompleted":
            return Optional.ofNullable(clazz.cast(importCompleted()));
        case "ImportTime":
            return Optional.ofNullable(clazz.cast(importTime()));
        case "ImportedBy":
            return Optional.ofNullable(clazz.cast(importedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CatalogImportStatus, T> g) {
        return obj -> g.apply((CatalogImportStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CatalogImportStatus> {
        /**
         * <p>
         * <code>True</code> if the migration has completed, or <code>False</code> otherwise.
         * </p>
         * 
         * @param importCompleted
         *        <code>True</code> if the migration has completed, or <code>False</code> otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importCompleted(Boolean importCompleted);

        /**
         * <p>
         * The time that the migration was started.
         * </p>
         * 
         * @param importTime
         *        The time that the migration was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTime(Instant importTime);

        /**
         * <p>
         * The name of the person who initiated the migration.
         * </p>
         * 
         * @param importedBy
         *        The name of the person who initiated the migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedBy(String importedBy);
    }

    static final class BuilderImpl implements Builder {
        private Boolean importCompleted;

        private Instant importTime;

        private String importedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogImportStatus model) {
            importCompleted(model.importCompleted);
            importTime(model.importTime);
            importedBy(model.importedBy);
        }

        public final Boolean getImportCompleted() {
            return importCompleted;
        }

        public final void setImportCompleted(Boolean importCompleted) {
            this.importCompleted = importCompleted;
        }

        @Override
        public final Builder importCompleted(Boolean importCompleted) {
            this.importCompleted = importCompleted;
            return this;
        }

        public final Instant getImportTime() {
            return importTime;
        }

        public final void setImportTime(Instant importTime) {
            this.importTime = importTime;
        }

        @Override
        public final Builder importTime(Instant importTime) {
            this.importTime = importTime;
            return this;
        }

        public final String getImportedBy() {
            return importedBy;
        }

        public final void setImportedBy(String importedBy) {
            this.importedBy = importedBy;
        }

        @Override
        public final Builder importedBy(String importedBy) {
            this.importedBy = importedBy;
            return this;
        }

        @Override
        public CatalogImportStatus build() {
            return new CatalogImportStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
