/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitiateVaultLockResponse extends GlacierResponse implements
        ToCopyableBuilder<InitiateVaultLockResponse.Builder, InitiateVaultLockResponse> {
    private static final SdkField<String> LOCK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("lockId")
            .getter(getter(InitiateVaultLockResponse::lockId)).setter(setter(Builder::lockId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lock-id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCK_ID_FIELD));

    private final String lockId;

    private InitiateVaultLockResponse(BuilderImpl builder) {
        super(builder);
        this.lockId = builder.lockId;
    }

    /**
     * <p>
     * The lock ID, which is used to complete the vault locking process.
     * </p>
     * 
     * @return The lock ID, which is used to complete the vault locking process.
     */
    public final String lockId() {
        return lockId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lockId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateVaultLockResponse)) {
            return false;
        }
        InitiateVaultLockResponse other = (InitiateVaultLockResponse) obj;
        return Objects.equals(lockId(), other.lockId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InitiateVaultLockResponse").add("LockId", lockId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lockId":
            return Optional.ofNullable(clazz.cast(lockId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InitiateVaultLockResponse, T> g) {
        return obj -> g.apply((InitiateVaultLockResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, InitiateVaultLockResponse> {
        /**
         * <p>
         * The lock ID, which is used to complete the vault locking process.
         * </p>
         * 
         * @param lockId
         *        The lock ID, which is used to complete the vault locking process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockId(String lockId);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private String lockId;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateVaultLockResponse model) {
            super(model);
            lockId(model.lockId);
        }

        public final String getLockId() {
            return lockId;
        }

        public final void setLockId(String lockId) {
            this.lockId = lockId;
        }

        @Override
        public final Builder lockId(String lockId) {
            this.lockId = lockId;
            return this;
        }

        @Override
        public InitiateVaultLockResponse build() {
            return new InitiateVaultLockResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
