/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AllocationIdNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AlpnPolicyNotSupportedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZoneNotSupportedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateListenerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateLoadBalancerNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTargetGroupNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HealthUnavailableException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IncompatibleProtocolsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidConfigurationRequestException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidLoadBalancerActionException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSchemeException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSecurityGroupException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidTargetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.OperationNotPermittedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PriorityInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ResourceInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicyNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAssociationLimitException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyActionsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyCertificatesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyListenersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyLoadBalancersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRegistrationsForTargetIdException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRulesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetGroupsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyUniqueTargetGroupsPerLoadBalancerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.UnsupportedProtocolException;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.ElasticLoadBalancingV2Waiter;

/**
 * Service client for accessing Elastic Load Balancing v2. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Elastic Load Balancing</fullname>
 * <p>
 * A load balancer distributes incoming traffic across targets, such as your EC2 instances. This enables you to increase
 * the availability of your application. The load balancer also monitors the health of its registered targets and
 * ensures that it routes traffic only to healthy targets. You configure your load balancer to accept incoming traffic
 * by specifying one or more listeners, which are configured with a protocol and port number for connections from
 * clients to the load balancer. You configure a target group with a protocol and port number for connections from the
 * load balancer to the targets, and with health check settings to be used when checking the health status of the
 * targets.
 * </p>
 * <p>
 * Elastic Load Balancing supports the following types of load balancers: Application Load Balancers, Network Load
 * Balancers, Gateway Load Balancers, and Classic Load Balancers. This reference covers the following load balancer
 * types:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.
 * </p>
 * </li>
 * <li>
 * <p>
 * Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.
 * </p>
 * </li>
 * <li>
 * <p>
 * Gateway Load Balancer - Operates at the network layer (layer 3).
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/">Elastic
 * Load Balancing User Guide</a>.
 * </p>
 * <p>
 * All Elastic Load Balancing operations are idempotent, which means that they complete at most one time. If you repeat
 * an operation, it succeeds.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ElasticLoadBalancingV2Client extends AwsClient {
    String SERVICE_NAME = "elasticloadbalancing";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "elasticloadbalancing";

    /**
     * <p>
     * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the certificate in already in the certificate list, the call is successful but the certificate is not added
     * again.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html">HTTPS
     * listeners</a> in the <i>Application Load Balancers Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html">TLS listeners</a>
     * in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param addListenerCertificatesRequest
     * @return Result of the AddListenerCertificates operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws TooManyCertificatesException
     *         You've reached the limit on the number of certificates per load balancer.
     * @throws CertificateNotFoundException
     *         The specified certificate does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.AddListenerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default AddListenerCertificatesResponse addListenerCertificates(AddListenerCertificatesRequest addListenerCertificatesRequest)
            throws ListenerNotFoundException, TooManyCertificatesException, CertificateNotFoundException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the certificate in already in the certificate list, the call is successful but the certificate is not added
     * again.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html">HTTPS
     * listeners</a> in the <i>Application Load Balancers Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html">TLS listeners</a>
     * in the <i>Network Load Balancers Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddListenerCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link AddListenerCertificatesRequest#builder()}
     * </p>
     *
     * @param addListenerCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest.Builder}
     *        to create a request.
     * @return Result of the AddListenerCertificates operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws TooManyCertificatesException
     *         You've reached the limit on the number of certificates per load balancer.
     * @throws CertificateNotFoundException
     *         The specified certificate does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.AddListenerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default AddListenerCertificatesResponse addListenerCertificates(
            Consumer<AddListenerCertificatesRequest.Builder> addListenerCertificatesRequest) throws ListenerNotFoundException,
            TooManyCertificatesException, CertificateNotFoundException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return addListenerCertificates(AddListenerCertificatesRequest.builder().applyMutation(addListenerCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load
     * Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, and rules.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key,
     * <code>AddTags</code> updates its value.
     * </p>
     *
     * @param addTagsRequest
     * @return Result of the AddTags operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTags"
     *      target="_top">AWS API Documentation</a>
     */
    default AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws DuplicateTagKeysException, TooManyTagsException,
            LoadBalancerNotFoundException, TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load
     * Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, and rules.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key,
     * <code>AddTags</code> updates its value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest.Builder} to create a
     *        request.
     * @return Result of the AddTags operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTags"
     *      target="_top">AWS API Documentation</a>
     */
    default AddTagsResponse addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) throws DuplicateTagKeysException,
            TooManyTagsException, LoadBalancerNotFoundException, TargetGroupNotFoundException, ListenerNotFoundException,
            RuleNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">
     * Listeners for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html">Listeners
     * for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html">Listeners for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * listeners with the same settings, each call succeeds.
     * </p>
     *
     * @param createListenerRequest
     * @return Result of the CreateListener operation returned by the service.
     * @throws DuplicateListenerException
     *         A listener with the specified port already exists.
     * @throws TooManyListenersException
     *         You've reached the limit on the number of listeners per load balancer.
     * @throws TooManyCertificatesException
     *         You've reached the limit on the number of certificates per load balancer.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws SslPolicyNotFoundException
     *         The specified SSL policy does not exist.
     * @throws CertificateNotFoundException
     *         The specified certificate does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws AlpnPolicyNotSupportedException
     *         The specified ALPN policy is not supported.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateListenerResponse createListener(CreateListenerRequest createListenerRequest) throws DuplicateListenerException,
            TooManyListenersException, TooManyCertificatesException, LoadBalancerNotFoundException, TargetGroupNotFoundException,
            TargetGroupAssociationLimitException, InvalidConfigurationRequestException, IncompatibleProtocolsException,
            SslPolicyNotFoundException, CertificateNotFoundException, UnsupportedProtocolException,
            TooManyRegistrationsForTargetIdException, TooManyTargetsException, TooManyActionsException,
            InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException,
            AlpnPolicyNotSupportedException, TooManyTagsException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">
     * Listeners for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html">Listeners
     * for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html">Listeners for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * listeners with the same settings, each call succeeds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateListenerRequest#builder()}
     * </p>
     *
     * @param createListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest.Builder} to
     *        create a request.
     * @return Result of the CreateListener operation returned by the service.
     * @throws DuplicateListenerException
     *         A listener with the specified port already exists.
     * @throws TooManyListenersException
     *         You've reached the limit on the number of listeners per load balancer.
     * @throws TooManyCertificatesException
     *         You've reached the limit on the number of certificates per load balancer.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws SslPolicyNotFoundException
     *         The specified SSL policy does not exist.
     * @throws CertificateNotFoundException
     *         The specified certificate does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws AlpnPolicyNotSupportedException
     *         The specified ALPN policy is not supported.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateListenerResponse createListener(Consumer<CreateListenerRequest.Builder> createListenerRequest)
            throws DuplicateListenerException, TooManyListenersException, TooManyCertificatesException,
            LoadBalancerNotFoundException, TargetGroupNotFoundException, TargetGroupAssociationLimitException,
            InvalidConfigurationRequestException, IncompatibleProtocolsException, SslPolicyNotFoundException,
            CertificateNotFoundException, UnsupportedProtocolException, TooManyRegistrationsForTargetIdException,
            TooManyTargetsException, TooManyActionsException, InvalidLoadBalancerActionException,
            TooManyUniqueTargetGroupsPerLoadBalancerException, AlpnPolicyNotSupportedException, TooManyTagsException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return createListener(CreateListenerRequest.builder().applyMutation(createListenerRequest).build());
    }

    /**
     * <p>
     * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html">
     * Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html">Network
     * Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html">Gateway
     * Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * load balancers with the same settings, each call succeeds.
     * </p>
     *
     * @param createLoadBalancerRequest
     * @return Result of the CreateLoadBalancer operation returned by the service.
     * @throws DuplicateLoadBalancerNameException
     *         A load balancer with the specified name already exists.
     * @throws TooManyLoadBalancersException
     *         You've reached the limit on the number of load balancers for your Amazon Web Services account.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SubnetNotFoundException
     *         The specified subnet does not exist.
     * @throws InvalidSubnetException
     *         The specified subnet is out of available addresses.
     * @throws InvalidSecurityGroupException
     *         The specified security group does not exist.
     * @throws InvalidSchemeException
     *         The requested scheme is not valid.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws AllocationIdNotFoundException
     *         The specified allocation ID does not exist.
     * @throws AvailabilityZoneNotSupportedException
     *         The specified Availability Zone is not supported.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLoadBalancerResponse createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest)
            throws DuplicateLoadBalancerNameException, TooManyLoadBalancersException, InvalidConfigurationRequestException,
            SubnetNotFoundException, InvalidSubnetException, InvalidSecurityGroupException, InvalidSchemeException,
            TooManyTagsException, DuplicateTagKeysException, ResourceInUseException, AllocationIdNotFoundException,
            AvailabilityZoneNotSupportedException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html">
     * Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html">Network
     * Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html">Gateway
     * Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * load balancers with the same settings, each call succeeds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoadBalancerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLoadBalancerRequest#builder()}
     * </p>
     *
     * @param createLoadBalancerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest.Builder} to
     *        create a request.
     * @return Result of the CreateLoadBalancer operation returned by the service.
     * @throws DuplicateLoadBalancerNameException
     *         A load balancer with the specified name already exists.
     * @throws TooManyLoadBalancersException
     *         You've reached the limit on the number of load balancers for your Amazon Web Services account.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SubnetNotFoundException
     *         The specified subnet does not exist.
     * @throws InvalidSubnetException
     *         The specified subnet is out of available addresses.
     * @throws InvalidSecurityGroupException
     *         The specified security group does not exist.
     * @throws InvalidSchemeException
     *         The requested scheme is not valid.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws AllocationIdNotFoundException
     *         The specified allocation ID does not exist.
     * @throws AvailabilityZoneNotSupportedException
     *         The specified Availability Zone is not supported.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLoadBalancerResponse createLoadBalancer(Consumer<CreateLoadBalancerRequest.Builder> createLoadBalancerRequest)
            throws DuplicateLoadBalancerNameException, TooManyLoadBalancersException, InvalidConfigurationRequestException,
            SubnetNotFoundException, InvalidSubnetException, InvalidSecurityGroupException, InvalidSchemeException,
            TooManyTagsException, DuplicateTagKeysException, ResourceInUseException, AllocationIdNotFoundException,
            AvailabilityZoneNotSupportedException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return createLoadBalancer(CreateLoadBalancerRequest.builder().applyMutation(createLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
     * </p>
     * <p>
     * Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in
     * priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions
     * are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules"
     * >Listener rules</a> in the <i>Application Load Balancers Guide</i>.
     * </p>
     *
     * @param createRuleRequest
     * @return Result of the CreateRule operation returned by the service.
     * @throws PriorityInUseException
     *         The specified priority is in use.
     * @throws TooManyTargetGroupsException
     *         You've reached the limit on the number of target groups for your Amazon Web Services account.
     * @throws TooManyRulesException
     *         You've reached the limit on the number of rules per load balancer.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws PriorityInUseException,
            TooManyTargetGroupsException, TooManyRulesException, TargetGroupAssociationLimitException,
            IncompatibleProtocolsException, ListenerNotFoundException, TargetGroupNotFoundException,
            InvalidConfigurationRequestException, TooManyRegistrationsForTargetIdException, TooManyTargetsException,
            UnsupportedProtocolException, TooManyActionsException, InvalidLoadBalancerActionException,
            TooManyUniqueTargetGroupsPerLoadBalancerException, TooManyTagsException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
     * </p>
     * <p>
     * Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in
     * priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions
     * are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules"
     * >Listener rules</a> in the <i>Application Load Balancers Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRule operation returned by the service.
     * @throws PriorityInUseException
     *         The specified priority is in use.
     * @throws TooManyTargetGroupsException
     *         You've reached the limit on the number of target groups for your Amazon Web Services account.
     * @throws TooManyRulesException
     *         You've reached the limit on the number of rules per load balancer.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRuleResponse createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) throws PriorityInUseException,
            TooManyTargetGroupsException, TooManyRulesException, TargetGroupAssociationLimitException,
            IncompatibleProtocolsException, ListenerNotFoundException, TargetGroupNotFoundException,
            InvalidConfigurationRequestException, TooManyRegistrationsForTargetIdException, TooManyTargetsException,
            UnsupportedProtocolException, TooManyActionsException, InvalidLoadBalancerActionException,
            TooManyUniqueTargetGroupsPerLoadBalancerException, TooManyTagsException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html">
     * Target groups for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target
     * groups for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html">Target groups for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * target groups with the same settings, each call succeeds.
     * </p>
     *
     * @param createTargetGroupRequest
     * @return Result of the CreateTargetGroup operation returned by the service.
     * @throws DuplicateTargetGroupNameException
     *         A target group with the specified name already exists.
     * @throws TooManyTargetGroupsException
     *         You've reached the limit on the number of target groups for your Amazon Web Services account.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTargetGroupResponse createTargetGroup(CreateTargetGroupRequest createTargetGroupRequest)
            throws DuplicateTargetGroupNameException, TooManyTargetGroupsException, InvalidConfigurationRequestException,
            TooManyTagsException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html">
     * Target groups for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target
     * groups for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html">Target groups for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * target groups with the same settings, each call succeeds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTargetGroupRequest#builder()}
     * </p>
     *
     * @param createTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest.Builder} to
     *        create a request.
     * @return Result of the CreateTargetGroup operation returned by the service.
     * @throws DuplicateTargetGroupNameException
     *         A target group with the specified name already exists.
     * @throws TooManyTargetGroupsException
     *         You've reached the limit on the number of target groups for your Amazon Web Services account.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTargetGroupResponse createTargetGroup(Consumer<CreateTargetGroupRequest.Builder> createTargetGroupRequest)
            throws DuplicateTargetGroupNameException, TooManyTargetGroupsException, InvalidConfigurationRequestException,
            TooManyTagsException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return createTargetGroup(CreateTargetGroupRequest.builder().applyMutation(createTargetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     * <p>
     * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
     * </p>
     *
     * @param deleteListenerRequest
     * @return Result of the DeleteListener operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteListenerResponse deleteListener(DeleteListenerRequest deleteListenerRequest) throws ListenerNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     * <p>
     * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteListenerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteListenerRequest#builder()}
     * </p>
     *
     * @param deleteListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteListener operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteListenerResponse deleteListener(Consumer<DeleteListenerRequest.Builder> deleteListenerRequest)
            throws ListenerNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return deleteListener(DeleteListenerRequest.builder().applyMutation(deleteListenerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load
     * balancer also deletes its listeners.
     * </p>
     * <p>
     * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has
     * already been deleted, the call succeeds.
     * </p>
     * <p>
     * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run
     * and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or
     * terminate them.
     * </p>
     *
     * @param deleteLoadBalancerRequest
     * @return Result of the DeleteLoadBalancer operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLoadBalancerResponse deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest)
            throws LoadBalancerNotFoundException, OperationNotPermittedException, ResourceInUseException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load
     * balancer also deletes its listeners.
     * </p>
     * <p>
     * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has
     * already been deleted, the call succeeds.
     * </p>
     * <p>
     * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run
     * and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or
     * terminate them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoadBalancerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLoadBalancerRequest#builder()}
     * </p>
     *
     * @param deleteLoadBalancerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteLoadBalancer operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLoadBalancerResponse deleteLoadBalancer(Consumer<DeleteLoadBalancerRequest.Builder> deleteLoadBalancerRequest)
            throws LoadBalancerNotFoundException, OperationNotPermittedException, ResourceInUseException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return deleteLoadBalancer(DeleteLoadBalancerRequest.builder().applyMutation(deleteLoadBalancerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * <p>
     * You can't delete the default rule.
     * </p>
     *
     * @param deleteRuleRequest
     * @return Result of the DeleteRule operation returned by the service.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws RuleNotFoundException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * <p>
     * You can't delete the default rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRule operation returned by the service.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRuleResponse deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) throws RuleNotFoundException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified target group.
     * </p>
     * <p>
     * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any
     * associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2
     * instances continue to run until you stop or terminate them.
     * </p>
     *
     * @param deleteTargetGroupRequest
     * @return Result of the DeleteTargetGroup operation returned by the service.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTargetGroupResponse deleteTargetGroup(DeleteTargetGroupRequest deleteTargetGroupRequest)
            throws ResourceInUseException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified target group.
     * </p>
     * <p>
     * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any
     * associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2
     * instances continue to run until you stop or terminate them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTargetGroupRequest#builder()}
     * </p>
     *
     * @param deleteTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteTargetGroup operation returned by the service.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTargetGroupResponse deleteTargetGroup(Consumer<DeleteTargetGroupRequest.Builder> deleteTargetGroupRequest)
            throws ResourceInUseException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return deleteTargetGroup(DeleteTargetGroupRequest.builder().applyMutation(deleteTargetGroupRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no
     * longer receive traffic from the load balancer.
     * </p>
     * <p>
     * The load balancer stops sending requests to targets that are deregistering, but uses connection draining to
     * ensure that in-flight traffic completes on the existing connections. This deregistration delay is configured by
     * default but can be updated for each target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Application Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Network Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#deregistration-delay">
     * Deregistration delay</a> in the <i>Gateway Load Balancers User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note: If the specified target does not exist, the action returns successfully.
     * </p>
     *
     * @param deregisterTargetsRequest
     * @return Result of the DeregisterTargets operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidTargetException
     *         The specified target does not exist, is not in the same VPC as the target group, or has an unsupported
     *         instance type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeregisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeregisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterTargetsResponse deregisterTargets(DeregisterTargetsRequest deregisterTargetsRequest)
            throws TargetGroupNotFoundException, InvalidTargetException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no
     * longer receive traffic from the load balancer.
     * </p>
     * <p>
     * The load balancer stops sending requests to targets that are deregistering, but uses connection draining to
     * ensure that in-flight traffic completes on the existing connections. This deregistration delay is configured by
     * default but can be updated for each target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Application Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Network Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#deregistration-delay">
     * Deregistration delay</a> in the <i>Gateway Load Balancers User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note: If the specified target does not exist, the action returns successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTargetsRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterTargetsRequest#builder()}
     * </p>
     *
     * @param deregisterTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest.Builder} to
     *        create a request.
     * @return Result of the DeregisterTargets operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidTargetException
     *         The specified target does not exist, is not in the same VPC as the target group, or has an unsupported
     *         instance type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeregisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeregisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterTargetsResponse deregisterTargets(Consumer<DeregisterTargetsRequest.Builder> deregisterTargetsRequest)
            throws TargetGroupNotFoundException, InvalidTargetException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return deregisterTargets(DeregisterTargetsRequest.builder().applyMutation(deregisterTargetsRequest).build());
    }

    /**
     * <p>
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas
     * for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for
     * your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your
     * Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountLimitsRequest
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas
     * for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for
     * your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your
     * Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) throws AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest).build());
    }

    /**
     * <p>
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas
     * for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for
     * your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your
     * Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     *
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeAccountLimits
     * @see #describeAccountLimits(DescribeAccountLimitsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits() throws AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the default certificate is also in the certificate list, it appears twice in the results (once with
     * <code>IsDefault</code> set to true and once with <code>IsDefault</code> set to false).
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates"
     * >SSL certificates</a> in the <i>Application Load Balancers Guide</i> or <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate"
     * >Server certificates</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeListenerCertificatesRequest
     * @return Result of the DescribeListenerCertificates operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenerCertificatesResponse describeListenerCertificates(
            DescribeListenerCertificatesRequest describeListenerCertificatesRequest) throws ListenerNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the default certificate is also in the certificate list, it appears twice in the results (once with
     * <code>IsDefault</code> set to true and once with <code>IsDefault</code> set to false).
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates"
     * >SSL certificates</a> in the <i>Application Load Balancers Guide</i> or <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate"
     * >Server certificates</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenerCertificatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeListenerCertificatesRequest#builder()}
     * </p>
     *
     * @param describeListenerCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeListenerCertificates operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenerCertificatesResponse describeListenerCertificates(
            Consumer<DescribeListenerCertificatesRequest.Builder> describeListenerCertificatesRequest)
            throws ListenerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeListenerCertificates(DescribeListenerCertificatesRequest.builder()
                .applyMutation(describeListenerCertificatesRequest).build());
    }

    /**
     * <p>
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load
     * Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     * </p>
     *
     * @param describeListenersRequest
     * @return Result of the DescribeListeners operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenersResponse describeListeners(DescribeListenersRequest describeListenersRequest)
            throws ListenerNotFoundException, LoadBalancerNotFoundException, UnsupportedProtocolException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load
     * Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeListenersRequest#builder()}
     * </p>
     *
     * @param describeListenersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeListeners operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenersResponse describeListeners(Consumer<DescribeListenersRequest.Builder> describeListenersRequest)
            throws ListenerNotFoundException, LoadBalancerNotFoundException, UnsupportedProtocolException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return describeListeners(DescribeListenersRequest.builder().applyMutation(describeListenersRequest).build());
    }

    /**
     * <p>
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load
     * Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeListeners(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersIterable responses = client.describeListenersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersIterable responses = client
     *             .describeListenersPaginator(request);
     *     for (software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersIterable responses = client.describeListenersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeListeners(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeListenersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenersIterable describeListenersPaginator(DescribeListenersRequest describeListenersRequest)
            throws ListenerNotFoundException, LoadBalancerNotFoundException, UnsupportedProtocolException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return new DescribeListenersIterable(this, describeListenersRequest);
    }

    /**
     * <p>
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load
     * Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeListeners(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersIterable responses = client.describeListenersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersIterable responses = client
     *             .describeListenersPaginator(request);
     *     for (software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersIterable responses = client.describeListenersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeListeners(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeListenersRequest#builder()}
     * </p>
     *
     * @param describeListenersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenersIterable describeListenersPaginator(
            Consumer<DescribeListenersRequest.Builder> describeListenersRequest) throws ListenerNotFoundException,
            LoadBalancerNotFoundException, UnsupportedProtocolException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return describeListenersPaginator(DescribeListenersRequest.builder().applyMutation(describeListenersRequest).build());
    }

    /**
     * <p>
     * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load
     * Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeLoadBalancerAttributesRequest
     * @return Result of the DescribeLoadBalancerAttributes operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancerAttributesResponse describeLoadBalancerAttributes(
            DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load
     * Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancerAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLoadBalancerAttributesRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancerAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeLoadBalancerAttributes operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancerAttributesResponse describeLoadBalancerAttributes(
            Consumer<DescribeLoadBalancerAttributesRequest.Builder> describeLoadBalancerAttributesRequest)
            throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest.builder()
                .applyMutation(describeLoadBalancerAttributesRequest).build());
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return Result of the DescribeLoadBalancers operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest)
            throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoadBalancersRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeLoadBalancers operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersResponse describeLoadBalancers(
            Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) throws LoadBalancerNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeLoadBalancers(DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest).build());
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     *
     * @return Result of the DescribeLoadBalancers operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeLoadBalancers
     * @see #describeLoadBalancers(DescribeLoadBalancersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersResponse describeLoadBalancers() throws LoadBalancerNotFoundException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return describeLoadBalancers(DescribeLoadBalancersRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable responses = client.describeLoadBalancersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable responses = client
     *             .describeLoadBalancersPaginator(request);
     *     for (software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable responses = client.describeLoadBalancersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeLoadBalancers
     * @see #describeLoadBalancersPaginator(DescribeLoadBalancersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersIterable describeLoadBalancersPaginator() throws LoadBalancerNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeLoadBalancersPaginator(DescribeLoadBalancersRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable responses = client.describeLoadBalancersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable responses = client
     *             .describeLoadBalancersPaginator(request);
     *     for (software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable responses = client.describeLoadBalancersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersIterable describeLoadBalancersPaginator(DescribeLoadBalancersRequest describeLoadBalancersRequest)
            throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return new DescribeLoadBalancersIterable(this, describeLoadBalancersRequest);
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable responses = client.describeLoadBalancersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable responses = client
     *             .describeLoadBalancersPaginator(request);
     *     for (software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable responses = client.describeLoadBalancersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLoadBalancers(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoadBalancersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoadBalancersRequest#builder()}
     * </p>
     *
     * @param describeLoadBalancersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersIterable describeLoadBalancersPaginator(
            Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) throws LoadBalancerNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeLoadBalancersPaginator(DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified rules or the rules for the specified listener. You must specify either a listener or one
     * or more rules.
     * </p>
     *
     * @param describeRulesRequest
     * @return Result of the DescribeRules operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRulesResponse describeRules(DescribeRulesRequest describeRulesRequest) throws ListenerNotFoundException,
            RuleNotFoundException, UnsupportedProtocolException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified rules or the rules for the specified listener. You must specify either a listener or one
     * or more rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRulesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRulesRequest#builder()}
     * </p>
     *
     * @param describeRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeRules operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRulesResponse describeRules(Consumer<DescribeRulesRequest.Builder> describeRulesRequest)
            throws ListenerNotFoundException, RuleNotFoundException, UnsupportedProtocolException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return describeRules(DescribeRulesRequest.builder().applyMutation(describeRulesRequest).build());
    }

    /**
     * <p>
     * Describes the specified policies or all policies used for SSL negotiation.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeSslPoliciesRequest
     * @return Result of the DescribeSSLPolicies operation returned by the service.
     * @throws SslPolicyNotFoundException
     *         The specified SSL policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeSSLPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeSSLPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSslPoliciesResponse describeSSLPolicies(DescribeSslPoliciesRequest describeSslPoliciesRequest)
            throws SslPolicyNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified policies or all policies used for SSL negotiation.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSslPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSslPoliciesRequest#builder()}
     * </p>
     *
     * @param describeSslPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSSLPolicies operation returned by the service.
     * @throws SslPolicyNotFoundException
     *         The specified SSL policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeSSLPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeSSLPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSslPoliciesResponse describeSSLPolicies(
            Consumer<DescribeSslPoliciesRequest.Builder> describeSslPoliciesRequest) throws SslPolicyNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeSSLPolicies(DescribeSslPoliciesRequest.builder().applyMutation(describeSslPoliciesRequest).build());
    }

    /**
     * <p>
     * Describes the specified policies or all policies used for SSL negotiation.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @return Result of the DescribeSSLPolicies operation returned by the service.
     * @throws SslPolicyNotFoundException
     *         The specified SSL policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeSSLPolicies
     * @see #describeSSLPolicies(DescribeSslPoliciesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeSSLPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSslPoliciesResponse describeSSLPolicies() throws SslPolicyNotFoundException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return describeSSLPolicies(DescribeSslPoliciesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more
     * Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws LoadBalancerNotFoundException,
            TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more
     * Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeTags operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTagsResponse describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest)
            throws LoadBalancerNotFoundException, TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Describes the attributes for the specified target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeTargetGroupAttributesRequest
     * @return Result of the DescribeTargetGroupAttributes operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupAttributesResponse describeTargetGroupAttributes(
            DescribeTargetGroupAttributesRequest describeTargetGroupAttributesRequest) throws TargetGroupNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the attributes for the specified target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTargetGroupAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTargetGroupAttributesRequest#builder()}
     * </p>
     *
     * @param describeTargetGroupAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeTargetGroupAttributes operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupAttributesResponse describeTargetGroupAttributes(
            Consumer<DescribeTargetGroupAttributesRequest.Builder> describeTargetGroupAttributesRequest)
            throws TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeTargetGroupAttributes(DescribeTargetGroupAttributesRequest.builder()
                .applyMutation(describeTargetGroupAttributesRequest).build());
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     *
     * @param describeTargetGroupsRequest
     * @return Result of the DescribeTargetGroups operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupsResponse describeTargetGroups(DescribeTargetGroupsRequest describeTargetGroupsRequest)
            throws LoadBalancerNotFoundException, TargetGroupNotFoundException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTargetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeTargetGroups operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupsResponse describeTargetGroups(
            Consumer<DescribeTargetGroupsRequest.Builder> describeTargetGroupsRequest) throws LoadBalancerNotFoundException,
            TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeTargetGroups(DescribeTargetGroupsRequest.builder().applyMutation(describeTargetGroupsRequest).build());
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     *
     * @return Result of the DescribeTargetGroups operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetGroups
     * @see #describeTargetGroups(DescribeTargetGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupsResponse describeTargetGroups() throws LoadBalancerNotFoundException,
            TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeTargetGroups(DescribeTargetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable responses = client.describeTargetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable responses = client
     *             .describeTargetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable responses = client.describeTargetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetGroups
     * @see #describeTargetGroupsPaginator(DescribeTargetGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupsIterable describeTargetGroupsPaginator() throws LoadBalancerNotFoundException,
            TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeTargetGroupsPaginator(DescribeTargetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable responses = client.describeTargetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable responses = client
     *             .describeTargetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable responses = client.describeTargetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTargetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupsIterable describeTargetGroupsPaginator(DescribeTargetGroupsRequest describeTargetGroupsRequest)
            throws LoadBalancerNotFoundException, TargetGroupNotFoundException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return new DescribeTargetGroupsIterable(this, describeTargetGroupsRequest);
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable responses = client.describeTargetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable responses = client
     *             .describeTargetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable responses = client.describeTargetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTargetGroups(software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTargetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetGroupsIterable describeTargetGroupsPaginator(
            Consumer<DescribeTargetGroupsRequest.Builder> describeTargetGroupsRequest) throws LoadBalancerNotFoundException,
            TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return describeTargetGroupsPaginator(DescribeTargetGroupsRequest.builder().applyMutation(describeTargetGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the health of the specified targets or all of your targets.
     * </p>
     *
     * @param describeTargetHealthRequest
     * @return Result of the DescribeTargetHealth operation returned by the service.
     * @throws InvalidTargetException
     *         The specified target does not exist, is not in the same VPC as the target group, or has an unsupported
     *         instance type.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws HealthUnavailableException
     *         The health of the specified targets could not be retrieved due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetHealthResponse describeTargetHealth(DescribeTargetHealthRequest describeTargetHealthRequest)
            throws InvalidTargetException, TargetGroupNotFoundException, HealthUnavailableException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the health of the specified targets or all of your targets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTargetHealthRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTargetHealthRequest#builder()}
     * </p>
     *
     * @param describeTargetHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeTargetHealth operation returned by the service.
     * @throws InvalidTargetException
     *         The specified target does not exist, is not in the same VPC as the target group, or has an unsupported
     *         instance type.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws HealthUnavailableException
     *         The health of the specified targets could not be retrieved due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTargetHealthResponse describeTargetHealth(
            Consumer<DescribeTargetHealthRequest.Builder> describeTargetHealthRequest) throws InvalidTargetException,
            TargetGroupNotFoundException, HealthUnavailableException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return describeTargetHealth(DescribeTargetHealthRequest.builder().applyMutation(describeTargetHealthRequest).build());
    }

    /**
     * <p>
     * Replaces the specified properties of the specified listener. Any properties that you do not specify remain
     * unchanged.
     * </p>
     * <p>
     * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate
     * properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy
     * and default certificate properties.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     *
     * @param modifyListenerRequest
     * @return Result of the ModifyListener operation returned by the service.
     * @throws DuplicateListenerException
     *         A listener with the specified port already exists.
     * @throws TooManyListenersException
     *         You've reached the limit on the number of listeners per load balancer.
     * @throws TooManyCertificatesException
     *         You've reached the limit on the number of certificates per load balancer.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws SslPolicyNotFoundException
     *         The specified SSL policy does not exist.
     * @throws CertificateNotFoundException
     *         The specified certificate does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws AlpnPolicyNotSupportedException
     *         The specified ALPN policy is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListener"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyListenerResponse modifyListener(ModifyListenerRequest modifyListenerRequest) throws DuplicateListenerException,
            TooManyListenersException, TooManyCertificatesException, ListenerNotFoundException, TargetGroupNotFoundException,
            TargetGroupAssociationLimitException, IncompatibleProtocolsException, SslPolicyNotFoundException,
            CertificateNotFoundException, InvalidConfigurationRequestException, UnsupportedProtocolException,
            TooManyRegistrationsForTargetIdException, TooManyTargetsException, TooManyActionsException,
            InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException,
            AlpnPolicyNotSupportedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the specified properties of the specified listener. Any properties that you do not specify remain
     * unchanged.
     * </p>
     * <p>
     * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate
     * properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy
     * and default certificate properties.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyListenerRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyListenerRequest#builder()}
     * </p>
     *
     * @param modifyListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyListener operation returned by the service.
     * @throws DuplicateListenerException
     *         A listener with the specified port already exists.
     * @throws TooManyListenersException
     *         You've reached the limit on the number of listeners per load balancer.
     * @throws TooManyCertificatesException
     *         You've reached the limit on the number of certificates per load balancer.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws SslPolicyNotFoundException
     *         The specified SSL policy does not exist.
     * @throws CertificateNotFoundException
     *         The specified certificate does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws AlpnPolicyNotSupportedException
     *         The specified ALPN policy is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListener"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyListenerResponse modifyListener(Consumer<ModifyListenerRequest.Builder> modifyListenerRequest)
            throws DuplicateListenerException, TooManyListenersException, TooManyCertificatesException,
            ListenerNotFoundException, TargetGroupNotFoundException, TargetGroupAssociationLimitException,
            IncompatibleProtocolsException, SslPolicyNotFoundException, CertificateNotFoundException,
            InvalidConfigurationRequestException, UnsupportedProtocolException, TooManyRegistrationsForTargetIdException,
            TooManyTargetsException, TooManyActionsException, InvalidLoadBalancerActionException,
            TooManyUniqueTargetGroupsPerLoadBalancerException, AlpnPolicyNotSupportedException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return modifyListener(ModifyListenerRequest.builder().applyMutation(modifyListenerRequest).build());
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway
     * Load Balancer.
     * </p>
     * <p>
     * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that
     * you do not modify retain their current values.
     * </p>
     *
     * @param modifyLoadBalancerAttributesRequest
     * @return Result of the ModifyLoadBalancerAttributes operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyLoadBalancerAttributesResponse modifyLoadBalancerAttributes(
            ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException,
            InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway
     * Load Balancer.
     * </p>
     * <p>
     * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that
     * you do not modify retain their current values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyLoadBalancerAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyLoadBalancerAttributesRequest#builder()}
     * </p>
     *
     * @param modifyLoadBalancerAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest.Builder}
     *        to create a request.
     * @return Result of the ModifyLoadBalancerAttributes operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyLoadBalancerAttributesResponse modifyLoadBalancerAttributes(
            Consumer<ModifyLoadBalancerAttributesRequest.Builder> modifyLoadBalancerAttributesRequest)
            throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest.builder()
                .applyMutation(modifyLoadBalancerAttributesRequest).build());
    }

    /**
     * <p>
     * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     *
     * @param modifyRuleRequest
     * @return Result of the ModifyRule operation returned by the service.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyRuleResponse modifyRule(ModifyRuleRequest modifyRuleRequest) throws TargetGroupAssociationLimitException,
            IncompatibleProtocolsException, RuleNotFoundException, OperationNotPermittedException,
            TooManyRegistrationsForTargetIdException, TooManyTargetsException, TargetGroupNotFoundException,
            UnsupportedProtocolException, TooManyActionsException, InvalidLoadBalancerActionException,
            TooManyUniqueTargetGroupsPerLoadBalancerException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyRuleRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyRuleRequest#builder()}
     * </p>
     *
     * @param modifyRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyRule operation returned by the service.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyRule"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyRuleResponse modifyRule(Consumer<ModifyRuleRequest.Builder> modifyRuleRequest)
            throws TargetGroupAssociationLimitException, IncompatibleProtocolsException, RuleNotFoundException,
            OperationNotPermittedException, TooManyRegistrationsForTargetIdException, TooManyTargetsException,
            TargetGroupNotFoundException, UnsupportedProtocolException, TooManyActionsException,
            InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return modifyRule(ModifyRuleRequest.builder().applyMutation(modifyRuleRequest).build());
    }

    /**
     * <p>
     * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     * </p>
     *
     * @param modifyTargetGroupRequest
     * @return Result of the ModifyTargetGroup operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyTargetGroupResponse modifyTargetGroup(ModifyTargetGroupRequest modifyTargetGroupRequest)
            throws TargetGroupNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyTargetGroupRequest#builder()}
     * </p>
     *
     * @param modifyTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyTargetGroup operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyTargetGroupResponse modifyTargetGroup(Consumer<ModifyTargetGroupRequest.Builder> modifyTargetGroupRequest)
            throws TargetGroupNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return modifyTargetGroup(ModifyTargetGroupRequest.builder().applyMutation(modifyTargetGroupRequest).build());
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified target group.
     * </p>
     *
     * @param modifyTargetGroupAttributesRequest
     * @return Result of the ModifyTargetGroupAttributes operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyTargetGroupAttributesResponse modifyTargetGroupAttributes(
            ModifyTargetGroupAttributesRequest modifyTargetGroupAttributesRequest) throws TargetGroupNotFoundException,
            InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified target group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyTargetGroupAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyTargetGroupAttributesRequest#builder()}
     * </p>
     *
     * @param modifyTargetGroupAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest.Builder}
     *        to create a request.
     * @return Result of the ModifyTargetGroupAttributes operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyTargetGroupAttributesResponse modifyTargetGroupAttributes(
            Consumer<ModifyTargetGroupAttributesRequest.Builder> modifyTargetGroupAttributesRequest)
            throws TargetGroupNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return modifyTargetGroupAttributes(ModifyTargetGroupAttributesRequest.builder()
                .applyMutation(modifyTargetGroupAttributesRequest).build());
    }

    /**
     * <p>
     * Registers the specified targets with the specified target group.
     * </p>
     * <p>
     * If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.
     * </p>
     * <p>
     * By default, the load balancer routes requests to registered targets using the protocol and port for the target
     * group. Alternatively, you can override the port for a target when you register it. You can register each EC2
     * instance or IP address with the same target group multiple times using different ports.
     * </p>
     * <p>
     * With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance
     * types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of
     * these types by IP address.
     * </p>
     *
     * @param registerTargetsRequest
     * @return Result of the RegisterTargets operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws InvalidTargetException
     *         The specified target does not exist, is not in the same VPC as the target group, or has an unsupported
     *         instance type.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.RegisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RegisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterTargetsResponse registerTargets(RegisterTargetsRequest registerTargetsRequest)
            throws TargetGroupNotFoundException, TooManyTargetsException, InvalidTargetException,
            TooManyRegistrationsForTargetIdException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the specified targets with the specified target group.
     * </p>
     * <p>
     * If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.
     * </p>
     * <p>
     * By default, the load balancer routes requests to registered targets using the protocol and port for the target
     * group. Alternatively, you can override the port for a target when you register it. You can register each EC2
     * instance or IP address with the same target group multiple times using different ports.
     * </p>
     * <p>
     * With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance
     * types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of
     * these types by IP address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterTargetsRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterTargetsRequest#builder()}
     * </p>
     *
     * @param registerTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest.Builder} to
     *        create a request.
     * @return Result of the RegisterTargets operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws InvalidTargetException
     *         The specified target does not exist, is not in the same VPC as the target group, or has an unsupported
     *         instance type.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.RegisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RegisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterTargetsResponse registerTargets(Consumer<RegisterTargetsRequest.Builder> registerTargetsRequest)
            throws TargetGroupNotFoundException, TooManyTargetsException, InvalidTargetException,
            TooManyRegistrationsForTargetIdException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return registerTargets(RegisterTargetsRequest.builder().applyMutation(registerTargetsRequest).build());
    }

    /**
     * <p>
     * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
     * </p>
     *
     * @param removeListenerCertificatesRequest
     * @return Result of the RemoveListenerCertificates operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.RemoveListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveListenerCertificatesResponse removeListenerCertificates(
            RemoveListenerCertificatesRequest removeListenerCertificatesRequest) throws ListenerNotFoundException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveListenerCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveListenerCertificatesRequest#builder()}
     * </p>
     *
     * @param removeListenerCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest.Builder}
     *        to create a request.
     * @return Result of the RemoveListenerCertificates operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.RemoveListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveListenerCertificatesResponse removeListenerCertificates(
            Consumer<RemoveListenerCertificatesRequest.Builder> removeListenerCertificatesRequest)
            throws ListenerNotFoundException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {
        return removeListenerCertificates(RemoveListenerCertificatesRequest.builder()
                .applyMutation(removeListenerCertificatesRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one
     * or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or
     * rules.
     * </p>
     *
     * @param removeTagsRequest
     * @return Result of the RemoveTags operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTags"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws LoadBalancerNotFoundException,
            TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException, TooManyTagsException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one
     * or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or
     * rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveTags operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags per load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTags"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveTagsResponse removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest)
            throws LoadBalancerNotFoundException, TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException,
            TooManyTagsException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * Sets the type of IP addresses used by the subnets of the specified load balancer.
     * </p>
     *
     * @param setIpAddressTypeRequest
     * @return Result of the SetIpAddressType operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws InvalidSubnetException
     *         The specified subnet is out of available addresses.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetIpAddressType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetIpAddressType"
     *      target="_top">AWS API Documentation</a>
     */
    default SetIpAddressTypeResponse setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest)
            throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSubnetException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the type of IP addresses used by the subnets of the specified load balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIpAddressTypeRequest.Builder} avoiding the need
     * to create one manually via {@link SetIpAddressTypeRequest#builder()}
     * </p>
     *
     * @param setIpAddressTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest.Builder} to
     *        create a request.
     * @return Result of the SetIpAddressType operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws InvalidSubnetException
     *         The specified subnet is out of available addresses.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetIpAddressType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetIpAddressType"
     *      target="_top">AWS API Documentation</a>
     */
    default SetIpAddressTypeResponse setIpAddressType(Consumer<SetIpAddressTypeRequest.Builder> setIpAddressTypeRequest)
            throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSubnetException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return setIpAddressType(SetIpAddressTypeRequest.builder().applyMutation(setIpAddressTypeRequest).build());
    }

    /**
     * <p>
     * Sets the priorities of the specified rules.
     * </p>
     * <p>
     * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that
     * you do not specify retain their current priority.
     * </p>
     *
     * @param setRulePrioritiesRequest
     * @return Result of the SetRulePriorities operation returned by the service.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws PriorityInUseException
     *         The specified priority is in use.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetRulePriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetRulePriorities"
     *      target="_top">AWS API Documentation</a>
     */
    default SetRulePrioritiesResponse setRulePriorities(SetRulePrioritiesRequest setRulePrioritiesRequest)
            throws RuleNotFoundException, PriorityInUseException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the priorities of the specified rules.
     * </p>
     * <p>
     * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that
     * you do not specify retain their current priority.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetRulePrioritiesRequest.Builder} avoiding the need
     * to create one manually via {@link SetRulePrioritiesRequest#builder()}
     * </p>
     *
     * @param setRulePrioritiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest.Builder} to
     *        create a request.
     * @return Result of the SetRulePriorities operation returned by the service.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws PriorityInUseException
     *         The specified priority is in use.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetRulePriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetRulePriorities"
     *      target="_top">AWS API Documentation</a>
     */
    default SetRulePrioritiesResponse setRulePriorities(Consumer<SetRulePrioritiesRequest.Builder> setRulePrioritiesRequest)
            throws RuleNotFoundException, PriorityInUseException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return setRulePriorities(SetRulePrioritiesRequest.builder().applyMutation(setRulePrioritiesRequest).build());
    }

    /**
     * <p>
     * Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer.
     * The specified security groups override the previously associated security groups.
     * </p>
     * <p>
     * You can't perform this operation on a Network Load Balancer unless you specified a security group for the load
     * balancer when you created it.
     * </p>
     * <p>
     * You can't associate a security group with a Gateway Load Balancer.
     * </p>
     *
     * @param setSecurityGroupsRequest
     * @return Result of the SetSecurityGroups operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws InvalidSecurityGroupException
     *         The specified security group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SetSecurityGroupsResponse setSecurityGroups(SetSecurityGroupsRequest setSecurityGroupsRequest)
            throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSecurityGroupException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer.
     * The specified security groups override the previously associated security groups.
     * </p>
     * <p>
     * You can't perform this operation on a Network Load Balancer unless you specified a security group for the load
     * balancer when you created it.
     * </p>
     * <p>
     * You can't associate a security group with a Gateway Load Balancer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetSecurityGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link SetSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param setSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest.Builder} to
     *        create a request.
     * @return Result of the SetSecurityGroups operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws InvalidSecurityGroupException
     *         The specified security group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SetSecurityGroupsResponse setSecurityGroups(Consumer<SetSecurityGroupsRequest.Builder> setSecurityGroupsRequest)
            throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSecurityGroupException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return setSecurityGroups(SetSecurityGroupsRequest.builder().applyMutation(setSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer or
     * Network Load Balancer. The specified subnets replace the previously enabled subnets.
     * </p>
     * <p>
     * When you specify subnets for a Network Load Balancer, you must include all subnets that were enabled previously,
     * with their existing configurations, plus any additional subnets.
     * </p>
     *
     * @param setSubnetsRequest
     * @return Result of the SetSubnets operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SubnetNotFoundException
     *         The specified subnet does not exist.
     * @throws InvalidSubnetException
     *         The specified subnet is out of available addresses.
     * @throws AllocationIdNotFoundException
     *         The specified allocation ID does not exist.
     * @throws AvailabilityZoneNotSupportedException
     *         The specified Availability Zone is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default SetSubnetsResponse setSubnets(SetSubnetsRequest setSubnetsRequest) throws LoadBalancerNotFoundException,
            InvalidConfigurationRequestException, SubnetNotFoundException, InvalidSubnetException, AllocationIdNotFoundException,
            AvailabilityZoneNotSupportedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer or
     * Network Load Balancer. The specified subnets replace the previously enabled subnets.
     * </p>
     * <p>
     * When you specify subnets for a Network Load Balancer, you must include all subnets that were enabled previously,
     * with their existing configurations, plus any additional subnets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetSubnetsRequest.Builder} avoiding the need to
     * create one manually via {@link SetSubnetsRequest#builder()}
     * </p>
     *
     * @param setSubnetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest.Builder} to create a
     *        request.
     * @return Result of the SetSubnets operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SubnetNotFoundException
     *         The specified subnet does not exist.
     * @throws InvalidSubnetException
     *         The specified subnet is out of available addresses.
     * @throws AllocationIdNotFoundException
     *         The specified allocation ID does not exist.
     * @throws AvailabilityZoneNotSupportedException
     *         The specified Availability Zone is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default SetSubnetsResponse setSubnets(Consumer<SetSubnetsRequest.Builder> setSubnetsRequest)
            throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, SubnetNotFoundException,
            InvalidSubnetException, AllocationIdNotFoundException, AvailabilityZoneNotSupportedException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {
        return setSubnets(SetSubnetsRequest.builder().applyMutation(setSubnetsRequest).build());
    }

    /**
     * Create an instance of {@link ElasticLoadBalancingV2Waiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link ElasticLoadBalancingV2Waiter}
     */
    default ElasticLoadBalancingV2Waiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ElasticLoadBalancingV2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ElasticLoadBalancingV2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ElasticLoadBalancingV2Client}.
     */
    static ElasticLoadBalancingV2ClientBuilder builder() {
        return new DefaultElasticLoadBalancingV2ClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ElasticLoadBalancingV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
