/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of Docker images that are related by platform and are managed by CodeBuild.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentPlatform implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentPlatform.Builder, EnvironmentPlatform> {
    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(EnvironmentPlatform::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<List<EnvironmentLanguage>> LANGUAGES_FIELD = SdkField
            .<List<EnvironmentLanguage>> builder(MarshallingType.LIST)
            .memberName("languages")
            .getter(getter(EnvironmentPlatform::languages))
            .setter(setter(Builder::languages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentLanguage> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentLanguage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_FIELD,
            LANGUAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String platform;

    private final List<EnvironmentLanguage> languages;

    private EnvironmentPlatform(BuilderImpl builder) {
        this.platform = builder.platform;
        this.languages = builder.languages;
    }

    /**
     * <p>
     * The platform's name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform's name.
     * @see PlatformType
     */
    public final PlatformType platform() {
        return PlatformType.fromValue(platform);
    }

    /**
     * <p>
     * The platform's name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform's name.
     * @see PlatformType
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * For responses, this returns true if the service returned a value for the Languages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLanguages() {
        return languages != null && !(languages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of programming languages that are available for the specified platform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLanguages} method.
     * </p>
     * 
     * @return The list of programming languages that are available for the specified platform.
     */
    public final List<EnvironmentLanguage> languages() {
        return languages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLanguages() ? languages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentPlatform)) {
            return false;
        }
        EnvironmentPlatform other = (EnvironmentPlatform) obj;
        return Objects.equals(platformAsString(), other.platformAsString()) && hasLanguages() == other.hasLanguages()
                && Objects.equals(languages(), other.languages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentPlatform").add("Platform", platformAsString())
                .add("Languages", hasLanguages() ? languages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "languages":
            return Optional.ofNullable(clazz.cast(languages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentPlatform, T> g) {
        return obj -> g.apply((EnvironmentPlatform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentPlatform> {
        /**
         * <p>
         * The platform's name.
         * </p>
         * 
         * @param platform
         *        The platform's name.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform's name.
         * </p>
         * 
         * @param platform
         *        The platform's name.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(PlatformType platform);

        /**
         * <p>
         * The list of programming languages that are available for the specified platform.
         * </p>
         * 
         * @param languages
         *        The list of programming languages that are available for the specified platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(Collection<EnvironmentLanguage> languages);

        /**
         * <p>
         * The list of programming languages that are available for the specified platform.
         * </p>
         * 
         * @param languages
         *        The list of programming languages that are available for the specified platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(EnvironmentLanguage... languages);

        /**
         * <p>
         * The list of programming languages that are available for the specified platform.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage.Builder#build()} is called
         * immediately and its result is passed to {@link #languages(List<EnvironmentLanguage>)}.
         * 
         * @param languages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #languages(java.util.Collection<EnvironmentLanguage>)
         */
        Builder languages(Consumer<EnvironmentLanguage.Builder>... languages);
    }

    static final class BuilderImpl implements Builder {
        private String platform;

        private List<EnvironmentLanguage> languages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentPlatform model) {
            platform(model.platform);
            languages(model.languages);
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final List<EnvironmentLanguage.Builder> getLanguages() {
            List<EnvironmentLanguage.Builder> result = EnvironmentLanguagesCopier.copyToBuilder(this.languages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLanguages(Collection<EnvironmentLanguage.BuilderImpl> languages) {
            this.languages = EnvironmentLanguagesCopier.copyFromBuilder(languages);
        }

        @Override
        public final Builder languages(Collection<EnvironmentLanguage> languages) {
            this.languages = EnvironmentLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(EnvironmentLanguage... languages) {
            languages(Arrays.asList(languages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Consumer<EnvironmentLanguage.Builder>... languages) {
            languages(Stream.of(languages).map(c -> EnvironmentLanguage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EnvironmentPlatform build() {
            return new EnvironmentPlatform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
